/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyValue
extends BeanMetadataAttributeAccessor
implements Serializable {
    private final String name;
    private final Object value;
    private Object source;
    private boolean converted = false;
    private Object convertedValue;
    volatile Boolean conversionNecessary;
    volatile Object resolvedTokens;
    volatile PropertyDescriptor resolvedDescriptor;

    public PropertyValue(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public PropertyValue(PropertyValue original) {
        Assert.notNull((Object)original, (String)"Original must not be null");
        this.name = original.getName();
        this.value = original.getValue();
        this.source = original.getSource();
        this.converted = original.converted;
        this.convertedValue = original.convertedValue;
        this.conversionNecessary = original.conversionNecessary;
        this.resolvedTokens = original.resolvedTokens;
        this.resolvedDescriptor = original.resolvedDescriptor;
        this.copyAttributesFrom((AttributeAccessor)original);
    }

    public PropertyValue(PropertyValue original, Object newValue) {
        Assert.notNull((Object)original, (String)"Original must not be null");
        this.name = original.getName();
        this.value = newValue;
        this.source = original;
        this.conversionNecessary = original.conversionNecessary;
        this.resolvedTokens = original.resolvedTokens;
        this.resolvedDescriptor = original.resolvedDescriptor;
        this.copyAttributesFrom((AttributeAccessor)original);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public PropertyValue getOriginalPropertyValue() {
        PropertyValue original = this;
        while (original.source instanceof PropertyValue && original.source != original) {
            original = (PropertyValue)original.source;
        }
        return original;
    }

    public synchronized boolean isConverted() {
        return this.converted;
    }

    public synchronized void setConvertedValue(Object value) {
        this.converted = true;
        this.convertedValue = value;
    }

    public synchronized Object getConvertedValue() {
        return this.convertedValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyValue)) {
            return false;
        }
        PropertyValue otherPv = (PropertyValue)other;
        return this.name.equals(otherPv.name) && ObjectUtils.nullSafeEquals((Object)this.value, (Object)otherPv.value) && ObjectUtils.nullSafeEquals((Object)this.source, (Object)otherPv.source);
    }

    public int hashCode() {
        return this.name.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)this.value);
    }

    public String toString() {
        return "bean property '" + this.name + "'";
    }
}

