/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesException;
import org.apache.tiles.evaluator.el.ELAttributeEvaluator;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.servlet.context.wildcard.WildcardServletTilesApplicationContextFactory;
import org.apache.tiles.startup.BasicTilesInitializer;
import org.apache.tiles.startup.TilesInitializer;
import org.apache.tiles.web.util.ServletContextAdapter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;

public class TilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Properties tilesPropertyMap = new Properties();
    private ServletContext servletContext;

    public TilesConfigurer() {
        this.tilesPropertyMap.put("org.apache.tiles.context.AbstractTilesApplicationContextFactory", WildcardServletTilesApplicationContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", BasicPreparerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.locale.LocaleResolver", SpringLocaleResolver.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.evaluator.AttributeEvaluator", ELAttributeEvaluator.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(false));
    }

    public void setDefinitions(String[] definitions) {
        if (definitions != null) {
            String defs = StringUtils.arrayToCommaDelimitedString((Object[])definitions);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("TilesConfigurer: adding definitions [" + defs + "]"));
            }
            this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG", defs);
        }
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.toString(validateDefinitions));
    }

    public void setDefinitionsFactoryClass(Class definitionsFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", definitionsFactoryClass.getName());
    }

    public void setPreparerFactoryClass(Class preparerFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", preparerFactoryClass.getName());
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(useMutableTilesContainer));
    }

    public void setTilesProperties(Properties tilesProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)tilesProperties, (Map)this.tilesPropertyMap);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        ServletContextAdapter adaptedContext = new ServletContextAdapter((ServletConfig)new DelegatingServletConfig());
        this.createTilesInitializer().initialize((TilesApplicationContext)new ServletTilesApplicationContext((ServletContext)adaptedContext));
    }

    protected TilesInitializer createTilesInitializer() {
        return new BasicTilesInitializer();
    }

    public void destroy() throws TilesException {
        ServletUtil.setContainer((ServletContext)this.servletContext, null);
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return "TilesConfigurer";
        }

        public ServletContext getServletContext() {
            return TilesConfigurer.this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return TilesConfigurer.this.tilesPropertyMap.getProperty(paramName);
        }

        public Enumeration getInitParameterNames() {
            return TilesConfigurer.this.tilesPropertyMap.keys();
        }
    }
}

