/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private WebArgumentResolver[] customArgumentResolvers;

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    @Override
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Method handlerMethod;
        if (handler != null && (handlerMethod = this.findBestExceptionHandlerMethod(handler, ex)) != null) {
            ServletWebRequest webRequest = new ServletWebRequest(request, response);
            try {
                Object[] args = this.resolveHandlerArguments(handlerMethod, handler, (NativeWebRequest)webRequest, ex);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking request handler method: " + handlerMethod));
                }
                Object retVal = this.doInvokeMethod(handlerMethod, handler, args);
                return this.getModelAndView(retVal);
            }
            catch (Exception invocationEx) {
                this.logger.error((Object)("Invoking request method resulted in exception : " + handlerMethod), (Throwable)invocationEx);
            }
        }
        return null;
    }

    private Method findBestExceptionHandlerMethod(Object handler, Exception thrownException) {
        final Class<?> handlerType = handler.getClass();
        final Class<?> thrownExceptionType = thrownException.getClass();
        final LinkedHashMap<Class<? extends Throwable>, Method> resolverMethods = new LinkedHashMap<Class<? extends Throwable>, Method>();
        ReflectionUtils.doWithMethods(handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                method = ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType);
                List<Class<? extends Throwable>> handledExceptions = AnnotationMethodHandlerExceptionResolver.this.getHandledExceptions(method);
                for (Class<? extends Throwable> handledException : handledExceptions) {
                    if (!handledException.isAssignableFrom(thrownExceptionType)) continue;
                    if (!resolverMethods.containsKey(handledException)) {
                        resolverMethods.put(handledException, method);
                        continue;
                    }
                    Method oldMappedMethod = (Method)resolverMethods.get(handledException);
                    throw new IllegalStateException("Ambiguous exception handler mapped for " + handledException + "]: {" + oldMappedMethod + ", " + method + "}.");
                }
            }
        });
        return this.getBestMatchingMethod(thrownException, resolverMethods);
    }

    protected List<Class<? extends Throwable>> getHandledExceptions(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        ExceptionHandler exceptionHandler = method.getAnnotation(ExceptionHandler.class);
        if (exceptionHandler != null) {
            if (!ObjectUtils.isEmpty((Object[])exceptionHandler.value())) {
                result.addAll((Collection<Class<? extends Throwable>>)Arrays.asList(exceptionHandler.value()));
            } else {
                Class<?>[] classArray = method.getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> param = classArray[n2];
                    if (Throwable.class.isAssignableFrom(param)) {
                        result.add(param);
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    private Method getBestMatchingMethod(Exception thrownException, Map<Class<? extends Throwable>, Method> resolverMethods) {
        if (!resolverMethods.isEmpty()) {
            ArrayList handledExceptions = new ArrayList(resolverMethods.keySet());
            Collections.sort(handledExceptions, new DepthComparator(thrownException));
            Class bestMatchMethod = (Class)handledExceptions.get(0);
            return resolverMethods.get(bestMatchMethod);
        }
        return null;
    }

    private Object[] resolveHandlerArguments(Method handlerMethod, Object handler, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class<?>[] paramTypes = handlerMethod.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        Class<?> handlerType = handler.getClass();
        int i = 0;
        while (i < args.length) {
            MethodParameter methodParam = new MethodParameter(handlerMethod, i);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handlerType);
            Class paramType = methodParam.getParameterType();
            Object argValue = this.resolveCommonArgument(methodParam, webRequest, thrownException);
            if (argValue == WebArgumentResolver.UNRESOLVED) {
                throw new IllegalStateException("Unsupported argument [" + paramType.getName() + "] for @ExceptionHandler method: " + handlerMethod);
            }
            args[i] = argValue;
            ++i;
        }
        return args;
    }

    protected Object resolveCommonArgument(MethodParameter methodParameter, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class paramType;
        Object value;
        if (this.customArgumentResolvers != null) {
            WebArgumentResolver[] webArgumentResolverArray = this.customArgumentResolvers;
            int n = this.customArgumentResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                WebArgumentResolver argumentResolver = webArgumentResolverArray[n2];
                Object value2 = argumentResolver.resolveArgument(methodParameter, webRequest);
                if (value2 != WebArgumentResolver.UNRESOLVED) {
                    return value2;
                }
                ++n2;
            }
        }
        if ((value = this.resolveStandardArgument(paramType = methodParameter.getParameterType(), webRequest, thrownException)) != WebArgumentResolver.UNRESOLVED && !ClassUtils.isAssignableValue((Class)paramType, (Object)value)) {
            throw new IllegalStateException("Standard argument type [" + paramType.getName() + "] resolved to incompatible value of type [" + (value != null ? value.getClass() : null) + "]. Consider declaring the argument type in a less specific fashion.");
        }
        return value;
    }

    protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        if (WebRequest.class.isAssignableFrom(parameterType)) {
            return webRequest;
        }
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse();
        if (ServletRequest.class.isAssignableFrom(parameterType)) {
            return request;
        }
        if (ServletResponse.class.isAssignableFrom(parameterType)) {
            return response;
        }
        if (HttpSession.class.isAssignableFrom(parameterType)) {
            return request.getSession();
        }
        if (Principal.class.isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (Locale.class.equals((Object)parameterType)) {
            return RequestContextUtils.getLocale(request);
        }
        if (InputStream.class.isAssignableFrom(parameterType)) {
            return request.getInputStream();
        }
        if (Reader.class.isAssignableFrom(parameterType)) {
            return request.getReader();
        }
        if (OutputStream.class.isAssignableFrom(parameterType)) {
            return response.getOutputStream();
        }
        if (Writer.class.isAssignableFrom(parameterType)) {
            return response.getWriter();
        }
        if (parameterType.isInstance(thrownException)) {
            return thrownException;
        }
        return WebArgumentResolver.UNRESOLVED;
    }

    private Object doInvokeMethod(Method method, Object target, Object[] args) throws Exception {
        ReflectionUtils.makeAccessible((Method)method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            throw new IllegalStateException("Should never get here");
        }
    }

    private ModelAndView getModelAndView(Object returnValue) {
        if (returnValue instanceof ModelAndView) {
            return (ModelAndView)returnValue;
        }
        if (returnValue instanceof Model) {
            return new ModelAndView().addAllObjects(((Model)returnValue).asMap());
        }
        if (returnValue instanceof Map) {
            return new ModelAndView().addAllObjects((Map)returnValue);
        }
        if (returnValue instanceof View) {
            return new ModelAndView((View)returnValue);
        }
        if (returnValue instanceof String) {
            return new ModelAndView((String)returnValue);
        }
        if (returnValue == null) {
            return null;
        }
        throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DepthComparator
    implements Comparator<Class<? extends Throwable>> {
        private final Class<? extends Throwable> handlerExceptionType;

        private DepthComparator(Exception handlerException) {
            this.handlerExceptionType = handlerException.getClass();
        }

        @Override
        public int compare(Class<? extends Throwable> o1, Class<? extends Throwable> o2) {
            int depth1 = this.getDepth(o1, 0);
            int depth2 = this.getDepth(o2, 0);
            return depth2 - depth1;
        }

        private int getDepth(Class exceptionType, int depth) {
            if (exceptionType.equals(this.handlerExceptionType)) {
                return depth;
            }
            if (Throwable.class.equals((Object)exceptionType)) {
                return -1;
            }
            return this.getDepth(exceptionType.getSuperclass(), depth + 1);
        }
    }
}

