/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<MediaType> supportedMediaTypes = Collections.emptyList();

    protected AbstractHttpMessageConverter() {
    }

    protected AbstractHttpMessageConverter(MediaType supportedMediaType) {
        this.supportedMediaTypes = Collections.singletonList(supportedMediaType);
    }

    protected AbstractHttpMessageConverter(MediaType ... supportedMediaTypes) {
        this.supportedMediaTypes = Arrays.asList(supportedMediaTypes);
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"'supportedMediaTypes' must not be empty");
        this.supportedMediaTypes = new ArrayList<MediaType>(supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    @Override
    public final T read(Class<T> clazz, HttpInputMessage inputMessage) throws IOException {
        return this.readInternal(clazz, inputMessage);
    }

    protected abstract T readInternal(Class<T> var1, HttpInputMessage var2) throws IOException, HttpMessageNotReadableException;

    @Override
    public final void write(T t, HttpOutputMessage outputMessage) throws IOException {
        Long contentLength;
        HttpHeaders headers = outputMessage.getHeaders();
        MediaType contentType = this.getContentType(t);
        if (contentType != null) {
            headers.setContentType(contentType);
        }
        if ((contentLength = this.getContentLength(t)) != null) {
            headers.setContentLength(contentLength);
        }
        this.writeInternal(t, outputMessage);
        outputMessage.getBody().flush();
    }

    protected MediaType getContentType(T t) {
        List<MediaType> mediaTypes = this.getSupportedMediaTypes();
        return !mediaTypes.isEmpty() ? mediaTypes.get(0) : null;
    }

    protected Long getContentLength(T t) {
        return null;
    }

    protected abstract void writeInternal(T var1, HttpOutputMessage var2) throws IOException, HttpMessageNotWritableException;
}

