/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtils {
    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static void mergeArrayIntoCollection(Object array, Collection collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        Object[] objectArray = arr = ObjectUtils.toObjectArray(array);
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            collection.add(elem);
            ++n2;
        }
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.getProperty(key);
                if (value == null) {
                    value = props.get(key);
                }
                map.put(key, value);
            }
        }
    }

    public static boolean contains(Iterator iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection collection, Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static Object findValueOfType(Collection collection, Class[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        Class[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

