/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToEnumFactory
implements ConverterFactory<String, Enum> {
    @Override
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum<T>(targetType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringToEnum<T extends Enum>
    implements Converter<String, T>,
    ConverterInfo {
        private final Class<T> enumType;

        public StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        public Class<String> getSourceType() {
            return String.class;
        }

        public Class<T> getTargetType() {
            return this.enumType;
        }

        @Override
        public T convert(String source) throws Exception {
            if ("".equals(source)) {
                return null;
            }
            return Enum.valueOf(this.enumType, source.trim());
        }
    }
}

