/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

class StringArrayToMap
implements ConversionExecutor {
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;
    private final GenericConversionService conversionService;
    private final MapEntryConverter entryConverter;

    public StringArrayToMap(TypeDescriptor sourceType, TypeDescriptor targetType, GenericConversionService conversionService) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.conversionService = conversionService;
        this.entryConverter = this.createEntryConverter();
    }

    private MapEntryConverter createEntryConverter() {
        if (this.targetType.isMapEntryTypeKnown()) {
            ConversionExecutor keyConverter = this.conversionService.getConversionExecutor(String.class, TypeDescriptor.valueOf(this.targetType.getMapKeyType()));
            ConversionExecutor valueConverter = this.conversionService.getConversionExecutor(String.class, TypeDescriptor.valueOf(this.targetType.getMapValueType()));
            return new MapEntryConverter(keyConverter, valueConverter);
        }
        return MapEntryConverter.NO_OP_INSTANCE;
    }

    public Object execute(Object source) throws ConversionFailedException {
        try {
            int length = Array.getLength(source);
            Map targetMap = CollectionFactory.createMap(this.targetType.getType(), length);
            int i = 0;
            while (i < length) {
                String property = (String)Array.get(source, i);
                String[] fields = property.split("=");
                if (fields.length < 2) {
                    throw new IllegalArgumentException("Invalid String property: " + property);
                }
                String key = fields[0];
                String value = fields[1];
                targetMap.put(this.entryConverter.convertKey(key), this.entryConverter.convertValue(value));
                ++i;
            }
            return targetMap;
        }
        catch (Exception ex) {
            throw new ConversionFailedException(source, this.sourceType.getType(), this.targetType.getType(), ex);
        }
    }
}

