/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConversionExecutor;

class StaticConversionExecutor
implements ConversionExecutor {
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;
    private final Converter converter;

    public StaticConversionExecutor(TypeDescriptor sourceType, TypeDescriptor targetType, Converter converter) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.converter = converter;
    }

    public Object execute(Object source) throws ConversionFailedException {
        if (source == null) {
            return null;
        }
        if (!this.sourceType.isAssignableValue(source)) {
            throw new ConversionFailedException(source, this.sourceType.getType(), this.targetType.getType(), "Source object " + source + " to convert is expected to be an instance of [" + this.sourceType.getName() + "]");
        }
        try {
            return this.converter.convert(source);
        }
        catch (Exception ex) {
            throw new ConversionFailedException(source, this.sourceType.getType(), this.targetType.getType(), ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticConversionExecutor)) {
            return false;
        }
        StaticConversionExecutor other = (StaticConversionExecutor)obj;
        return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
    }

    public int hashCode() {
        return this.sourceType.hashCode() + this.targetType.hashCode();
    }
}

