/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterInfo;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ArrayToArray;
import org.springframework.core.convert.support.ArrayToCollection;
import org.springframework.core.convert.support.CollectionToArray;
import org.springframework.core.convert.support.CollectionToCollection;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.MapToMap;
import org.springframework.core.convert.support.MapToStringArray;
import org.springframework.core.convert.support.MapToStringCollection;
import org.springframework.core.convert.support.NoOpConversionExecutor;
import org.springframework.core.convert.support.ObjectToArray;
import org.springframework.core.convert.support.ObjectToCollection;
import org.springframework.core.convert.support.StaticConversionExecutor;
import org.springframework.core.convert.support.StringArrayToMap;
import org.springframework.core.convert.support.StringCollectionToMap;
import org.springframework.core.convert.support.StringToArray;
import org.springframework.core.convert.support.StringToCollection;
import org.springframework.core.convert.support.StringToMap;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConversionService
implements ConversionService,
ConverterRegistry {
    private ConversionService parent;
    private final Map<Class, Map<Class, Object>> sourceTypeConverters = new HashMap<Class, Map<Class, Object>>();

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public ConversionService getParent() {
        return this.parent;
    }

    public void add(Converter converter) {
        List<Class> typeInfo = this.getRequiredTypeInfo(converter);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetType <T> your Converter<S, T> converts between");
        }
        Class sourceType = typeInfo.get(0);
        Class targetType = typeInfo.get(1);
        this.getSourceMap(sourceType).put(targetType, converter);
    }

    @Override
    public void add(ConverterFactory<?, ?> converterFactory) {
        List<Class> typeInfo = this.getRequiredTypeInfo(converterFactory);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetType <T> your ConverterFactory<S, T> creates Converters to convert between");
        }
        Class sourceType = typeInfo.get(0);
        Class targetType = typeInfo.get(1);
        this.getSourceMap(sourceType).put(targetType, converterFactory);
    }

    @Override
    public void removeConverter(Class<?> sourceType, Class<?> targetType) {
        Map<Class, Object> sourceMap = this.getSourceMap(sourceType);
        sourceMap.remove(targetType);
    }

    public void removeConverterFactory(ConverterFactory<?, ?> converter) {
        List<Class> typeInfo = this.getRequiredTypeInfo(converter);
        Class sourceType = typeInfo.get(0);
        Class targetType = typeInfo.get(1);
        Map<Class, Object> sourceMap = this.getSourceMap(sourceType);
        ConverterFactory existing = (ConverterFactory)sourceMap.get(targetType);
        if (converter == existing) {
            sourceMap.remove(targetType);
        }
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(sourceType, TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(Class<?> sourceType, TypeDescriptor targetType) {
        ConversionExecutor executor = this.getConversionExecutor(sourceType, targetType);
        return executor != null || this.parent != null && this.parent.canConvert(sourceType, targetType);
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.convert(source, TypeDescriptor.valueOf(targetType));
    }

    @Override
    public Object convert(Object source, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        ConversionExecutor executor = this.getConversionExecutor(source.getClass(), targetType);
        if (executor != null) {
            return executor.execute(source);
        }
        if (this.parent != null) {
            return this.parent.convert(source, targetType);
        }
        throw new ConverterNotFoundException(source.getClass(), targetType.getType(), "No converter found that can convert from sourceType [" + source.getClass().getName() + "] to targetType [" + targetType.getName() + "]");
    }

    ConversionExecutor getConversionExecutor(Class<?> sourceClass, TypeDescriptor targetType) throws ConverterNotFoundException {
        Assert.notNull(sourceClass, "The sourceType to convert from is required");
        Assert.notNull(targetType, "The targetType to convert to is required");
        if (targetType.getType() == null) {
            return NoOpConversionExecutor.INSTANCE;
        }
        TypeDescriptor sourceType = TypeDescriptor.valueOf(sourceClass);
        if (sourceType.isArray()) {
            if (targetType.isArray()) {
                return new ArrayToArray(sourceType, targetType, this);
            }
            if (targetType.isCollection()) {
                if (targetType.isAbstractClass()) {
                    throw new IllegalArgumentException("Conversion target class [" + targetType.getName() + "] is invalid; cannot convert to abstract collection types--" + "request an interface or concrete implementation instead");
                }
                return new ArrayToCollection(sourceType, targetType, this);
            }
            if (targetType.isMap()) {
                if (sourceType.getElementType().equals(String.class)) {
                    return new StringArrayToMap(sourceType, targetType, this);
                }
                return null;
            }
            if (targetType.getType().equals(String.class)) {
                return null;
            }
            return null;
        }
        if (sourceType.isCollection()) {
            if (targetType.isCollection()) {
                return new CollectionToCollection(sourceType, targetType, this);
            }
            if (targetType.isArray()) {
                return new CollectionToArray(sourceType, targetType, this);
            }
            if (targetType.isMap()) {
                if (sourceType.getElementType().equals(String.class)) {
                    return new StringCollectionToMap(sourceType, targetType, this);
                }
                return null;
            }
            if (targetType.getType().equals(String.class)) {
                return null;
            }
            return null;
        }
        if (sourceType.isMap()) {
            if (targetType.isMap()) {
                return new MapToMap(sourceType, targetType, this);
            }
            if (targetType.isArray()) {
                if (targetType.getElementType().equals(String.class)) {
                    return new MapToStringArray(targetType, this);
                }
                return null;
            }
            if (targetType.isCollection()) {
                if (targetType.getElementType().equals(String.class)) {
                    return new MapToStringCollection(targetType, this);
                }
                return null;
            }
            return null;
        }
        if (targetType.isArray()) {
            if (sourceType.getType().equals(String.class)) {
                return new StringToArray(sourceType, targetType, this);
            }
            return new ObjectToArray(sourceType, targetType, this);
        }
        if (targetType.isCollection()) {
            if (sourceType.getType().equals(String.class)) {
                return new StringToCollection(sourceType, targetType, this);
            }
            return new ObjectToCollection(sourceType, targetType, this);
        }
        if (targetType.isMap()) {
            if (sourceType.getType().equals(String.class)) {
                return new StringToMap(sourceType, targetType, this);
            }
            return null;
        }
        if (sourceType.isAssignableTo(targetType)) {
            return NoOpConversionExecutor.INSTANCE;
        }
        Converter converter = this.findRegisteredConverter(ClassUtils.resolvePrimitiveIfNecessary(sourceType.getType()), ClassUtils.resolvePrimitiveIfNecessary(targetType.getType()));
        if (converter != null) {
            return new StaticConversionExecutor(sourceType, targetType, converter);
        }
        return null;
    }

    private List<Class> getRequiredTypeInfo(Object converter) {
        ArrayList<Class> typeInfo = new ArrayList<Class>(2);
        if (converter instanceof ConverterInfo) {
            ConverterInfo info = (ConverterInfo)converter;
            typeInfo.add(info.getSourceType());
            typeInfo.add(info.getTargetType());
            return typeInfo;
        }
        return this.getConverterTypeInfo(converter.getClass());
    }

    private List<Class> getConverterTypeInfo(Class converterClass) {
        Class classToIntrospect = converterClass;
        while (classToIntrospect != null) {
            Type[] ifcs;
            Type[] typeArray = ifcs = classToIntrospect.getGenericInterfaces();
            int n = ifcs.length;
            int n2 = 0;
            while (n2 < n) {
                Type ifc = typeArray[n2];
                if (ifc instanceof ParameterizedType) {
                    ParameterizedType paramIfc = (ParameterizedType)ifc;
                    Type rawType = paramIfc.getRawType();
                    if (Converter.class.equals((Object)rawType) || ConverterFactory.class.equals((Object)rawType)) {
                        Type arg2;
                        ArrayList<Class> typeInfo = new ArrayList<Class>(2);
                        Type arg1 = paramIfc.getActualTypeArguments()[0];
                        if (arg1 instanceof TypeVariable) {
                            arg1 = GenericTypeResolver.resolveTypeVariable((TypeVariable)arg1, converterClass);
                        }
                        if (arg1 instanceof Class) {
                            typeInfo.add((Class)arg1);
                        }
                        if ((arg2 = paramIfc.getActualTypeArguments()[1]) instanceof TypeVariable) {
                            arg2 = GenericTypeResolver.resolveTypeVariable((TypeVariable)arg2, converterClass);
                        }
                        if (arg2 instanceof Class) {
                            typeInfo.add((Class)arg2);
                        }
                        if (typeInfo.size() == 2) {
                            return typeInfo;
                        }
                    } else if (Converter.class.isAssignableFrom((Class)rawType)) {
                        return this.getConverterTypeInfo((Class)rawType);
                    }
                } else if (Converter.class.isAssignableFrom((Class)ifc)) {
                    return this.getConverterTypeInfo((Class)ifc);
                }
                ++n2;
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return null;
    }

    private Map<Class, Object> getSourceMap(Class sourceType) {
        Map<Class, Object> sourceMap = this.sourceTypeConverters.get(sourceType);
        if (sourceMap == null) {
            sourceMap = new HashMap<Class, Object>();
            this.sourceTypeConverters.put(sourceType, sourceMap);
        }
        return sourceMap;
    }

    private Converter findRegisteredConverter(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                Map<Class, Object> converters = this.getConvertersForSource(currentClass);
                Converter converter = this.getConverter(converters, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            Map<Class, Object> objectConverters = this.getConvertersForSource(Object.class);
            return this.getConverter(objectConverters, targetType);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            Map<Class, Object> converters = this.getConvertersForSource(currentClass);
            Converter converter = this.getConverter(converters, targetType);
            if (converter != null) {
                return converter;
            }
            if (currentClass.getSuperclass() != null) {
                classQueue.addFirst(currentClass.getSuperclass());
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                classQueue.addFirst(ifc);
                ++n3;
            }
        }
        return null;
    }

    private Map<Class, Object> getConvertersForSource(Class<?> sourceType) {
        Map<Class<Object>, Object> converters = this.sourceTypeConverters.get(sourceType);
        if (converters == null) {
            converters = Collections.emptyMap();
        }
        return converters;
    }

    private Converter getConverter(Map<Class, Object> converters, Class<?> targetType) {
        if (targetType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                Converter converter = this.getConverter(converters, currentClass, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            return this.getConverter(converters, Object.class, targetType);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            Converter converter = this.getConverter(converters, currentClass, targetType);
            if (converter != null) {
                return converter;
            }
            if (currentClass.getSuperclass() != null) {
                classQueue.addFirst(currentClass.getSuperclass());
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                classQueue.addFirst(ifc);
                ++n3;
            }
        }
        return null;
    }

    private Converter getConverter(Map<Class, Object> converters, Class<?> currentClass, Class<?> targetType) {
        Object converter = converters.get(currentClass);
        if (converter == null) {
            return null;
        }
        if (converter instanceof Converter) {
            return (Converter)converter;
        }
        return ((ConverterFactory)converter).getConverter(targetType);
    }
}

