/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.AbstractCollectionConverter;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.NoOpConversionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionToCollection
extends AbstractCollectionConverter {
    public CollectionToCollection(TypeDescriptor sourceCollectionType, TypeDescriptor targetCollectionType, GenericConversionService conversionService) {
        super(sourceCollectionType, targetCollectionType, conversionService);
    }

    @Override
    protected Object doExecute(Object source) throws Exception {
        Collection sourceCollection = (Collection)source;
        Collection targetCollection = CollectionFactory.createCollection(this.getTargetCollectionType(), sourceCollection.size());
        ConversionExecutor elementConverter = this.getElementConverter(sourceCollection);
        for (Object aSourceCollection : sourceCollection) {
            targetCollection.add(elementConverter.execute(aSourceCollection));
        }
        return targetCollection;
    }

    private ConversionExecutor getElementConverter(Collection<?> source) {
        ConversionExecutor elementConverter = this.getElementConverter();
        if (elementConverter == NoOpConversionExecutor.INSTANCE && this.getTargetElementType() != null) {
            for (Object value : source) {
                if (value == null) continue;
                elementConverter = this.getConversionService().getConversionExecutor(value.getClass(), TypeDescriptor.valueOf(this.getTargetElementType()));
                break;
            }
        }
        return elementConverter;
    }
}

