/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.AbstractCollectionConverter;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.NoOpConversionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionToArray
extends AbstractCollectionConverter {
    public CollectionToArray(TypeDescriptor sourceCollectionType, TypeDescriptor targetArrayType, GenericConversionService conversionService) {
        super(sourceCollectionType, targetArrayType, conversionService);
    }

    @Override
    protected Object doExecute(Object source) throws Exception {
        Collection collection = (Collection)source;
        Object array = Array.newInstance(this.getTargetElementType(), collection.size());
        int i = 0;
        ConversionExecutor elementConverter = this.getElementConverter(collection);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Array.set(array, i, elementConverter.execute(it.next()));
            ++i;
        }
        return array;
    }

    private ConversionExecutor getElementConverter(Collection<?> source) {
        ConversionExecutor elementConverter = this.getElementConverter();
        if (elementConverter == NoOpConversionExecutor.INSTANCE) {
            for (Object value : source) {
                if (value == null) continue;
                elementConverter = this.getConversionService().getConversionExecutor(value.getClass(), TypeDescriptor.valueOf(this.getTargetElementType()));
                break;
            }
        }
        return elementConverter != null ? elementConverter : NoOpConversionExecutor.INSTANCE;
    }
}

