/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.AbstractCollectionConverter;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;

class ArrayToCollection
extends AbstractCollectionConverter {
    public ArrayToCollection(TypeDescriptor sourceArrayType, TypeDescriptor targetCollectionType, GenericConversionService conversionService) {
        super(sourceArrayType, targetCollectionType, conversionService);
    }

    protected Object doExecute(Object sourceArray) throws Exception {
        int length = Array.getLength(sourceArray);
        Collection collection = CollectionFactory.createCollection(this.getTargetCollectionType(), length);
        ConversionExecutor elementConverter = this.getElementConverter();
        int i = 0;
        while (i < length) {
            collection.add(elementConverter.execute(Array.get(sourceArray, i)));
            ++i;
        }
        return collection;
    }
}

