/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.NoOpConversionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCollectionConverter
implements ConversionExecutor {
    private final GenericConversionService conversionService;
    private final TypeDescriptor sourceCollectionType;
    private final TypeDescriptor targetCollectionType;
    private final ConversionExecutor elementConverter;

    public AbstractCollectionConverter(TypeDescriptor sourceCollectionType, TypeDescriptor targetCollectionType, GenericConversionService conversionService) {
        ConversionExecutor executor;
        this.conversionService = conversionService;
        this.sourceCollectionType = sourceCollectionType;
        this.targetCollectionType = targetCollectionType;
        Class<?> sourceElementType = sourceCollectionType.getElementType();
        Class<?> targetElementType = targetCollectionType.getElementType();
        this.elementConverter = sourceElementType != null && targetElementType != null ? ((executor = conversionService.getConversionExecutor(sourceElementType, TypeDescriptor.valueOf(targetElementType))) != null ? executor : NoOpConversionExecutor.INSTANCE) : NoOpConversionExecutor.INSTANCE;
    }

    protected Class<?> getTargetCollectionType() {
        return this.targetCollectionType.getType();
    }

    protected Class<?> getTargetElementType() {
        return this.targetCollectionType.getElementType();
    }

    protected GenericConversionService getConversionService() {
        return this.conversionService;
    }

    protected ConversionExecutor getElementConverter() {
        return this.elementConverter;
    }

    @Override
    public Object execute(Object source) {
        try {
            return this.doExecute(source);
        }
        catch (Exception ex) {
            throw new ConversionFailedException(source, this.sourceCollectionType.getType(), this.targetCollectionType.getType(), ex);
        }
    }

    protected abstract Object doExecute(Object var1) throws Exception;
}

