/*
 * Decompiled with CFR 0.152.
 */
package com.bukalapak.neuro;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.bukalapak.neuro.AxonBranch;
import com.bukalapak.neuro.Neuro;
import com.bukalapak.neuro.Nucleus;
import com.bukalapak.neuro.OptWave;
import com.bukalapak.neuro.OptWaves;
import com.bukalapak.neuro.Signal;
import com.bukalapak.neuro.Soma;
import com.bukalapak.neuro.SomaOnly;
import com.bukalapak.neuro.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nJ\u001c\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020#J6\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\"\u0010-\u001a\u0016\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010.j\u0002`/2\u0006\u0010)\u001a\u00020*Jv\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00042\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(22\b\u0002\u00102\u001a,\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0010j\u0004\u0018\u0001`\u00152\b\b\u0002\u0010+\u001a\u00020,2\u001c\b\u0002\u00103\u001a\u0016\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010.j\u0002`/J\u000e\u00104\u001a\u0004\u0018\u00010**\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R6\u0010\u0005\u001a$\u0012\u0004\u0012\u00020\u0007\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006j\u0002`\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRp\u0010\u000e\u001aX\u0012*\u0012(\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010j\u0002`\u0015\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u0002`\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000fj\u0004\u0018\u0001`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/bukalapak/neuro/Neuro;", "", "()V", "TAG", "", "neurons", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/bukalapak/neuro/Nucleus;", "", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Lcom/bukalapak/neuro/AxonBranch;", "Lcom/bukalapak/neuro/AxonTerminal;", "getNeurons$neuro_release", "()Ljava/util/concurrent/ConcurrentSkipListMap;", "preprocessor", "Lkotlin/Function3;", "Lkotlin/Function2;", "Lkotlin/Function1;", "Lcom/bukalapak/neuro/Signal;", "", "Lcom/bukalapak/neuro/SignalAction;", "Lcom/bukalapak/neuro/AxonProcessor;", "Lcom/bukalapak/neuro/AxonPreprocessor;", "getPreprocessor", "()Lkotlin/jvm/functions/Function3;", "setPreprocessor", "(Lkotlin/jvm/functions/Function3;)V", "terminalComparator", "Ljava/util/Comparator;", "connect", "soma", "Lcom/bukalapak/neuro/Soma;", "branch", "branches", "", "Lcom/bukalapak/neuro/SomaOnly;", "extractSignal", "chosenNucleus", "Lcom/bukalapak/neuro/Nucleus$Chosen;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "args", "Landroid/os/Bundle;", "findRoute", "Lkotlin/Pair;", "Lcom/bukalapak/neuro/NeuronRoute;", "proceed", "url", "axonProcessor", "route", "toOptimizedUri", "neuro_release"})
public final class Neuro {
    private static final String TAG = "Neuro";
    @NotNull
    private static final ConcurrentSkipListMap<Nucleus, ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>>> neurons;
    @Nullable
    private static Function3<? super Function2<? super Function1<? super Signal, Unit>, ? super Signal, Unit>, ? super Function1<? super Signal, Unit>, ? super Signal, Unit> preprocessor;
    private static final Comparator<Integer> terminalComparator;
    public static final Neuro INSTANCE;

    @NotNull
    public final ConcurrentSkipListMap<Nucleus, ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>>> getNeurons$neuro_release() {
        return neurons;
    }

    @Nullable
    public final Function3<Function2<? super Function1<? super Signal, Unit>, ? super Signal, Unit>, Function1<? super Signal, Unit>, Signal, Unit> getPreprocessor() {
        return preprocessor;
    }

    public final void setPreprocessor(@Nullable Function3<? super Function2<? super Function1<? super Signal, Unit>, ? super Signal, Unit>, ? super Function1<? super Signal, Unit>, ? super Signal, Unit> function3) {
        preprocessor = function3;
    }

    public final void connect(@NotNull Soma soma, @NotNull List<AxonBranch> branches) {
        boolean bl;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)soma, (String)"soma");
            Intrinsics.checkParameterIsNotNull(branches, (String)"branches");
            Iterable $receiver$iv = branches;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AxonBranch it = (AxonBranch)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)it.getExpression())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new IllegalArgumentException("One/more of branch expression is blank");
        }
        ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>> concurrentSkipListMap = neurons.get(soma);
        if (concurrentSkipListMap == null) {
            Neuro neuro = this;
            Neuro $noName_0 = neuro;
            boolean bl3 = false;
            ConcurrentSkipListMap newTerminal = new ConcurrentSkipListMap(terminalComparator);
            Map $i$f$any = neurons;
            Soma soma2 = soma;
            ConcurrentSkipListMap concurrentSkipListMap2 = newTerminal;
            $i$f$any.put(soma2, concurrentSkipListMap2);
            concurrentSkipListMap = newTerminal;
        }
        Intrinsics.checkExpressionValueIsNotNull(concurrentSkipListMap, (String)"neurons[soma] ?: let { _\u2026    newTerminal\n        }");
        ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>> terminal = concurrentSkipListMap;
        Iterable $receiver$iv = branches;
        for (Object element$iv : $receiver$iv) {
            AxonBranch branch = (AxonBranch)element$iv;
            boolean bl4 = false;
            String cleanExpression = StringsKt.removePrefix((String)branch.getExpression(), (CharSequence)"/");
            int literalPathCount = StringsKt.split$default((CharSequence)cleanExpression, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null).size();
            CharSequence charSequence = cleanExpression;
            Regex regex = UtilsKt.getPATTERNED_REGEX();
            boolean hasPatternedRegex = regex.containsMatchIn(charSequence);
            int usedIndex = hasPatternedRegex ? -literalPathCount : literalPathCount;
            ConcurrentSkipListSet<AxonBranch> concurrentSkipListSet = terminal.get(usedIndex);
            if (concurrentSkipListSet == null) {
                Neuro neuro;
                Neuro it = neuro = INSTANCE;
                boolean bl5 = false;
                ConcurrentSkipListSet newBranches = new ConcurrentSkipListSet();
                Map map = terminal;
                Integer n = usedIndex;
                ConcurrentSkipListSet concurrentSkipListSet2 = newBranches;
                map.put(n, concurrentSkipListSet2);
                concurrentSkipListSet = newBranches;
            }
            Intrinsics.checkExpressionValueIsNotNull(concurrentSkipListSet, (String)"terminal[usedIndex] ?: l\u2026newBranches\n            }");
            ConcurrentSkipListSet<AxonBranch> usedBranches = concurrentSkipListSet;
            usedBranches.add(branch);
        }
    }

    public final void connect(@NotNull Soma soma, @NotNull AxonBranch branch) {
        Intrinsics.checkParameterIsNotNull((Object)soma, (String)"soma");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        this.connect(soma, CollectionsKt.listOf((Object)branch));
    }

    public final void connect(@NotNull SomaOnly soma) {
        Intrinsics.checkParameterIsNotNull((Object)soma, (String)"soma");
        ConcurrentSkipListMap dummy = new ConcurrentSkipListMap();
        Map map = neurons;
        ConcurrentSkipListMap concurrentSkipListMap = dummy;
        map.put(soma, concurrentSkipListMap);
    }

    public final void proceed(@NotNull String url, @Nullable Context context, @Nullable Function2<? super Function1<? super Signal, Unit>, ? super Signal, Unit> axonProcessor, @NotNull Bundle args, @Nullable Pair<Nucleus.Chosen, AxonBranch> route) {
        Function2 function2;
        Function3 usedAxonPreprocessor2;
        Pair<Nucleus.Chosen, AxonBranch> parts;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Log.i((String)TAG, (String)("Starting time: " + String.valueOf(System.currentTimeMillis())));
        Log.i((String)TAG, (String)("Transporting url " + url));
        Uri uri = this.toOptimizedUri(url);
        if (uri == null) {
            throw (Throwable)new IllegalArgumentException("Url is not valid");
        }
        Uri uri2 = uri;
        Pair<Nucleus.Chosen, AxonBranch> pair = route;
        if (pair == null) {
            pair = parts = this.findRoute(uri2);
        }
        if (parts == null) {
            Log.e((String)TAG, (String)("Url " + url + " has no route"));
            return;
        }
        Log.i((String)TAG, (String)("Routing via " + ((Nucleus.Chosen)parts.getFirst()).getNucleus() + " and " + (AxonBranch)parts.getSecond()));
        Nucleus.Chosen chosenNucleus = (Nucleus.Chosen)parts.getFirst();
        Nucleus nucleus = chosenNucleus.getNucleus();
        AxonBranch branch = (AxonBranch)parts.getSecond();
        Signal signal = this.extractSignal(chosenNucleus, context, branch, uri2, args);
        if (signal == null) {
            Log.e((String)TAG, (String)("Url " + url + " has no successful match"));
            return;
        }
        Nucleus nucleus2 = nucleus;
        if (nucleus2 instanceof Soma) {
            boolean transportDone = ((Soma)nucleus).onSomaProcess(signal);
            if (transportDone) {
                Log.i((String)TAG, (String)"Nucleus transporter returned false");
                return;
            }
        } else if (nucleus2 instanceof SomaOnly) {
            ((SomaOnly)nucleus).onSomaProcess(signal);
        }
        if (branch == null) {
            return;
        }
        Function3 function3 = preprocessor;
        if (function3 == null) {
            function3 = usedAxonPreprocessor2 = (Function3)proceed.usedAxonPreprocessor.1.INSTANCE;
        }
        if ((function2 = axonProcessor) == null) {
            function2 = proceed.usedAxonProcessor.1.INSTANCE;
        }
        Function2 usedAxonProcessor2 = function2;
        Log.i((String)TAG, (String)("Finishing time: " + String.valueOf(System.currentTimeMillis())));
        usedAxonPreprocessor2.invoke((Object)usedAxonProcessor2, branch.getAction(), (Object)signal);
    }

    public static /* synthetic */ void proceed$default(Neuro neuro, String string, Context context, Function2 function2, Bundle bundle, Pair pair, int n, Object object) {
        if ((n & 2) != 0) {
            context = null;
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        if ((n & 8) != 0) {
            bundle = new Bundle();
        }
        if ((n & 0x10) != 0) {
            pair = null;
        }
        neuro.proceed(string, context, (Function2<? super Function1<? super Signal, Unit>, ? super Signal, Unit>)function2, bundle, (Pair<Nucleus.Chosen, AxonBranch>)pair);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Nucleus.Chosen, AxonBranch> findRoute(@NotNull Uri uri) {
        AxonBranch axonBranch;
        Object object;
        Object object22;
        String path;
        block20: {
            block19: {
                Object v1;
                Object object3;
                int port;
                String host;
                String scheme;
                block17: {
                    Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                    scheme = uri.getScheme();
                    host = uri.getHost();
                    port = uri.getPort();
                    path = uri.getPath();
                    NavigableSet navigableSet = (NavigableSet)neurons.keySet();
                    Intrinsics.checkExpressionValueIsNotNull((Object)navigableSet, (String)"neurons.keys");
                    object3 = CollectionsKt.asSequence((Iterable)navigableSet);
                    Sequence sequence = object3;
                    for (Object object22 : sequence) {
                        Nucleus it = (Nucleus)object22;
                        boolean bl = false;
                        if (!it.isMatch$neuro_release(scheme, host, port)) continue;
                        v1 = object22;
                        break block17;
                    }
                    v1 = null;
                }
                if ((object = (Nucleus)v1) == null) break block19;
                Object it = object3 = object;
                boolean bl = false;
                object = ((Nucleus)it).nominate$neuro_release(scheme, host, port);
                if (object != null) break block20;
            }
            return null;
        }
        Object chosenNucleus = object;
        Nucleus nucleus = ((Nucleus.Chosen)chosenNucleus).getNucleus();
        ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>> concurrentSkipListMap = neurons.get(nucleus);
        if (concurrentSkipListMap == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(concurrentSkipListMap, (String)"neurons[nucleus] ?: return null");
        ConcurrentSkipListMap<Integer, ConcurrentSkipListSet<AxonBranch>> chosenTerminal = concurrentSkipListMap;
        object22 = nucleus;
        if (object22 instanceof SomaOnly) {
            axonBranch = null;
        } else if (object22 instanceof Soma) {
            int pathCount = uri.getPathSegments().size();
            if (pathCount == 0) {
                axonBranch = ((Soma)nucleus).getNoBranchAction$neuro_release();
            } else {
                AxonBranch matchedBranch;
                Iterator iterator;
                block18: {
                    Map.Entry entry;
                    Map.Entry $index_$_$;
                    Map $receiver$iv$iv;
                    Map $receiver$iv;
                    Map map = chosenTerminal;
                    Iterable iterable = $receiver$iv;
                    Object destination$iv$iv = new LinkedHashMap();
                    Object object4 = $receiver$iv$iv;
                    Iterator iterator22 = object4.entrySet().iterator();
                    while (iterator22.hasNext()) {
                        Map.Entry element$iv$iv;
                        $index_$_$ = element$iv$iv = iterator22.next();
                        boolean bl = false;
                        entry = $index_$_$;
                        int index = ((Number)entry.getKey()).intValue();
                        if (!(index == pathCount || index >= -pathCount && index < 0)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $receiver$iv = destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList($receiver$iv.size());
                    object4 = $receiver$iv$iv;
                    for (Map.Entry item$iv$iv : object4.entrySet()) {
                        ConcurrentSkipListSet branches;
                        void $$_$_branches;
                        $index_$_$ = item$iv$iv;
                        Object object5 = destination$iv$iv;
                        boolean bl = false;
                        entry = $$_$_branches;
                        ConcurrentSkipListSet concurrentSkipListSet = branches = (ConcurrentSkipListSet)entry.getValue();
                        object5.add(concurrentSkipListSet);
                    }
                    List possibleBranches = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    Iterable iterable2 = iterable = (Iterable)possibleBranches;
                    for (Iterator iterator22 : iterable2) {
                        AxonBranch it = (AxonBranch)((Object)iterator22);
                        boolean bl = false;
                        if (!it.isMatch$neuro_release(path)) continue;
                        iterator = iterator22;
                        break block18;
                    }
                    iterator = null;
                }
                if ((axonBranch = (matchedBranch = (AxonBranch)((Object)iterator))) == null) {
                    axonBranch = ((Soma)nucleus).getOtherBranchAction$neuro_release();
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AxonBranch branch = axonBranch;
        return TuplesKt.to((Object)chosenNucleus, branch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Uri toOptimizedUri(@NotNull String $receiver) {
        Uri uri;
        String path;
        Uri uri2;
        Uri uri3 = uri2 = Uri.parse((String)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri3, (String)"uri");
        String string = path = uri3.getPath();
        if (string != null) {
            if (StringsKt.endsWith$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null)) {
                String optimizedPath = StringsKt.removeSuffix((String)path, (CharSequence)"/");
                CharSequence charSequence = optimizedPath;
                String usedPath = charSequence.length() > 0 ? optimizedPath : null;
                uri = new Uri.Builder().scheme(uri2.getScheme()).authority(uri2.getAuthority()).fragment(uri2.getFragment()).query(uri2.getQuery()).path(usedPath).build();
                return uri;
            }
        }
        uri = uri2;
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    private final Signal extractSignal(Nucleus.Chosen chosenNucleus, Context context, AxonBranch branch, Uri uri, Bundle args) {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder $receiver;
        StringBuilder stringBuilder2;
        block23: {
            block22: {
                String string;
                StringBuilder stringBuilder3;
                String string2;
                StringBuilder stringBuilder4;
                Object object2;
                block21: {
                    block20: {
                        String it;
                        String string3;
                        StringBuilder stringBuilder5;
                        block19: {
                            block18: {
                                $receiver = stringBuilder2 = new StringBuilder();
                                boolean bl = false;
                                stringBuilder5 = $receiver;
                                string3 = chosenNucleus.getScheme();
                                if (string3 == null) break block18;
                                object2 = string3;
                                stringBuilder4 = stringBuilder5;
                                it = object2;
                                boolean bl2 = false;
                                string2 = it + "://";
                                stringBuilder5 = stringBuilder4;
                                string3 = string2;
                                if (string3 != null) break block19;
                            }
                            string3 = "(?:[^:]*://)?";
                        }
                        stringBuilder5.append(string3);
                        stringBuilder3 = $receiver;
                        string = chosenNucleus.getHost();
                        if (string == null) break block20;
                        object2 = string;
                        stringBuilder4 = stringBuilder3;
                        it = object2;
                        boolean bl = false;
                        string2 = it;
                        stringBuilder3 = stringBuilder4;
                        string = string2;
                        if (string != null) break block21;
                    }
                    string = "(?:[^/|:]+)?";
                }
                stringBuilder3.append(string);
                stringBuilder = $receiver;
                object = chosenNucleus.getPort();
                if (object == null) break block22;
                object2 = object;
                stringBuilder4 = stringBuilder;
                int it = ((Number)object2).intValue();
                boolean bl = false;
                string2 = "" + ':' + it;
                stringBuilder = stringBuilder4;
                object = string2;
                if (object != null) break block23;
            }
            object = "(?::[^/]*)?";
        }
        stringBuilder.append((String)object);
        Object object3 = branch;
        if (object3 == null || (object3 = ((AxonBranch)object3).getExpression()) == null) {
            object3 = "(?:/.+)?";
        }
        $receiver.append((String)object3);
        String string = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026)?\")\n        }.toString()");
        String expression = string;
        String string4 = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"uri.toString()");
        String cleanUrl = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string4, (char[])new char[]{'#'}, (boolean)false, (int)0, (int)6, null))), (char[])new char[]{'?'}, (boolean)false, (int)0, (int)6, null));
        String pattern2 = UtilsKt.toPattern(expression);
        Matcher matcher = Pattern.compile(pattern2).matcher(cleanUrl);
        List variableNames = new ArrayList();
        Matcher variableMatcher = Pattern.compile("<(\\w+)(:([^>]+))?>").matcher(expression);
        while (variableMatcher.find()) {
            String string5 = variableMatcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"variableMatcher.group(1)");
            variableNames.add(string5);
        }
        if (!matcher.matches()) {
            return null;
        }
        OptWave variables = new OptWave();
        Iterable $receiver$iv = variableNames;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void name;
            String value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string6 = (String)item$iv;
            int index = n2;
            boolean bl = false;
            String string7 = value = matcher.group(index + 1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"value");
            variables.put((String)name, string7);
        }
        String fragment = uri.getFragment();
        OptWaves queries = new OptWaves();
        CharSequence charSequence = uri.getQuery();
        if (!(charSequence == null || charSequence.length() == 0)) {
            try {
                Set names;
                Set set = names = uri.getQueryParameterNames();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"names");
                Iterable $receiver$iv2 = set;
                for (Object element$iv : $receiver$iv2) {
                    List list;
                    String string8;
                    String it = (String)element$iv;
                    boolean bl = false;
                    Map map = queries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri.getQueryParameters(it), (String)"uri.getQueryParameters(it)");
                    map.put(string8, list);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string9 = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"uri.toString()");
        return new Signal(context, uri, string9, variables, queries, fragment, args);
    }

    private Neuro() {
    }

    static {
        Neuro neuro;
        INSTANCE = neuro = new Neuro();
        neurons = new ConcurrentSkipListMap();
        terminalComparator = terminalComparator.1.INSTANCE;
    }
}

