/*
 * Decompiled with CFR 0.152.
 */
package com.xxc.dev.permission;

import android.content.Context;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import com.xxc.dev.permission.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Sudo {
    public static final String TAG = "Sudo";
    private static final Sudo INSTANCE = new Sudo();

    public static Sudo getInstance() {
        return INSTANCE;
    }

    private Sudo() {
    }

    public static boolean hasPermission(Context context, String permission) {
        return Sudo.checkPermission(context, permission);
    }

    public static boolean hasPermission(Context context, String[] permissions) {
        if (null == context || null == permissions) {
            return false;
        }
        for (String permission : permissions) {
            boolean result = Sudo.hasPermission(context, permission);
            if (result) continue;
            return false;
        }
        return true;
    }

    public List<String> getUnauthorizedPermission(Context context, List<String> permissions) {
        if (null == context || null == permissions) {
            return new ArrayList<String>();
        }
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (Sudo.hasPermission(context, permission)) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions;
    }

    public List<String> getUnauthorizedPermission(Context context, String[] permissions) {
        return this.getUnauthorizedPermission(context, Arrays.asList(permissions));
    }

    public PermissionHandler prepare() {
        return new PermissionHandler();
    }

    private static boolean checkPermission(Context context, String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0 && PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
    }
}

