/*
 * Decompiled with CFR 0.152.
 */
package com.xxc.dev.permission;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.xxc.dev.permission.PermissionCallBack;
import com.xxc.dev.permission.PermissionFragment;
import com.xxc.dev.permission.PermissionFragmentV4;
import com.xxc.dev.permission.SettingInfo;
import com.xxc.dev.permission.Sudo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class PermissionHandler {
    public static final int DEFAULT_REQUEST_PERMISSION_CODE = 128;
    static final int START_SETTING_CODE = 2048;
    private String[] mPermissions;
    private PermissionCallBack mGranted;
    private PermissionCallBack mRefused;
    private PermissionCallBack mNeverAsk;
    private int mRequestCode = 128;
    private SettingInfo mSettingInfo = new SettingInfo();

    String[] getPermissions() {
        return this.mPermissions;
    }

    public PermissionHandler setPermissions(String[] permissions) {
        this.mPermissions = permissions;
        return this;
    }

    public PermissionHandler setPermission(String permission) {
        this.mPermissions = new String[]{permission};
        return this;
    }

    PermissionCallBack getGranted() {
        return this.mGranted;
    }

    public PermissionHandler setGranted(PermissionCallBack granted) {
        this.mGranted = granted;
        return this;
    }

    PermissionCallBack getRefused() {
        return this.mRefused;
    }

    public PermissionHandler setRefused(PermissionCallBack refused) {
        this.mRefused = refused;
        return this;
    }

    PermissionCallBack getNeverAsk() {
        return this.mNeverAsk;
    }

    public PermissionHandler setNeverAsk(PermissionCallBack neverAsk) {
        this.mNeverAsk = neverAsk;
        return this;
    }

    int getRequestCode() {
        return this.mRequestCode;
    }

    public PermissionHandler setRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    SettingInfo getSettingInfo() {
        return this.mSettingInfo;
    }

    public PermissionHandler setSettingInfo(SettingInfo settingInfo) {
        this.mSettingInfo = settingInfo;
        return this;
    }

    public void request(androidx.fragment.app.Fragment fragment) {
        FragmentActivity host = fragment.getActivity();
        if (host != null) {
            this.request(host);
        }
    }

    public void request(Fragment fragment) {
        if (fragment != null && null != fragment.getActivity()) {
            this.request(fragment.getActivity());
        }
    }

    public void request(Activity activity) {
        if (null == activity || null == this.mPermissions || null == this.mGranted) {
            return;
        }
        if (Sudo.hasPermission((Context)activity, this.mPermissions)) {
            this.mGranted.onCallBack(Arrays.asList(this.mPermissions));
            return;
        }
        android.app.FragmentManager manager = activity.getFragmentManager();
        Fragment fragment = manager.findFragmentByTag("PermissionFragment");
        if (fragment instanceof PermissionFragment) {
            ((PermissionFragment)fragment).doRequest(this);
            return;
        }
        manager.beginTransaction().add((Fragment)new PermissionFragment().setPermission(this), "PermissionFragment").commitAllowingStateLoss();
    }

    public void request(FragmentActivity activity) {
        if (activity == null || null == this.mPermissions || null == this.mGranted) {
            return;
        }
        if (Sudo.hasPermission((Context)activity, this.mPermissions)) {
            this.mGranted.onCallBack(Arrays.asList(this.mPermissions));
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        androidx.fragment.app.Fragment fragment = fm.findFragmentByTag("PermissionFragmentTag");
        if (fragment instanceof PermissionFragmentV4) {
            ((PermissionFragmentV4)fragment).doRequest(this);
            return;
        }
        fm.beginTransaction().add((androidx.fragment.app.Fragment)new PermissionFragmentV4().setPermission(this), "PermissionFragmentTag").commitAllowingStateLoss();
    }

    void processPermissionResult(Activity activity, int requestCode, String[] permissions, int[] grantResults, DialogInterface.OnClickListener clickListener) {
        if (null == activity) {
            return;
        }
        if (this.mNeverAsk == null) {
            this.mNeverAsk = strings -> {
                DialogInterface.OnClickListener cancelClick = (dialog, which) -> dialog.dismiss();
                Dialog settingDialog = SettingInfo.createDialog(activity, this.mSettingInfo, clickListener, cancelClick);
                settingDialog.show();
            };
        }
        if (requestCode == this.mRequestCode) {
            this.handleResult(activity, permissions, grantResults);
        } else {
            Log.e((String)"Sudo", (String)("request code error:" + this.mRequestCode + "   " + requestCode));
        }
    }

    void handleResult(Activity activity, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (Sudo.hasPermission((Context)activity, permissions)) {
            if (this.mGranted != null) {
                this.mGranted.onCallBack(Arrays.asList(permissions));
            }
        } else {
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            ArrayList<String> neverAskPermissions = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) continue;
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions[i])) {
                    deniedPermissions.add(permissions[i]);
                    continue;
                }
                neverAskPermissions.add(permissions[i]);
            }
            if (this.isCollectionEmpty(neverAskPermissions)) {
                if (this.mRefused != null) {
                    this.mRefused.onCallBack(deniedPermissions);
                }
            } else if (this.mNeverAsk != null) {
                this.mNeverAsk.onCallBack(neverAskPermissions);
            }
        }
    }

    void handleActivityResult(Activity activity) {
        if (null == activity) {
            return;
        }
        if (Sudo.hasPermission((Context)activity, this.mPermissions)) {
            if (null != this.mGranted) {
                this.mGranted.onCallBack(Arrays.asList(this.mPermissions));
            }
        } else if (null != this.mRefused) {
            this.mRefused.onCallBack(Sudo.getInstance().getUnauthorizedPermission((Context)activity, this.mPermissions));
        } else {
            activity.finish();
        }
    }

    boolean isCollectionEmpty(Collection collection) {
        return null == collection || collection.size() == 0;
    }
}

