/*
 * Decompiled with CFR 0.152.
 */
package com.xxc.dev.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.xxc.dev.permission.PermissionHandler;

public class PermissionFragment
extends Fragment {
    public static final String TAG = "PermissionFragment";
    private PermissionHandler mPermission;

    public PermissionFragment setPermission(PermissionHandler permission) {
        this.mPermission = permission;
        return this;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.doRequest(this.mPermission);
    }

    void doRequest(PermissionHandler permission) {
        if (permission == null) {
            return;
        }
        String[] permissions = permission.getPermissions();
        if (permissions != null && permissions.length > 0) {
            Activity activity = this.getActivity();
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(permission.getPermissions(), permission.getRequestCode());
            } else {
                int[] grantResults = new int[permissions.length];
                PackageManager packageManager = activity.getPackageManager();
                String packageName = activity.getPackageName();
                int permissionCount = permissions.length;
                for (int i = 0; i < permissionCount; ++i) {
                    grantResults[i] = packageManager.checkPermission(permissions[i], packageName);
                }
                this.onRequestPermissionsResult(permission.getRequestCode(), permissions, grantResults);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2048 && null != this.mPermission) {
            this.mPermission.handleActivityResult(this.getActivity());
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Activity activity = this.getActivity();
        if (this.mPermission != null && null != activity) {
            this.mPermission.processPermissionResult(activity, requestCode, permissions, grantResults, (dialog, which) -> {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
                intent.setData(uri);
                this.startActivityForResult(intent, 2048);
            });
        }
    }
}

