/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.maven.plugins.artifactversions.util;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class VersionUtil {
    private VersionUtil() {
    }

    public static Set<String> getQualifiers(String aVersionString) {
        if (aVersionString == null || aVersionString.length() == 0) {
            return Collections.emptySet();
        }
        TreeSet<String> qualifiers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Tokenizer tok = new Tokenizer(aVersionString);
        while (tok.next()) {
            qualifiers.add(tok.getQualifier());
        }
        return qualifiers;
    }

    private static final class Tokenizer {
        private int index;
        private final int length;
        private String qualifier;
        private final String version;

        private Tokenizer(String aVersion) {
            this.version = aVersion;
            this.length = this.version.length();
        }

        public String getQualifier() {
            return this.qualifier;
        }

        public boolean next() {
            while (this.index < this.length) {
                if (!this.nextQualifier()) continue;
                return true;
            }
            return false;
        }

        private boolean nextQualifier() {
            if (this.index >= this.length) {
                return false;
            }
            int start = -1;
            int end = -1;
            while (this.index < this.length) {
                char c = this.version.charAt(this.index);
                if ('.' == c || '-' == c || '_' == c) {
                    if (end == -1) {
                        end = this.index;
                    }
                    ++this.index;
                    break;
                }
                if (Character.isDigit(c)) {
                    if (start > -1) {
                        end = this.index;
                    }
                } else if (start == -1) {
                    start = this.index;
                }
                ++this.index;
            }
            if (start > -1) {
                this.qualifier = this.version.substring(start, end != -1 ? end : this.length);
                return true;
            }
            return false;
        }
    }
}

