/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.maven.plugins.artifactversions;

import com.mpobjects.maven.plugins.artifactversions.GetMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="unpack", requiresProject=false, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class UnpackMojo
extends GetMojo {
    @Component
    private ArchiverManager archiverManager;
    @Parameter(property="mdep.unpack.encoding")
    private String encoding;
    @Parameter(property="mdep.unpack.excludes")
    private String excludes;
    @Parameter(property="dependency.ignorePermissions", defaultValue="false")
    private boolean ignorePermissions;
    @Parameter(property="mdep.unpack.includes")
    private String includes;
    @Parameter(property="outputDirectory", required=true)
    private File outputDirectory;

    @Override
    protected void processArtifactResult(ArtifactResult aResult) throws MojoExecutionException {
        File file = aResult.getArtifact().getFile();
        try {
            if (!this.outputDirectory.mkdirs()) {
                this.getLog().debug((CharSequence)("mkdirs() failed for " + this.outputDirectory));
            }
            if (!this.outputDirectory.exists()) {
                throw new MojoExecutionException("Location to write unpacked files to could not be created: " + this.outputDirectory);
            }
            UnArchiver unArchiver = this.getUnArchiver(aResult.getArtifact().getExtension(), file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(this.outputDirectory);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + this.outputDirectory + System.lineSeparator() + e.toString(), (Exception)((Object)e));
        }
    }

    private FileSelector[] getFileSelectors() {
        if (StringUtils.isEmpty((String)this.excludes) && StringUtils.isEmpty((String)this.includes)) {
            return new FileSelector[0];
        }
        IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
        if (StringUtils.isNotEmpty((String)this.excludes)) {
            selector.setExcludes(this.excludes.split(","));
        }
        if (StringUtils.isNotEmpty((String)this.includes)) {
            selector.setIncludes(this.includes.split(","));
        }
        return new FileSelector[]{selector};
    }

    private UnArchiver getUnArchiver(String aExtension, File aFile) throws NoSuchArchiverException {
        UnArchiver unArchiver;
        try {
            unArchiver = this.archiverManager.getUnArchiver(aExtension);
            this.getLog().debug((CharSequence)("Found unArchiver by type: " + unArchiver));
        }
        catch (NoSuchArchiverException e) {
            unArchiver = this.archiverManager.getUnArchiver(aFile);
            this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
        }
        if (this.encoding != null && unArchiver instanceof ZipUnArchiver) {
            ((ZipUnArchiver)unArchiver).setEncoding(this.encoding);
            this.getLog().info((CharSequence)("Unpacks '" + aExtension + "' with encoding '" + this.encoding + "'."));
        }
        unArchiver.setIgnorePermissions(this.ignorePermissions);
        unArchiver.setFileSelectors(this.getFileSelectors());
        return unArchiver;
    }
}

