/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.maven.plugins.artifactversions;

import com.mpobjects.maven.plugins.artifactversions.AbstractVersionsMojo;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.version.Version;

@Mojo(name="get", requiresProject=false, threadSafe=true)
public class GetMojo
extends AbstractVersionsMojo {
    @Parameter(property="artifactProperty")
    private String artifactProperty;
    @Parameter(property="offset")
    private int offset;

    protected void processArtifactResult(ArtifactResult aResult) throws MojoExecutionException {
    }

    @Override
    protected void processArtifactVersions(Artifact aArtifact, List<Version> aVersions) throws MojoExecutionException, MojoFailureException {
        ArtifactResult result;
        this.offset = Math.max(0, this.offset);
        if (this.offset >= aVersions.size()) {
            throw new MojoExecutionException("No version available at offset " + this.offset + " for artifact: " + aArtifact);
        }
        Version version = aVersions.get(aVersions.size() - this.offset - 1);
        Artifact getArtifact = aArtifact.setVersion(version.toString());
        ArtifactRequest request = new ArtifactRequest(getArtifact, this.getRemoteRepositories(), "");
        try {
            this.getLog().info((CharSequence)("Resolving " + getArtifact));
            result = this.repositorySystem.resolveArtifact(this.session.getRepositorySession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isNotEmpty((String)this.artifactProperty) && this.session.getCurrentProject() != null) {
            this.session.getCurrentProject().getProperties().setProperty(this.artifactProperty, result.getArtifact().toString());
        }
        this.processArtifactResult(result);
    }
}

