/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.maven.plugins.artifactversions;

import com.mpobjects.maven.plugins.artifactversions.GetMojo;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="copy", requiresProject=false, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class CopyMojo
extends GetMojo {
    @Parameter(property="outputFile")
    private File outputFile;

    protected File getDestination() {
        if (this.outputFile != null) {
            return this.outputFile;
        }
        return null;
    }

    @Override
    protected void processArtifactResult(ArtifactResult aResult) throws MojoExecutionException {
        File file = aResult.getArtifact().getFile();
        File destinationFile = this.getDestination();
        try {
            FileUtils.copyFile((File)file, (File)destinationFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException((Object)file, "Cannot copy to " + destinationFile, "Unable to copy file from " + file + " to " + destinationFile);
        }
    }
}

