/*
 * Decompiled with CFR 0.152.
 */
package com.mpobjects.maven.plugins.artifactversions;

import com.mpobjects.maven.plugins.artifactversions.util.VersionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

public abstract class AbstractVersionsMojo
extends AbstractMojo {
    private static final Pattern REPO_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="excludeQualifiers")
    private String excludeQualifiers;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter
    private Set<String> qualifiersExcluded;
    @Parameter
    private Set<String> qualifiersRequired;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="requireQualifiers")
    private String requireQualifiers;
    @Parameter
    private boolean skip;
    @Parameter(property="version", defaultValue="[0,)")
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (this.qualifiersExcluded == null) {
            this.qualifiersExcluded = new HashSet<String>(Arrays.asList(StringUtils.split((String)Objects.toString(this.excludeQualifiers, ""), (String)",")));
        }
        if (this.qualifiersRequired == null) {
            this.qualifiersRequired = new HashSet<String>(Arrays.asList(StringUtils.split((String)Objects.toString(this.requireQualifiers, ""), (String)",")));
        }
        try {
            VersionRangeRequest request = this.createVersionRangeRequest(this.createArtifact());
            this.getLog().info((CharSequence)("Resolving " + request.getArtifact()));
            VersionRangeResult response = this.repositorySystem.resolveVersionRange(this.session.getRepositorySession(), request);
            this.processVersionRangeResponse(response);
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException("Failed retrieving artifact version range information.", (Exception)((Object)e));
        }
    }

    protected boolean acceptedVersion(Version aVersion) {
        if (this.qualifiersRequired.isEmpty() && this.qualifiersExcluded.isEmpty()) {
            return true;
        }
        Set<String> qualifiers = VersionUtil.getQualifiers(aVersion.toString());
        if (!this.qualifiersRequired.isEmpty()) {
            if (!this.qualifiersRequired.stream().allMatch(qualifiers::contains)) {
                return false;
            }
        }
        return !this.qualifiersExcluded.stream().anyMatch(qualifiers::contains);
    }

    protected VersionRangeRequest createVersionRangeRequest(Artifact aArtifact) throws MojoFailureException {
        VersionRangeRequest request = new VersionRangeRequest();
        request.setArtifact(aArtifact);
        request.setRepositories(this.getRemoteRepositories());
        return request;
    }

    protected List<RemoteRepository> getRemoteRepositories() throws MojoFailureException {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        if (this.session.getCurrentProject() != null) {
            for (org.apache.maven.model.Repository repo : this.session.getCurrentProject().getRepositories()) {
                repos.add(this.toRemoteRepository(repo));
            }
        }
        List activeProfiles = this.session.getSettings().getActiveProfiles();
        for (Profile profile : this.session.getSettings().getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            for (Repository repo : profile.getRepositories()) {
                repos.add(this.toRemoteRepository(repo));
            }
        }
        repos = this.repositorySystem.newResolutionRepositories(this.session.getRepositorySession(), repos);
        for (RemoteRepository repo : this.repositorySystem.newResolutionRepositories(this.session.getRepositorySession(), this.parseRemoteRepositories())) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo);
            builder.setId(String.format("%s-%x", repo.getId(), System.identityHashCode(repo)));
            repos.add(builder.build());
        }
        return repos;
    }

    protected abstract void processArtifactVersions(Artifact var1, List<Version> var2) throws MojoExecutionException, MojoFailureException;

    protected void processVersionRangeResponse(VersionRangeResult aResponse) throws MojoExecutionException, MojoFailureException {
        Artifact art = aResponse.getRequest().getArtifact();
        List<Version> versions = aResponse.getVersions().stream().filter(this::acceptedVersion).collect(Collectors.toList());
        this.processArtifactVersions(art, versions);
    }

    private Artifact createArtifact() throws MojoFailureException {
        if (this.artifact != null) {
            String[] tokens = this.artifact.split(":");
            if (tokens.length < 2 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId[:version[:packaging[:classifier]]] " + this.artifact);
            }
            String lver = "[0,)";
            String lpack = "jar";
            String lclass = "";
            if (tokens.length > 2 && !"".equals(tokens[2])) {
                lver = tokens[2];
            }
            if (tokens.length > 3 && !"".equals(tokens[3])) {
                lpack = tokens[3];
            }
            if (tokens.length > 4 && !"".equals(tokens[4])) {
                lclass = tokens[4];
            }
            return new DefaultArtifact(tokens[0], tokens[1], lclass, lpack, lver);
        }
        return new DefaultArtifact(this.groupId, this.artifactId, this.classifier, this.packaging, this.version);
    }

    private List<RemoteRepository> parseRemoteRepositories() throws MojoFailureException {
        if (this.remoteRepositories == null) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(StringUtils.split((String)this.remoteRepositories, (String)",")).map(this::parseRepositoryLocation).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private RemoteRepository parseRepositoryLocation(String aRepo) {
        RepositoryPolicy always = new RepositoryPolicy(true, "always", "warn");
        if (aRepo.contains("::")) {
            Matcher matcher = REPO_PATTERN.matcher(aRepo);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid syntax for repository: " + aRepo + ". Use \"id::layout::url\" or \"URL\".");
            }
            String type = matcher.group(2);
            if ("".equals(type)) {
                type = "default";
            }
            return new RemoteRepository.Builder(matcher.group(1), type, matcher.group(3)).setPolicy(always).build();
        }
        return new RemoteRepository.Builder("temp", "default", aRepo).setPolicy(always).build();
    }

    private RemoteRepository toRemoteRepository(org.apache.maven.model.Repository aRepo) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(aRepo.getId(), aRepo.getLayout(), aRepo.getUrl());
        builder.setReleasePolicy(this.toRepositoryPolicy(aRepo.getReleases()));
        builder.setSnapshotPolicy(this.toRepositoryPolicy(aRepo.getSnapshots()));
        return builder.build();
    }

    private RemoteRepository toRemoteRepository(Repository aRepo) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(aRepo.getId(), aRepo.getLayout(), aRepo.getUrl());
        builder.setReleasePolicy(this.toRepositoryPolicy(aRepo.getReleases()));
        builder.setSnapshotPolicy(this.toRepositoryPolicy(aRepo.getSnapshots()));
        return builder.build();
    }

    private RepositoryPolicy toRepositoryPolicy(org.apache.maven.model.RepositoryPolicy aPolicy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (aPolicy != null) {
            enabled = aPolicy.isEnabled();
            if (aPolicy.getUpdatePolicy() != null) {
                updates = aPolicy.getUpdatePolicy();
            }
            if (aPolicy.getChecksumPolicy() != null) {
                checksums = aPolicy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }

    private RepositoryPolicy toRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy aPolicy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (aPolicy != null) {
            enabled = aPolicy.isEnabled();
            if (aPolicy.getUpdatePolicy() != null) {
                updates = aPolicy.getUpdatePolicy();
            }
            if (aPolicy.getChecksumPolicy() != null) {
                checksums = aPolicy.getChecksumPolicy();
            }
        }
        return new RepositoryPolicy(enabled, updates, checksums);
    }
}

