/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.moxie.client.R;
import com.moxie.client.a.h;
import com.moxie.client.model.TitleParams;
import com.proguard.annotation.NotProguard;

@NotProguard
public class TitleLayout
extends RelativeLayout {
    private View mTitleLayoutView;
    private RelativeLayout mRelativeLayout_Title_Left;
    private RelativeLayout mRelativeLayout_Title_Right;
    private RelativeLayout mRelativeLayout_Close_Left;
    private TextView mTextTitle;
    private ImageView mImageLeft;
    private ImageView mImageRight;
    private ImageView mImageClose;
    private TextView mLeftTextView;
    private Context mContext;
    private boolean showCloseIcon = true;

    public TitleLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    public TitleLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public TitleLayout(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        context = LayoutInflater.from((Context)context);
        context = context.inflate(R.layout.moxie_client_common_title, (ViewGroup)this);
        this.mTextTitle = (TextView)context.findViewById(R.id.textview_title);
        this.mImageLeft = (ImageView)context.findViewById(R.id.moxie_client_imageview_left);
        this.mImageRight = (ImageView)context.findViewById(R.id.moxie_client_imageview_right);
        this.mImageClose = (ImageView)context.findViewById(R.id.moxie_client_imageview_close_left);
        this.mTitleLayoutView = context.findViewById(R.id.moxie_client_relativelayout_title);
        this.mRelativeLayout_Title_Left = (RelativeLayout)context.findViewById(R.id.moxie_client_relativelayout_title_left);
        this.mRelativeLayout_Title_Right = (RelativeLayout)context.findViewById(R.id.moxie_client_relativelayout_title_right);
        this.mLeftTextView = (TextView)context.findViewById(R.id.moxie_client_actionbar_left_text);
        this.mRelativeLayout_Close_Left = (RelativeLayout)context.findViewById(R.id.moxie_client_relativelayout_close_left);
    }

    public void setTitle(int n2) {
        try {
            this.mTextTitle.setText(n2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void setTitle(String string2) {
        this.mTextTitle.setText((CharSequence)string2);
    }

    public View getLeftTextView() {
        if (this.showCloseIcon) {
            return this.mRelativeLayout_Close_Left;
        }
        return this.mLeftTextView;
    }

    public ImageView getLeftImage() {
        return this.mImageLeft;
    }

    public RelativeLayout getRelativeLayout_Title_Left() {
        return this.mRelativeLayout_Title_Left;
    }

    public RelativeLayout getRelativeLayout_Title_Right() {
        return this.mRelativeLayout_Title_Right;
    }

    public ImageView getRightImage() {
        return this.mImageRight;
    }

    public void setLeftTextVisibility(int n2) {
        if (this.showCloseIcon) {
            this.mRelativeLayout_Close_Left.setVisibility(n2);
            return;
        }
        this.mLeftTextView.setVisibility(n2);
    }

    public void setImageRightVisibility(int n2) {
        Object object = h.e().a() != null ? h.e().a().getTitleParams() : null;
        if (object != null) {
            if (n2 == 0) {
                this.mImageRight.setVisibility(0);
                return;
            }
            this.mImageRight.setVisibility(8);
            return;
        }
        Object object2 = object = h.e().a() != null ? h.e().a().getBannerTxtColor() : "#ffffff";
        if (n2 == 0) {
            if (((String)object).toLowerCase().equalsIgnoreCase("#ffffff") || ((String)object).toLowerCase().equalsIgnoreCase("#ffffffff") || ((String)object).toLowerCase().equalsIgnoreCase("#000000") || ((String)object).toLowerCase().equalsIgnoreCase("#ff000000")) {
                this.mImageRight.setVisibility(0);
                return;
            }
            this.mImageRight.setVisibility(8);
            return;
        }
        this.mImageRight.setVisibility(8);
    }

    public void initTitleLayout() {
        try {
            Object object = h.e().a() != null ? h.e().a().getTitleParams() : null;
            if (object != null) {
                if (((TitleParams)object).isImmersedEnable()) {
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    if (Build.VERSION.SDK_INT >= 19) {
                        if (this.mContext instanceof Activity) {
                            ((Activity)this.mContext).getWindow().addFlags(0x4000000);
                        }
                        float f2 = 70.0f;
                        Context context = this.mContext;
                        float f3 = context.getResources().getDisplayMetrics().density;
                        layoutParams.height = (int)(70.0f * f3 + 0.5f);
                    }
                    this.setLayoutParams(layoutParams);
                }
                int n2 = ((TitleParams)object).getLeftImgResId();
                int n3 = ((TitleParams)object).getRightImgResId();
                int n4 = ((TitleParams)object).getTitleColor();
                int n5 = ((TitleParams)object).getLeftImgPressedResId();
                int n6 = ((TitleParams)object).getRightImgPressedResId();
                int n7 = ((TitleParams)object).getBackgroundColor();
                int n8 = ((TitleParams)object).getBackgroundDrawable();
                int n9 = ((TitleParams)object).getLeftTextColor();
                int n10 = ((TitleParams)object).getLeftCloseResId();
                int n11 = ((TitleParams)object).getLeftClosePressedResId();
                object = ((TitleParams)object).getLeftText();
                if (n5 != -1 && n2 != -1) {
                    this.mImageLeft.setBackgroundDrawable((Drawable)this.createStateDrawable(n2, n5));
                } else if (n2 != -1) {
                    this.mImageLeft.setBackgroundDrawable(this.mContext.getResources().getDrawable(n2));
                } else {
                    this.mImageLeft.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.moxie_client_banner_back));
                }
                if (n6 != -1 && n3 != -1) {
                    this.mImageRight.setBackgroundDrawable((Drawable)this.createStateDrawable(n3, n6));
                } else if (n3 != -1) {
                    this.mImageRight.setBackgroundDrawable(this.mContext.getResources().getDrawable(n3));
                } else {
                    this.mImageRight.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.moxie_client_banner_refresh));
                }
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    this.mLeftTextView.setText((CharSequence)object);
                    this.showCloseIcon = false;
                }
                if (n9 != -1) {
                    this.mLeftTextView.setTextColor(n9);
                    this.showCloseIcon = false;
                }
                if (n10 != -1 && n11 != -1) {
                    this.mImageClose.setBackgroundDrawable((Drawable)this.createStateDrawable(n10, n11));
                    this.showCloseIcon = true;
                } else if (n10 != -1) {
                    this.mImageClose.setBackgroundDrawable(this.mContext.getResources().getDrawable(n10));
                    this.showCloseIcon = true;
                }
                this.mTextTitle.setTextColor(n4);
                if (n8 != -1) {
                    this.setBackgroundDrawable(this.mContext.getResources().getDrawable(n8));
                    return;
                }
                this.setBackgroundColor(n7);
                return;
            }
            String string2 = h.e().a() != null ? h.e().a().getBannerTxtColor() : "#ffffff";
            int n12 = Color.parseColor((String)string2);
            if (string2.toLowerCase().equalsIgnoreCase("#ffffff") || string2.toLowerCase().equalsIgnoreCase("#ffffffff") || string2.toLowerCase().equalsIgnoreCase("#000000") || string2.toLowerCase().equalsIgnoreCase("#ff000000")) {
                if (string2.toLowerCase().equalsIgnoreCase("#ffffff") || string2.toLowerCase().equalsIgnoreCase("#ffffffff")) {
                    this.mImageLeft.setBackgroundResource(R.drawable.moxie_client_banner_back);
                    this.mImageRight.setBackgroundResource(R.drawable.moxie_client_banner_refresh);
                } else {
                    this.mImageLeft.setBackgroundResource(R.drawable.moxie_client_banner_back_black);
                    this.mImageRight.setBackgroundResource(R.drawable.moxie_client_banner_refresh_black);
                }
                this.mImageLeft.setVisibility(0);
                this.mImageRight.setVisibility(0);
            } else {
                this.mImageLeft.setVisibility(8);
                this.mImageRight.setVisibility(8);
            }
            this.mTitleLayoutView.setBackgroundColor(Color.parseColor((String)(h.e().a() != null ? h.e().a().getBannerBgColor() : "#ff000000")));
            this.mTextTitle.setTextColor(n12);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private StateListDrawable createStateDrawable(int n2, int n3) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        Drawable drawable2 = this.getResources().getDrawable(n2);
        Drawable drawable3 = this.getResources().getDrawable(n3);
        stateListDrawable.addState(View.PRESSED_ENABLED_STATE_SET, drawable3);
        stateListDrawable.addState(View.ENABLED_STATE_SET, drawable2);
        stateListDrawable.addState(View.EMPTY_STATE_SET, drawable2);
        return stateListDrawable;
    }
}

