/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.accessible;

import android.accessibilityservice.AccessibilityService;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Toast;
import com.moxie.client.accessible.AccessibleCrawlerActivity;
import com.moxie.client.accessible.a;
import com.moxie.client.accessible.h;
import com.moxie.client.accessible.i;
import com.moxie.client.accessible.j;
import com.moxie.client.accessible.k;
import com.moxie.client.accessible.l;
import com.moxie.client.c.c;
import com.moxie.client.c.d;
import com.proguard.annotation.NotProguard;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.json.JSONObject;

@NotProguard
public class AccessibleCrawlerService
extends AccessibilityService {
    private final String TAG = AccessibleCrawlerService.class.getSimpleName();
    private Handler timeoutHandler = new Handler((Handler.Callback)new k(this));
    private Toast toast;

    public void onCreate() {
        super.onCreate();
        if (!h.a().d.get()) {
            if (h.a().a != null && h.a().a.size() > 0) {
                a a2 = (a)h.a().a.get(0);
                this.jumpActivity(a2.a());
                this.showToast("\u8f85\u52a9\u8ba4\u8bc1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
                this.restartTimeoutTimer();
                return;
            }
            this.backActivityWithResult(false);
        }
    }

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (!h.a().d.get()) {
            int n2 = accessibilityEvent.getEventType();
            switch (n2) {
                case 2048: {
                    this.handleContentChanged(accessibilityEvent.getClassName().toString(), false);
                    if (h.a().b == null || !h.a().b.contains(accessibilityEvent.getClassName().toString())) break;
                    this.restartTimeoutTimer();
                    return;
                }
                case 1: 
                case 8: 
                case 32: 
                case 0x400000: {
                    this.handleEvent(accessibilityEvent.getClassName().toString());
                    this.restartTimeoutTimer();
                }
            }
        }
    }

    @TargetApi(value=16)
    private AccessibilityNodeInfo getNodeInfoWithRetry(int n2) {
        AccessibilityNodeInfo accessibilityNodeInfo;
        while (true) {
            accessibilityNodeInfo = this.getRootInActiveWindow();
            if (n2 < 0) {
                return null;
            }
            if (accessibilityNodeInfo != null) break;
            SystemClock.sleep((long)200L);
            --n2;
        }
        return accessibilityNodeInfo;
    }

    private synchronized void handleEvent(String string2) {
        AccessibilityNodeInfo accessibilityNodeInfo = this.getNodeInfoWithRetry(20);
        if (accessibilityNodeInfo != null) {
            a a2 = (a)h.a().a.get(h.a().c.get());
            if (a2 != null && a2.e() == 1) {
                return;
            }
            if (a2 != null && this.checkActivity(accessibilityNodeInfo, string2, a2)) {
                if (a2.e() == 0) {
                    a2.a(new i(this, string2));
                    return;
                }
                if (a2.e() == 2) {
                    this.doNext(accessibilityNodeInfo);
                }
            }
        }
    }

    private synchronized boolean handleContentChanged(String string2, boolean bl) {
        if (h.a().b != null && h.a().b.contains(((a)h.a().a.get(h.a().c.get())).b())) {
            AccessibilityNodeInfo accessibilityNodeInfo = this.getNodeInfoWithRetry(20);
            if (accessibilityNodeInfo != null) {
                Object object = this.crawView$6b960579(accessibilityNodeInfo);
                com.moxie.client.g.d.a("handleContentChanged: ", ((com.moxie.client.c.a.a)object).a().toString());
                object = (a)h.a().a.get(h.a().c.get());
                if (object != null && ((a)object).e() == 1) {
                    return false;
                }
                if (object != null && this.checkActivity(accessibilityNodeInfo, string2, (a)object)) {
                    if (((a)object).e() == 0) {
                        ((a)object).a(new j(this, string2, bl));
                        return false;
                    }
                    if (((a)object).e() == 2) {
                        this.doNext(accessibilityNodeInfo);
                        return true;
                    }
                }
            }
            if (bl) {
                if (accessibilityNodeInfo != null) {
                    com.moxie.client.g.d.c("AccessibleCrawlerService handleContentChanged", new Exception(this.crawView$6b960579(accessibilityNodeInfo).a().toString()));
                } else {
                    com.moxie.client.g.d.c("AccessibleCrawlerService handleContentChanged", new Exception("nodeInfo is null"));
                }
            }
            return false;
        }
        return false;
    }

    private void doNext(AccessibilityNodeInfo accessibilityNodeInfo) {
        String string2 = ((a)h.a().a.get(h.a().c.get())).c();
        this.saveFile((accessibilityNodeInfo = this.crawView$6b960579(accessibilityNodeInfo).a()) != null ? accessibilityNodeInfo.toString() : "{}", string2);
        if (h.a().c.get() == h.a().a.size() - 1) {
            this.backActivityWithResult(true);
            return;
        }
        this.jumpActivity(((a)h.a().a.get(h.a().c.addAndGet(1))).a());
        this.showToast("\u8f85\u52a9\u8ba4\u8bc1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
    }

    private void saveFile(String string2, String string3) {
        try {
            JSONObject jSONObject = new JSONObject();
            string3 = "accessiblecrawler#" + string3 + "#" + this.getAlipayVersion() + ".json";
            jSONObject.put("fileName", (Object)string3);
            jSONObject.put("content", (Object)string2);
            if (c.b() == null) {
                this.backActivityWithResult(false);
                return;
            }
            c.a(d.D, jSONObject.toString());
        }
        catch (Exception exception) {
            com.moxie.client.g.d.b("AccessibleCrawlerService doNext saveFile", exception);
        }
    }

    private String getAlipayVersion() {
        try {
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            packageManager = packageManager.getPackageInfo("com.eg.android.AlipayGphone", 16384);
            return packageManager.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            com.moxie.client.g.d.b("AccessibleCrawlerService getAlipayVersion", nameNotFoundException);
            return "unknown";
        }
    }

    private boolean checkActivity(AccessibilityNodeInfo accessibilityNodeInfo, String string2, a iterator) {
        iterator = ((a)((Object)iterator)).d();
        boolean bl = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (List)iterator.next();
            boolean bl2 = true;
            object = object.iterator();
            while (object.hasNext()) {
                com.moxie.client.dfp.android.a.b.a.c c2 = (com.moxie.client.dfp.android.a.b.a.c)object.next();
                bl2 = bl2 && this.checkView$532317fd(accessibilityNodeInfo, string2, c2);
            }
            bl = bl || bl2;
        }
        return bl;
    }

    @RequiresApi(api=18)
    private List searchNodesById(AccessibilityNodeInfo accessibilityNodeInfo, String string2) {
        ArrayList<AccessibilityNodeInfo> arrayList = new ArrayList<AccessibilityNodeInfo>();
        if (accessibilityNodeInfo == null) {
            return arrayList;
        }
        if (accessibilityNodeInfo.getChildCount() == 0) {
            if (string2.equalsIgnoreCase(accessibilityNodeInfo.getViewIdResourceName())) {
                arrayList.add(accessibilityNodeInfo);
            }
            return arrayList;
        }
        for (int i2 = 0; i2 < accessibilityNodeInfo.getChildCount(); ++i2) {
            arrayList.addAll(this.searchNodesById(accessibilityNodeInfo.getChild(i2), string2));
        }
        return arrayList;
    }

    @TargetApi(value=18)
    private boolean checkView$532317fd(AccessibilityNodeInfo object, String object2, com.moxie.client.dfp.android.a.b.a.c c2) {
        if (TextUtils.isEmpty((CharSequence)object2) || Pattern.compile(c2.c()).matcher((CharSequence)object2).find()) {
            if ("content".equals(c2.a())) {
                return this.checkViewByContent((AccessibilityNodeInfo)object, c2.b());
            }
            if ((object = this.searchNodesById((AccessibilityNodeInfo)object, c2.a())).size() > 0) {
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (AccessibilityNodeInfo)object.next();
                    String string2 = null;
                    if (object2.getContentDescription() != null && !"".contentEquals(object2.getContentDescription())) {
                        string2 = String.valueOf(object2.getContentDescription());
                    } else if (object2.getText() != null && !"".contentEquals(object2.getText())) {
                        string2 = String.valueOf(object2.getText());
                    }
                    if (string2 == null || !((Pattern)(object2 = Pattern.compile(c2.b()))).matcher(string2).matches()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean checkViewByContent(AccessibilityNodeInfo accessibilityNodeInfo, String string2) {
        if (accessibilityNodeInfo != null) {
            String string3 = String.valueOf(accessibilityNodeInfo.getText());
            String string4 = String.valueOf(accessibilityNodeInfo.getContentDescription());
            if (string3 != null && string3.contains(string2) || string4 != null && string4.contains(string2)) {
                return true;
            }
            int n2 = accessibilityNodeInfo.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.checkViewByContent(accessibilityNodeInfo.getChild(i2), string2)) continue;
                return true;
            }
        }
        return false;
    }

    private com.moxie.client.c.a.a crawView$6b960579(AccessibilityNodeInfo accessibilityNodeInfo) {
        if (accessibilityNodeInfo == null || accessibilityNodeInfo.getChildCount() <= 0) {
            return new com.moxie.client.c.a.a(accessibilityNodeInfo);
        }
        com.moxie.client.c.a.a a2 = new com.moxie.client.c.a.a(accessibilityNodeInfo);
        ArrayList<com.moxie.client.c.a.a> arrayList = new ArrayList<com.moxie.client.c.a.a>();
        int n2 = accessibilityNodeInfo.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.crawView$6b960579(accessibilityNodeInfo.getChild(i2)));
        }
        a2.a(arrayList);
        return a2;
    }

    public void onInterrupt() {
        com.moxie.client.g.d.a("AccessibleCrawlerService onInterrupt");
    }

    private void jumpActivity(String string2) {
        string2 = Uri.parse((String)string2);
        string2 = new Intent("android.intent.action.VIEW", (Uri)string2);
        string2.setFlags(0x10000000);
        this.startActivity((Intent)string2);
    }

    private void justBackActivity() {
        Intent intent = new Intent(this.getApplicationContext(), AccessibleCrawlerActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
    }

    private void showToast(String string2) {
        if (!h.a().d.get()) {
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this, (CharSequence)"", (int)1);
            }
            this.toast.setText((CharSequence)string2);
            this.toast.show();
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.disableSelf();
        }
    }

    private void restartTimeoutTimer() {
        if (h.a().f != null) {
            h.a().f.cancel();
            h.a().f = null;
        }
        h.a().f = new Timer();
        h.a().f.schedule((TimerTask)new l(this), 5000L);
    }

    private void backActivityWithResult(boolean bl) {
        Intent intent = new Intent(this.getApplicationContext(), AccessibleCrawlerActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
        h.a().c.set(0);
        h.a().d.set(true);
        h.a().e.set(bl);
        if (h.a().f != null) {
            h.a().f.cancel();
            h.a().f = null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.disableSelf();
        }
    }

    static /* synthetic */ void access$000(AccessibleCrawlerService accessibleCrawlerService, String string2) {
        accessibleCrawlerService.handleEvent(string2);
    }

    static /* synthetic */ boolean access$100(AccessibleCrawlerService accessibleCrawlerService, String string2, boolean bl) {
        return accessibleCrawlerService.handleContentChanged(string2, bl);
    }

    static /* synthetic */ void access$200(AccessibleCrawlerService accessibleCrawlerService, String string2) {
        accessibleCrawlerService.showToast(string2);
    }

    static /* synthetic */ Handler access$300(AccessibleCrawlerService accessibleCrawlerService) {
        return accessibleCrawlerService.timeoutHandler;
    }
}

