/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.TextView;
import com.proguard.annotation.NotProguard;

@NotProguard
public class EditTextWithClear
extends EditText
implements TextWatcher,
View.OnFocusChangeListener {
    private Drawable mClearDrawable;
    private boolean hasFoucs;
    private String realText = "";
    private Editable realEditable;
    private OnClearClickListener mOnClearClickListener;

    public EditTextWithClear(Context context) {
        this(context, null);
    }

    public void setOnClearClickListener(OnClearClickListener onClearClickListener) {
        this.mOnClearClickListener = onClearClickListener;
    }

    public void setText(String string, String string2) {
        super.setText((CharSequence)string, TextView.BufferType.EDITABLE);
        this.realText = string2;
    }

    public void setRealText(String string) {
        this.realText = string;
    }

    public String getMyText() {
        if (!TextUtils.isEmpty((CharSequence)this.realText)) {
            return this.realText;
        }
        return super.getText().toString();
    }

    public EditTextWithClear(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842862);
    }

    public EditTextWithClear(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        this.mClearDrawable = this.getCompoundDrawables()[2];
        if (this.mClearDrawable == null) {
            this.mClearDrawable = this.getResources().getDrawable(context.getResources().getIdentifier("moxie_client_search_city_edittext_delete", "drawable", context.getPackageName()));
        }
        this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 1 && this.getCompoundDrawables()[2] != null && motionEvent.getX() > (float)(this.getWidth() - this.getTotalPaddingRight()) && motionEvent.getX() < (float)(this.getWidth() - this.getPaddingRight())) {
            this.getText().toString();
            this.setText("");
        }
        return super.onTouchEvent(motionEvent);
    }

    public void onFocusChange(View view, boolean bl) {
        this.hasFoucs = bl;
        if (bl) {
            this.setClearIconVisible(this.getText().length() > 0);
            return;
        }
        this.setClearIconVisible(false);
    }

    public void setClearIconVisible(boolean bl) {
        Drawable drawable2 = bl ? this.mClearDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], drawable2, this.getCompoundDrawables()[3]);
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.hasFoucs) {
            this.setClearIconVisible(charSequence.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void afterTextChanged(Editable editable) {
    }

    public void setShakeAnimation() {
        this.setAnimation(EditTextWithClear.shakeAnimation(5));
    }

    public static Animation shakeAnimation(int n) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)n));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (bl) {
            Editable editable = this.getText();
            Selection.setSelection((Spannable)editable, (int)editable.length());
        }
    }

    public static interface OnClearClickListener {
    }
}

