/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.MediaScannerConnection;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.os.AsyncTaskCompat;
import android.text.TextUtils;
import android.widget.Toast;
import com.moxie.client.utils.ErrorHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class ScreenCapturer {
    private WeakReference<Activity> a;
    private MediaProjection b;
    private VirtualDisplay c;
    private ImageReader d;
    private MediaScannerConnection e;

    public ScreenCapturer(Activity activity, Intent intent) {
        this.a = new WeakReference<Activity>(activity);
        if (Build.VERSION.SDK_INT >= 21) {
            this.b = ((MediaProjectionManager)this.b().getSystemService("media_projection")).getMediaProjection(-1, intent);
            this.d = ImageReader.newInstance((int)ScreenCapturer.c(), (int)ScreenCapturer.d(), (int)1, (int)1);
        }
    }

    private Context b() {
        return (Context)this.a.get();
    }

    private static int c() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    private static int d() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public final void a() {
        ScreenCapturer screenCapturer = this;
        screenCapturer.c = screenCapturer.b.createVirtualDisplay("screen-mirror", ScreenCapturer.c(), ScreenCapturer.d(), Resources.getSystem().getDisplayMetrics().densityDpi, 16, screenCapturer.d.getSurface(), null, null);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                Image image = ScreenCapturer.this.d.acquireLatestImage();
                AsyncTaskCompat.executeParallel((AsyncTask)new SaveTask(), (Object[])new Image[]{image});
            }
        }, 300L);
    }

    public final void a(Context context, final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Toast.makeText((Context)this.b(), (CharSequence)"\u622a\u5c4f\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u7cfb\u7edf\u622a\u5c4f\u529f\u80fd", (int)0).show();
            return;
        }
        this.e = new MediaScannerConnection(context, new MediaScannerConnection.MediaScannerConnectionClient(){

            public void onMediaScannerConnected() {
                ScreenCapturer.this.e.scanFile(string, "image/*");
            }

            public void onScanCompleted(String string2, Uri uri) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)ScreenCapturer.this.b(), (CharSequence)"\u622a\u5c4f\u6210\u529f", (int)0).show();
                    }
                });
                ScreenCapturer.this.e.disconnect();
            }
        });
        this.e.connect();
    }

    static /* synthetic */ VirtualDisplay c(ScreenCapturer screenCapturer) {
        screenCapturer.c = null;
        return null;
    }

    static /* synthetic */ MediaProjection e(ScreenCapturer screenCapturer) {
        screenCapturer.b = null;
        return null;
    }

    public class SaveTask
    extends AsyncTask<Image, Void, String> {
        @TargetApi(value=19)
        private static String a(Image ... object) {
            if (object == null || ((Image[])object).length <= 0 || object[0] == null) {
                return null;
            }
            try {
                object = object[0];
                int n = object.getWidth();
                int n2 = object.getHeight();
                Image.Plane[] planeArray = object.getPlanes();
                ByteBuffer byteBuffer = planeArray[0].getBuffer();
                int n3 = planeArray[0].getPixelStride();
                int n4 = planeArray[0].getRowStride() - n3 * n;
                Bitmap bitmap = Bitmap.createBitmap((int)(n + n4 / n3), (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2);
                object.close();
                object = null;
                if (bitmap != null) {
                    object = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/moxie/";
                    if (!((File)(object = new File((String)object))).exists()) {
                        ((File)object).mkdirs();
                    }
                    if (!((File)(object = new File((File)object, System.currentTimeMillis() + ".jpg"))).exists()) {
                        ((File)object).createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                if (bitmap != null && !bitmap.isRecycled()) {
                    bitmap.recycle();
                }
                if (object != null) {
                    return ((File)object).getAbsolutePath();
                }
            }
            catch (Exception exception) {
                ErrorHandle.b("\u622a\u5c4f\u5931\u8d25", exception);
            }
            return null;
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            String string = (String)object;
            object = this;
            super.onPostExecute((Object)string);
            if (((SaveTask)((Object)object)).ScreenCapturer.this.c != null) {
                ((SaveTask)((Object)object)).ScreenCapturer.this.c.release();
                ScreenCapturer.c(((SaveTask)((Object)object)).ScreenCapturer.this);
            }
            if (((SaveTask)((Object)object)).ScreenCapturer.this.b != null) {
                ((SaveTask)((Object)object)).ScreenCapturer.this.b.stop();
                ScreenCapturer.e(((SaveTask)((Object)object)).ScreenCapturer.this);
            }
            ((SaveTask)((Object)object)).ScreenCapturer.this.a(((SaveTask)((Object)object)).ScreenCapturer.this.b(), string);
        }

        @TargetApi(value=19)
        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return SaveTask.a((Image[])objectArray);
        }
    }
}

