/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.moxie.client.MainEventActivity;
import com.moxie.client.R;
import com.moxie.client.accessible.AccessibleCrawlerActivity;
import com.moxie.client.commom.GlobalConstants;
import com.moxie.client.commom.GlobalParams;
import com.moxie.client.crash.MxACRA;
import com.moxie.client.dfp.android.MoxieFingerprintManager;
import com.moxie.client.dfp.android.obj.ex.FingerprintException;
import com.moxie.client.dfp.android.utilities.FingerCallBack;
import com.moxie.client.event.model.TaskLoginEvent;
import com.moxie.client.event.model.TaskStatusEvent;
import com.moxie.client.event.model.UploadFileEvent;
import com.moxie.client.exception.ExceptionType;
import com.moxie.client.exception.MoxieException;
import com.moxie.client.fragment.BaseWebViewFragment;
import com.moxie.client.fragment.ImportResultFragment;
import com.moxie.client.fragment.ScreenCaptureFragment;
import com.moxie.client.fragment.WebViewAgreementH5Fragment;
import com.moxie.client.fragment.WebViewMoxieH5Fragment;
import com.moxie.client.fragment.WebViewOfficialFragment;
import com.moxie.client.http.UploadFile;
import com.moxie.client.manager.ActivityDispatcher;
import com.moxie.client.manager.LogTracker;
import com.moxie.client.manager.MoxieCallBackData;
import com.moxie.client.manager.MoxieContext;
import com.moxie.client.manager.MoxieSDK;
import com.moxie.client.manager.MoxieSDKRunMode;
import com.moxie.client.manager.StatusViewHandler;
import com.moxie.client.manager.StatusViewListener;
import com.moxie.client.model.FragmentEnum;
import com.moxie.client.model.LogTrackInfo;
import com.moxie.client.model.MxParam;
import com.moxie.client.model.SiteAccountInfo;
import com.moxie.client.model.helper.UrlGenerator;
import com.moxie.client.tasks.model.SiteConfigItem;
import com.moxie.client.tasks.model.SiteConfigsResponse;
import com.moxie.client.tasks.task.LoadSiteConfigTask;
import com.moxie.client.utils.CommonMethod;
import com.moxie.client.utils.ErrorHandle;
import com.moxie.client.utils.JsonUtil;
import com.moxie.client.widget.LoadingDialog.LoadingFlower;
import com.moxie.client.widget.TitleLayout;
import com.proguard.annotation.NotProguard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

@NotProguard
public class MainActivity
extends MainEventActivity
implements View.OnClickListener {
    public static final String TAG = "MainActivity";
    private String mTitleContent = "";
    private boolean mIsUploaded = false;
    private int mResult = -1;
    private String mResultMessage = "";
    private MxParam mParam = null;
    public static String mTaskId = "";
    private String mAccount = "";
    private Boolean mDirect = false;
    private String mLoginCode = "";
    private String mLoginType = "";
    private TitleLayout mTitleLayout;
    private FrameLayout frameLayout;
    private FrameLayout frameLayoutAgreement;
    private FrameLayout frameLayoutImporting;
    private ImportResultFragment mImportResultFragment = null;
    private Fragment mImportResultCustomFragment = null;
    private WebViewOfficialFragment mWebViewOfficialFragment = null;
    private WebViewAgreementH5Fragment mWebViewAgreementH5Fragment = null;
    private WebViewMoxieH5Fragment mWebViewCommonFragment = null;
    private FragmentEnum mFragment = FragmentEnum.c;
    private FragmentEnum mFragmentBefore = FragmentEnum.c;
    private LoadingFlower mLoadingFlower = null;
    private Boolean isSDKStart = false;
    private View mSdkLayout;
    private boolean isBackgroundRunMode = false;
    FrameLayout thirdPartyViewContainer;
    private static final int REQUEST_WRITE_STORAGE = 1;
    private static String[] REQUEST_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    private Dialog mPermissionDialog = null;
    private JSONObject mAppendResultJson;
    boolean loginDone = false;
    private double mPercent = -1.0;
    private Object lock = new Object();
    AtomicBoolean hasUpload = new AtomicBoolean(false);
    AtomicBoolean hasCreateTask = new AtomicBoolean(false);
    private boolean isReloginOpened = false;
    private volatile boolean isAttach = false;
    private boolean isBackClicked = false;
    private Dialog mImportingDialog = null;

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mSdkLayout = LayoutInflater.from((Context)this).inflate(this.getResources().getIdentifier("moxie_client_activity_main", "layout", this.getPackageName()), null, false);
        boolean bl = this.isBackgroundRunMode = MoxieSDK.getInstance().getRunMode() == MoxieSDKRunMode.MoxieSDKRunModeBackground;
        if (this.isBackgroundRunMode) {
            this.mSdkLayout.setVisibility(8);
            this.getWindow().addFlags(131120);
            this.setTheme(0x1030010);
        } else {
            this.setTheme(R.style.Theme_AppCompat_NoActionBar);
            this.getWindow().setBackgroundDrawableResource(R.drawable.moxie_main_bg);
        }
        this.setContentView(this.mSdkLayout);
        this.logInitParams();
        this.initParams();
        this.init();
        this.showLoadingFlower();
        this.generateFingerprint();
        this.loadConfig();
    }

    private void runOnUi(Runnable runnable) {
        this.runOnUiThread(runnable);
    }

    private void generateFingerprint() {
        MoxieFingerprintManager.getInstance().init((Context)this);
        MoxieFingerprintManager.getInstance().generateFingerprint(new FingerCallBack(){

            @Override
            public void onSuccess(String string) {
            }

            @Override
            public void onFailed(FingerprintException fingerprintException) {
            }
        });
    }

    private void init() {
        MoxieSDK.init(this.getApplication());
        ActivityDispatcher.a().d();
        this.initTitle();
        this.initSoftInputMode();
        MxACRA.b();
    }

    private void initParams() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.mParam = (MxParam)bundle.getParcelable("param");
        }
        new StringBuilder().append(this.mParam.getApiKey()).append("-").append(this.mParam.getTaskType()).append("-").append(this.mParam.getUserId()).append("-").append(this.mParam.getBannerBgColor()).append("-").append(this.mParam.getBannerTxtColor()).append("-").append(this.mParam.getThemeColor()).append("-").append(this.mParam.getAgreementUrl());
        GlobalParams.e().a(this.mParam);
        GlobalParams.e().g(GlobalConstants.a);
        if (GlobalParams.e().a().getLoginCustom() != null && !TextUtils.isEmpty((CharSequence)this.mParam.getLoginCustom().getLoginType())) {
            this.mLoginType = GlobalParams.e().a().getLoginCustom().getLoginType();
        }
        if (GlobalParams.e().a().getLoginCustom() != null && !TextUtils.isEmpty((CharSequence)GlobalParams.e().a().getLoginCustom().getLoginCode())) {
            this.mLoginCode = GlobalParams.e().a().getLoginCustom().getLoginCode();
            this.mDirect = true;
        }
        new StringBuilder("mDirect=").append(this.mDirect);
    }

    private void loadConfig() {
        new LoadSiteConfigTask(this.mParam.getTaskType(), this.mLoginCode, this.mLoginType, new LoadSiteConfigTask.Callback(){

            @Override
            public final void a(final SiteConfigsResponse siteConfigsResponse) {
                MainActivity.this.runOnUi(new Runnable(){

                    @Override
                    public void run() {
                        if (siteConfigsResponse != null) {
                            MainActivity.this.start(siteConfigsResponse);
                            MainActivity.this.hideDialog(MainActivity.this.mLoadingFlower);
                            return;
                        }
                        MainActivity.this.toast("\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5!", ExceptionType.NETWORK);
                        MainActivity.this.hideDialog(MainActivity.this.mLoadingFlower);
                        if (MoxieSDK.getInstance().getMoxieCallBack() != null) {
                            MoxieSDK.getInstance().getMoxieCallBack().onError(new MoxieContext((Context)MainActivity.this), new MoxieException("\u914d\u7f6e\u6821\u9a8c\u5931\u8d25", ExceptionType.SDK_OPEN_FAIL));
                        }
                        MainActivity.this.finish();
                    }
                });
            }

            @Override
            public final void a(final Exception exception) {
                MainActivity.this.runOnUi(new Runnable(){

                    @Override
                    public void run() {
                        ErrorHandle.b("MainActivity checkPermission error", exception);
                        String string = "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01";
                        ExceptionType exceptionType = ExceptionType.NETWORK;
                        if (exception instanceof MoxieException) {
                            string = exception.getMessage();
                            if ("401".equals(((MoxieException)exception).getCode())) {
                                exceptionType = ExceptionType.WRONG_PARAMETERS;
                            }
                        }
                        if (!MainActivity.this.isBackgroundRunMode && MoxieSDK.getInstance().getMoxieCallBack() != null) {
                            MoxieSDK.getInstance().getMoxieCallBack().onError(new MoxieContext((Context)MainActivity.this), new MoxieException(string, exceptionType));
                        }
                        MainActivity.this.toast(string, exceptionType);
                        MainActivity.this.hideDialog(MainActivity.this.mLoadingFlower);
                        MainActivity.this.finish();
                    }
                });
            }
        }).b(new Void[0]);
    }

    private void logInitParams() {
    }

    private void initTitle() {
        this.frameLayout = (FrameLayout)this.findViewById(this.getResources().getIdentifier("moxie_client_fragment_main", "id", this.getPackageName()));
        this.frameLayoutAgreement = (FrameLayout)this.findViewById(this.getResources().getIdentifier("moxie_client_fragment_agreement", "id", this.getPackageName()));
        this.frameLayoutImporting = (FrameLayout)this.findViewById(this.getResources().getIdentifier("moxie_client_fragment_importing", "id", this.getPackageName()));
        this.mTitleLayout = (TitleLayout)this.findViewById(this.getResources().getIdentifier("MoxieClientTitleLayout", "id", this.getPackageName()));
        this.mTitleLayout.initTitleLayout();
        this.mTitleLayout.getRelativeLayout_Title_Left().setOnClickListener((View.OnClickListener)this);
        this.mTitleLayout.getRelativeLayout_Title_Right().setOnClickListener((View.OnClickListener)this);
        this.mTitleLayout.getLeftTextView().setOnClickListener((View.OnClickListener)this);
        this.mTitleLayout.getLeftImage().setOnClickListener((View.OnClickListener)this);
        this.mTitleLayout.setImageRightVisibility(8);
        this.mTitleLayout.getRightImage().setOnClickListener((View.OnClickListener)this);
    }

    private void initSoftInputMode() {
        if (GlobalParams.e().a().getTitleParams() != null && GlobalParams.e().a().getTitleParams().isImmersedEnable() && Build.VERSION.SDK_INT >= 19) {
            this.getWindow().setSoftInputMode(32);
        }
    }

    public void onClick(View view) {
        int n = view.getId();
        try {
            if (n == this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Title_Left", "id", this.getPackageName()) || n == this.getResources().getIdentifier("Moxie_Client_ImageView_Left", "id", this.getPackageName())) {
                this.onBackInternal();
                return;
            }
            if (n == this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Title_Right", "id", this.getPackageName()) || n == this.getResources().getIdentifier("Moxie_Client_ImageView_Right", "id", this.getPackageName())) {
                this.refreshFragmentRightImage();
                return;
            }
            if (n == this.getResources().getIdentifier("moxie_client_actionbar_left_text", "id", this.getPackageName()) || n == this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Close_Left", "id", this.getPackageName())) {
                this.internalFinish();
            }
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("onClick fail", exception);
            return;
        }
    }

    private void start(SiteConfigsResponse siteConfigsResponse) {
        this.isSDKStart = true;
        this.getSysConfigs();
        this.checkAndOpenWebView(siteConfigsResponse);
    }

    private void checkAndOpenWebView(SiteConfigsResponse object) {
        try {
            if (object != null) {
                String string = this.mDirect != false ? this.mLoginCode : this.mParam.getTaskType();
                String string2 = this.mLoginType;
                ArrayList<SiteConfigItem> arrayList = ((SiteConfigsResponse)object).a;
                object = ((SiteConfigsResponse)object).a();
                if (!this.mDirect.booleanValue()) {
                    if (CommonMethod.a((String)object)) {
                        this.openMoxieWebView((String)object, "");
                        return;
                    }
                    if (arrayList != null) {
                        object = arrayList.get(0);
                        if (object != null) {
                            if (((SiteConfigItem)object).e()) {
                                this.showWebViewOfficialH5Fragment(string, ((SiteConfigItem)object).d());
                                return;
                            }
                            this.openMoxieWebView(((SiteConfigItem)object).c(), ((SiteConfigItem)object).d());
                        }
                        return;
                    }
                } else if (this.mDirect.booleanValue() && arrayList != null) {
                    for (SiteConfigItem siteConfigItem : arrayList) {
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            if (!siteConfigItem.a.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(siteConfigItem.a())) continue;
                            if (siteConfigItem.e()) {
                                this.showWebViewOfficialH5Fragment(string, siteConfigItem.d());
                                return;
                            }
                            this.openMoxieWebView(siteConfigItem.c(), siteConfigItem.d());
                            return;
                        }
                        if (!siteConfigItem.a.equalsIgnoreCase(string)) continue;
                        if (siteConfigItem.e()) {
                            this.showWebViewOfficialH5Fragment(string, siteConfigItem.d());
                            return;
                        }
                        this.openMoxieWebView(siteConfigItem.c(), siteConfigItem.d());
                        return;
                    }
                    if ("email".equalsIgnoreCase(this.mParam.getTaskType())) {
                        if (arrayList.size() > 0) {
                            object = arrayList.get(arrayList.size() - 1);
                            this.openMoxieWebView(((SiteConfigItem)object).c(), ((SiteConfigItem)object).d());
                            return;
                        }
                    } else {
                        if (MoxieSDK.getInstance().getMoxieCallBack() != null) {
                            MoxieSDK.getInstance().getMoxieCallBack().onError(new MoxieContext((Context)this), new MoxieException("\u4e0d\u652f\u6301\u7684LoginCode!", ExceptionType.WRONG_PARAMETERS));
                        }
                        this.finish();
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("try open checkAndOpenWebView fail", exception);
            return;
        }
    }

    public void addView(View view) {
        if (this.thirdPartyViewContainer == null) {
            this.thirdPartyViewContainer = (FrameLayout)this.findViewById(this.getResources().getIdentifier("third_party_view_container", "id", this.getPackageName()));
        }
        this.thirdPartyViewContainer.removeAllViews();
        this.thirdPartyViewContainer.addView(view);
    }

    private void openMoxieWebView(String object, String string) {
        String string2 = "https://api.51datakey.com/h5/importV3/index.html";
        this.mTitleContent = string;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = string2;
        }
        object = UrlGenerator.a((String)object, this.mParam);
        ((UrlGenerator.Builder)object).a();
        ((UrlGenerator.Builder)object).b();
        ((UrlGenerator.Builder)object).c();
        object = ((UrlGenerator.Builder)object).d().a();
        this.showWebViewMoxieH5Fragment(this.mTitleContent, (String)object);
    }

    private void openMoxieWebView() {
        this.openMoxieWebView(null, null);
    }

    @Override
    public void hideSDKLayout() {
        super.hideSDKLayout();
        if (this.isBackgroundRunMode && this.mSdkLayout != null && this.mSdkLayout.getVisibility() == 0) {
            this.getWindow().addFlags(131120);
            this.mSdkLayout.setVisibility(8);
        }
    }

    @Override
    public void showSDKLayout(String string) {
        super.showSDKLayout(string);
        if (this.isBackgroundRunMode && this.mSdkLayout != null && this.mSdkLayout.getVisibility() == 8) {
            this.getWindow().clearFlags(131120);
            this.mSdkLayout.setVisibility(0);
        }
    }

    @Override
    public void captureScreen() {
        super.captureScreen();
        if (this.hasPermission()) {
            this.attachScreenCaptureFragment();
            return;
        }
        this.requestPermission();
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        if (n == 1) {
            if (nArray.length > 0 && nArray[0] == 0) {
                this.attachScreenCaptureFragment();
                return;
            }
            Toast.makeText((Context)this, (CharSequence)"\u672a\u6388\u4e88\u6743\u9650\uff0c\u8bf7\u4f7f\u7528\u7cfb\u7edf\u622a\u5c4f\u529f\u80fd", (int)0).show();
        }
    }

    boolean hasPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return ContextCompat.checkSelfPermission((Context)this, (String)REQUEST_PERMISSIONS[0]) == 0;
    }

    private void requestPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)REQUEST_PERMISSIONS[0])) {
            this.mPermissionDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\u6e29\u99a8\u63d0\u793a").setMessage((CharSequence)"\u8bf7\u5141\u8bb8\u8be5\u6743\u9650\u4ee5\u83b7\u5f97\u66f4\u4f18\u8d28\u7684\u670d\u52a1").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    ActivityCompat.requestPermissions((Activity)MainActivity.this, (String[])REQUEST_PERMISSIONS, (int)1);
                }
            }).setNegativeButton((CharSequence)"\u53d6\u6d88", null).setCancelable(false).show();
            return;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])REQUEST_PERMISSIONS, (int)1);
    }

    private void attachScreenCaptureFragment() {
        try {
            FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
            ScreenCaptureFragment screenCaptureFragment = (ScreenCaptureFragment)this.getFragmentManager().findFragmentByTag("capture");
            if (screenCaptureFragment == null) {
                screenCaptureFragment = new ScreenCaptureFragment();
                fragmentTransaction.addToBackStack("capture");
                fragmentTransaction.add((Fragment)screenCaptureFragment, "capture");
            } else {
                fragmentTransaction.show((Fragment)screenCaptureFragment);
                screenCaptureFragment.a();
            }
            fragmentTransaction.commitAllowingStateLoss();
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("onEventMainThread#ScreenCaptureEvent", exception);
            return;
        }
    }

    @Override
    public void setAppendResult(String string) {
        if (this.mAppendResultJson == null) {
            this.mAppendResultJson = new JSONObject();
        }
        JsonUtil.a(this.mAppendResultJson, string);
    }

    @Override
    public void setCanLeave(boolean bl) {
        super.setCanLeave(bl);
        this.loginDone = bl;
        this.attachImportResultFragment();
    }

    @Override
    public void openThirdPart(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = "";
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (!jSONObject.has("url")) {
                return;
            }
            string = jSONObject.getString("url");
            string2 = jSONObject.getString("message");
            string = Uri.parse((String)string);
            string = new Intent("android.intent.action.VIEW", (Uri)string);
            this.startActivity((Intent)string);
            return;
        }
        catch (Exception exception) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Toast.makeText((Context)this, (CharSequence)string2, (int)0).show();
            }
            return;
        }
    }

    private void showTaskStatus(String string) {
        this.showTaskStatus(string, null);
    }

    private void showTaskStatus(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    double d;
                    double d2 = Double.parseDouble(string2);
                    if (d > this.mPercent) {
                        this.mPercent = d2;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            jSONObject.put("account", (Object)this.mAccount);
            jSONObject.put("loginDone", this.loginDone);
            jSONObject.put("message", (Object)string);
            jSONObject.put("percent", (Object)(this.mPercent > 0.0 ? String.valueOf(this.mPercent) : ""));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.showTaskStatus(jSONObject);
    }

    private void showTaskStatus(final JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.attachImportResultFragment();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MainActivity.this.mImportResultFragment != null) {
                    if (!TextUtils.isEmpty((CharSequence)GlobalParams.e().a().getLoadingViewText())) {
                        MainActivity.this.mImportResultFragment.viewTaskStatusWithCustomText(GlobalParams.e().a().getLoadingViewText(), jSONObject.optString("percent"));
                        return;
                    }
                    MainActivity.this.mImportResultFragment.updateProgress(jSONObject);
                    return;
                }
                if (MainActivity.this.mImportResultCustomFragment != null) {
                    ((StatusViewListener)MainActivity.this.mImportResultCustomFragment).updateProgress(jSONObject);
                }
            }
        });
    }

    private void showSubmitErrorToast(final String string) {
        this.mResultMessage = string;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MainActivity.this.mFragment != FragmentEnum.a) {
                    return;
                }
                MainActivity.this.toast(string, null);
            }
        });
    }

    private void toast(String string, ExceptionType exceptionType) {
        if (this.isBackgroundRunMode && MoxieSDK.getInstance().getMoxieCallBack() != null) {
            MoxieSDK.getInstance().getMoxieCallBack().onError(new MoxieContext((Context)this), new MoxieException(string, exceptionType));
            return;
        }
        CommonMethod.b(this.getApplicationContext(), string);
    }

    @Override
    public void beforeLogin(SiteAccountInfo siteAccountInfo) {
        super.beforeLogin(siteAccountInfo);
        this.mAccount = siteAccountInfo.l();
        if (siteAccountInfo.h().toLowerCase().equalsIgnoreCase("ec")) {
            this.mIsUploaded = false;
        }
        this.showImportingFragment();
    }

    @Override
    public void startSubmitLogin(TaskLoginEvent.LoginSubmitStart loginSubmitStart) {
        if (!this.hasCreateTask.getAndSet(true)) {
            super.startSubmitLogin(loginSubmitStart);
        }
    }

    @Override
    public void onLoginError(TaskLoginEvent.LoginSubmitErrorEvent loginSubmitErrorEvent) {
        super.onLoginError(loginSubmitErrorEvent);
        this.hasCreateTask.set(false);
        this.mResult = -3;
        if (loginSubmitErrorEvent.c.h().toLowerCase().equalsIgnoreCase("ec")) {
            this.mWebViewOfficialFragment.f().a(loginSubmitErrorEvent.a, loginSubmitErrorEvent.c);
        }
        this.showTaskStatus(loginSubmitErrorEvent.b);
        if (this.isBackgroundRunMode) {
            this.internalFinish();
            return;
        }
        this.showSubmitErrorToast(loginSubmitErrorEvent.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoginSuccess(TaskLoginEvent.LoginSubmitSuccessEvent loginSubmitSuccessEvent) {
        Object object = this.lock;
        synchronized (object) {
            super.onLoginSuccess(loginSubmitSuccessEvent);
            this.mResult = 2;
            if (loginSubmitSuccessEvent.c != null && !TextUtils.isEmpty((CharSequence)loginSubmitSuccessEvent.c.i())) {
                mTaskId = loginSubmitSuccessEvent.c.i();
            }
            if (loginSubmitSuccessEvent.c.h().toLowerCase().equalsIgnoreCase("ec")) {
                this.mWebViewOfficialFragment.f().a(loginSubmitSuccessEvent.a, loginSubmitSuccessEvent.c);
            }
            this.showTaskStatus(loginSubmitSuccessEvent.b);
            this.mResultMessage = "";
            return;
        }
    }

    @Override
    public void setRequestBody(String string) {
        super.setRequestBody(string);
        if (!TextUtils.isEmpty((CharSequence)string) && this.mParam.isCallbackTaskInfo()) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("taskInfo", (Object)string);
                if (this.mAppendResultJson == null) {
                    this.mAppendResultJson = new JSONObject();
                }
                JsonUtil.a(this.mAppendResultJson, jSONObject);
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    @Override
    public void onTaskWorking(TaskStatusEvent.TaskStatusWorkingEvent taskStatusWorkingEvent) {
        super.onTaskWorking(taskStatusWorkingEvent);
        if (taskStatusWorkingEvent != null) {
            this.mResultMessage = taskStatusWorkingEvent.b;
        }
        this.mResult = 2;
        new StringBuilder("mIsUpload=").append(this.mIsUploaded).append("  siteAccount=").append(taskStatusWorkingEvent.c).append(" mResult=").append(this.mResult);
        if (!this.mIsUploaded && taskStatusWorkingEvent.c == null) {
            this.showTaskStatus(taskStatusWorkingEvent.e.a, taskStatusWorkingEvent.e.b);
            return;
        }
        if (!this.mIsUploaded && taskStatusWorkingEvent.c.h().toLowerCase().equalsIgnoreCase("ec")) {
            if (this.mParam.isQuitDisable()) {
                this.mResult = 2;
                return;
            }
            this.mResult = 0;
            return;
        }
        this.showTaskStatus(taskStatusWorkingEvent.e.a, taskStatusWorkingEvent.e.b);
    }

    @Override
    public void updateTaskStatusFromH5(TaskStatusEvent.TaskStatusProgressEvent taskStatusProgressEvent) {
        this.showTaskStatus(taskStatusProgressEvent.e.a, taskStatusProgressEvent.e.b);
    }

    @Override
    public void onTaskError(TaskStatusEvent.TaskStatusFinishErrorEvent taskStatusFinishErrorEvent) {
        super.onTaskError(taskStatusFinishErrorEvent);
        if (taskStatusFinishErrorEvent != null) {
            this.mResultMessage = taskStatusFinishErrorEvent.b;
        }
        this.mResult = 0;
        this.showTaskStatus(taskStatusFinishErrorEvent.b);
        if (this.isBackgroundRunMode) {
            this.internalFinish();
            return;
        }
        this.showSubmitErrorToast(taskStatusFinishErrorEvent.b);
    }

    @Override
    public void onTaskSuccess(TaskStatusEvent.TaskStatusFinishSuccessEvent taskStatusFinishSuccessEvent) {
        super.onTaskSuccess(taskStatusFinishSuccessEvent);
        if (taskStatusFinishSuccessEvent != null) {
            this.mResultMessage = taskStatusFinishSuccessEvent.b;
        }
        if (GlobalParams.e().a().getQuitLoginDone().equalsIgnoreCase("0")) {
            this.mResult = 1;
        }
        this.internalFinish();
    }

    @Override
    public void uploadFile(final UploadFileEvent uploadFileEvent) {
        LogTracker.a().a("onEventMainThread#UploadFileEvent");
        if (this.hasUpload.getAndSet(true)) {
            return;
        }
        super.uploadFile(uploadFileEvent);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object = GlobalParams.e().a().getCustomApi();
                    object = object != null && object.containsKey("upload_url") && !TextUtils.isEmpty((CharSequence)((CharSequence)object.get("upload_url"))) ? (String)object.get("upload_url") : "https://api.51datakey.com/gateway/v1/tasks/{task_id}/upload";
                    object = ((String)object).replace("{task_id}", mTaskId) + "?fileType=zip";
                    UploadFile uploadFile = new UploadFile();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Authorization", "apikey " + MainActivity.this.mParam.getApiKey());
                    boolean bl = !TextUtils.isEmpty((CharSequence)uploadFileEvent.a) ? uploadFile.a((Context)MainActivity.this, uploadFileEvent.a, uploadFileEvent.b, (String)object, hashMap) : uploadFile.a(uploadFileEvent.c, (String)object, hashMap);
                    if (bl) {
                        MainActivity.this.mIsUploaded = true;
                        MainActivity.this.mResult = 2;
                    } else {
                        MainActivity.this.mResult = 0;
                        if (MainActivity.this.isBackgroundRunMode) {
                            MainActivity.this.internalFinish();
                        } else {
                            MainActivity.this.showSubmitErrorToast("\u5bfc\u5165\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    ErrorHandle.b("Upload File error", exception);
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    ErrorHandle.b("UploadFileEvent#OutOfMemoryError", outOfMemoryError);
                    return;
                }
                finally {
                    try {
                        LogTrackInfo logTrackInfo = new LogTrackInfo();
                        logTrackInfo.d(MainActivity.this.mParam.getTaskType());
                        logTrackInfo.a();
                        if (MainActivity.this.mIsUploaded) {
                            logTrackInfo.a("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
                            logTrackInfo.c("DONE_WITH_SUCC");
                            logTrackInfo.b("CR-20000-00");
                        } else {
                            logTrackInfo.a("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
                            logTrackInfo.c("DONE_WITH_FAIL");
                            logTrackInfo.b("CR-20339-20");
                        }
                        MainActivity.this.uploadLogTracking(logTrackInfo.b());
                        LogTracker.a().b(MainActivity.this.mParam.getTaskType());
                    }
                    catch (Exception exception) {
                        ErrorHandle.b("Upload File tracking error", exception);
                    }
                    MainActivity.this.hasUpload.set(false);
                }
            }
        }).start();
    }

    @Override
    public void uploadLogs(List<JSONObject> list) {
        super.uploadLogs(list);
        LogTracker.a().a(list, mTaskId);
    }

    private void uploadLogTracking(JSONObject jSONObject) {
        LogTracker.a().a(jSONObject, mTaskId);
    }

    @Override
    public void h5Back() {
        super.h5Back();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.onBackInternal();
            }
        });
    }

    @Override
    public void saveTaskId(String string) {
        super.saveTaskId(string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            mTaskId = string;
        }
        this.mFragment = FragmentEnum.a;
    }

    @Override
    public void saveAccount(String string) {
        super.saveAccount(string);
        this.mAccount = string;
        this.showTaskStatus("", "");
    }

    @Override
    public void backToFinish(String string) {
        super.backToFinish(string);
        try {
            String string2 = "";
            if (string.startsWith("{")) {
                if ((string = new JSONObject(string)).has("code")) {
                    this.mResult = Integer.parseInt(string.getString("code"));
                }
                if (string.has("status")) {
                    string2 = string.getString("status");
                }
                if (string.has("msg")) {
                    this.mResultMessage = string.getString("msg");
                }
                this.showTaskStatus(this.mResultMessage, "");
                new StringBuilder("BackToFinish ").append(string2.toUpperCase()).append("--").append(this.mParam.getQuitOnFail());
                if (string2.toUpperCase().equalsIgnoreCase("SUCC") || string2.toUpperCase().equalsIgnoreCase("FORCE") || this.mParam.getQuitOnFail().equalsIgnoreCase("1")) {
                    this.internalFinish();
                    return;
                }
                if (this.mResult != 2 && this.mResult != 1) {
                    this.mFragment = FragmentEnum.f;
                }
                return;
            }
            this.mResult = 1;
            this.internalFinish();
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("MainActivity H5 backToFinish error", exception);
            return;
        }
    }

    @Override
    public void refreshStatus(String string) {
        super.refreshStatus(string);
        try {
            if (string.startsWith("{")) {
                if ((string = new JSONObject(string)).has("code")) {
                    this.mResult = Integer.parseInt(string.getString("code"));
                }
                if (string.has("msg")) {
                    this.mResultMessage = string.getString("msg");
                }
                if (this.mResult != 2 && this.mResult != 1) {
                    this.mFragment = FragmentEnum.f;
                }
            } else {
                this.mResult = Integer.parseInt(string);
            }
            this.showTaskStatus(this.mResultMessage, "");
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("MainActivity RefreshStatus error", exception);
            return;
        }
    }

    @Override
    public void refreshTitle(final String string) {
        super.refreshTitle(string);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject;
                    if (string.startsWith("{") && (jSONObject = new JSONObject(string)).has("title")) {
                        if (GlobalParams.e().a().getTitleParams() != null && !TextUtils.isEmpty((CharSequence)GlobalParams.e().a().getTitleParams().getTitle())) {
                            return;
                        }
                        MainActivity.this.mTitleLayout.setTitle(jSONObject.getString("title"));
                        MainActivity.this.mTitleContent = jSONObject.getString("title");
                    }
                    return;
                }
                catch (Exception exception) {
                    ErrorHandle.b("MainActivity RefreshTitle error", exception);
                    return;
                }
            }
        });
    }

    @Override
    public void refreshAgreementTitle(final String string) {
        super.refreshAgreementTitle(string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MainActivity.this.mTitleLayout.setTitle(string);
            }
        });
    }

    @Override
    public void openAgreementWebView(final String string) {
        super.openAgreementWebView(string);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    String string5 = MainActivity.this.mParam.getAgreementUrl();
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    JSONObject jSONObject = new JSONObject(string);
                    if (jSONObject.has("url") && !TextUtils.isEmpty((CharSequence)jSONObject.getString("url"))) {
                        string2 = jSONObject.getString("url");
                    }
                    if (!TextUtils.isEmpty((CharSequence)string5) && jSONObject.has("type") && jSONObject.getString("type").equalsIgnoreCase("agreement")) {
                        string2 = string5;
                    }
                    if (jSONObject.has("title") && !TextUtils.isEmpty((CharSequence)jSONObject.getString("title"))) {
                        string3 = jSONObject.getString("title");
                    }
                    if (jSONObject.has("script") && !TextUtils.isEmpty((CharSequence)jSONObject.getString("script"))) {
                        string4 = jSONObject.getString("script");
                    }
                    MainActivity.this.showWebViewAgreementH5Fragment(string2, string3, string4);
                    return;
                }
                catch (Exception exception) {
                    ErrorHandle.b("MainActivity OpenAgreement error", exception);
                    return;
                }
            }
        });
    }

    @Override
    public void showWebView(final boolean bl) {
        super.showWebView(bl);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    MainActivity.this.frameLayoutImporting.setVisibility(8);
                    return;
                }
                MainActivity.this.frameLayoutImporting.setVisibility(0);
            }
        });
    }

    @Override
    public void showAccessibleCrawler(String string) {
        super.showAccessibleCrawler(string);
        try {
            ErrorHandle.a("MainActivity showAccessibleCrawler: " + string);
            Intent intent = new Intent((Context)this, AccessibleCrawlerActivity.class);
            string = new JSONObject(string);
            String string2 = string.getString("actions");
            String string3 = string.getString("itemName");
            intent.putExtra("actions", string2);
            intent.putExtra("itemName", string3);
            if (string.has("waitingActivity")) {
                intent.putExtra("waitingActivity", string.getString("waitingActivity"));
            }
            if (string.has("description")) {
                intent.putExtra("description", string.getString("description"));
            }
            if (string.has("title")) {
                intent.putExtra("title", string.getString("title"));
            }
            if (string.has("tips")) {
                intent.putExtra("tips", string.getString("tips"));
            }
            this.startActivity(intent);
            return;
        }
        catch (JSONException jSONException) {
            ErrorHandle.b("MainActivity showAccessibleCrawler error", jSONException);
            return;
        }
    }

    @Override
    public void openOfficialWebView(String string) {
        super.openOfficialWebView(string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.optString("title");
                boolean bl = false;
                if (jSONObject.has("replace")) {
                    bl = "1".equals(jSONObject.optString("replace"));
                }
                this.showWebViewOfficialH5Fragment(null, string2, string, bl);
                this.isReloginOpened = true;
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void showWebViewMoxieH5Fragment(String string, String string2) {
        try {
            this.mWebViewCommonFragment = new WebViewMoxieH5Fragment();
            Bundle bundle = new Bundle();
            bundle.putString("url", string2);
            this.mWebViewCommonFragment.setArguments(bundle);
            string2 = this.getFragmentManager().beginTransaction();
            string2.replace(this.getResources().getIdentifier("moxie_client_fragment_main", "id", this.getPackageName()), (Fragment)this.mWebViewCommonFragment, "WebViewCommon");
            string2.commitAllowingStateLoss();
            this.mTitleLayout.setImageRightVisibility(0);
            if (this.mParam.getTitleParams() != null && !TextUtils.isEmpty((CharSequence)this.mParam.getTitleParams().getTitle())) {
                this.mTitleLayout.setTitle(this.mParam.getTitleParams().getTitle());
                this.mTitleContent = this.mParam.getTitleParams().getTitle();
            } else {
                this.mTitleLayout.setTitle(string);
                this.mTitleContent = string;
            }
            this.mFragment = FragmentEnum.f;
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("showWebViewMoxieH5Fragment fail, taskType=" + this.mParam.getTaskType(), exception);
            ErrorHandle.a((Context)this, exception);
            return;
        }
    }

    private void setTitle(String string) {
        if (this.mParam.getTitleParams() != null && !TextUtils.isEmpty((CharSequence)this.mParam.getTitleParams().getTitle())) {
            this.mTitleLayout.setTitle(this.mParam.getTitleParams().getTitle());
            this.mTitleContent = this.mParam.getTitleParams().getTitle();
            return;
        }
        this.mTitleLayout.setTitle(string);
        this.mTitleContent = string;
    }

    private void showWebViewAgreementH5Fragment(String string, String string2, String string3) {
        this.mWebViewAgreementH5Fragment = new WebViewAgreementH5Fragment();
        string2 = new Bundle();
        string2.putString("url", string);
        string2.putString("script", string3);
        this.mWebViewAgreementH5Fragment.setArguments((Bundle)string2);
        string = this.getFragmentManager().beginTransaction();
        string.replace(this.getResources().getIdentifier("moxie_client_fragment_agreement", "id", this.getPackageName()), (Fragment)this.mWebViewAgreementH5Fragment, "WebViewAgreementH5");
        string.commitAllowingStateLoss();
        this.frameLayoutAgreement.setVisibility(0);
        this.mFragmentBefore = this.mFragment;
        this.mFragment = FragmentEnum.c;
    }

    private void showImportingFragment() {
        this.attachImportResultFragment();
        this.mTitleLayout.setImageRightVisibility(8);
        this.mTitleLayout.setTitle(this.getResources().getIdentifier("moxie_client_email_result_title", "string", this.getPackageName()));
        this.mTitleContent = this.getString(this.getResources().getIdentifier("moxie_client_email_result_title", "string", this.getPackageName()));
        this.frameLayoutAgreement.setVisibility(8);
        this.frameLayoutImporting.setVisibility(0);
        this.mFragment = FragmentEnum.a;
    }

    private void attachImportResultFragment() {
        StatusViewHandler statusViewHandler = MoxieSDK.getInstance().getStatusViewHandler();
        if (statusViewHandler == null && this.mImportResultFragment == null) {
            this.mImportResultFragment = new ImportResultFragment();
            this.mImportResultCustomFragment = this.mImportResultFragment;
        } else if (statusViewHandler != null && this.mImportResultCustomFragment == null) {
            this.mImportResultCustomFragment = statusViewHandler.statusViewForMoxieSDK();
        }
        if (!this.isAttach) {
            statusViewHandler = this.getFragmentManager().beginTransaction();
            statusViewHandler.replace(this.getResources().getIdentifier("moxie_client_fragment_importing", "id", this.getPackageName()), this.mImportResultCustomFragment, "ImportResult");
            statusViewHandler.commitAllowingStateLoss();
            this.isAttach = true;
        }
    }

    private void showWebViewOfficialH5Fragment(String string, final String string2, String string3, boolean bl) {
        try {
            this.mWebViewOfficialFragment = new WebViewOfficialFragment();
            Bundle bundle = new Bundle();
            bundle.putString("host", string);
            bundle.putString("jsonData", string3);
            if (GlobalParams.e().a().getLoginCustom() != null) {
                bundle.putString("loginParams", new JSONObject(GlobalParams.e().a().getLoginCustom().getLoginParams()).toString());
            }
            this.mWebViewOfficialFragment.setArguments(bundle);
            string = this.getFragmentManager().beginTransaction();
            if (bl) {
                string.replace(this.getResources().getIdentifier("moxie_client_fragment_main", "id", this.getPackageName()), (Fragment)this.mWebViewOfficialFragment, "WebViewCommon");
            } else {
                string.add(this.getResources().getIdentifier("moxie_client_fragment_main", "id", this.getPackageName()), (Fragment)this.mWebViewOfficialFragment, "WebViewCommon");
            }
            string.addToBackStack(null);
            string.commitAllowingStateLoss();
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MainActivity.this.mTitleLayout.setImageRightVisibility(0);
                    MainActivity.this.setTitle(string2);
                }
            });
            this.mFragment = FragmentEnum.e;
            return;
        }
        catch (Exception exception) {
            ErrorHandle.b("showWebViewOfficialH5Fragment fail", exception);
            ErrorHandle.a((Context)this, exception);
            return;
        }
    }

    private void showWebViewOfficialH5Fragment(String string, String string2) {
        this.showWebViewOfficialH5Fragment(string, string2, "", false);
    }

    private void refreshFragmentRightImage() {
        new StringBuilder("refreshFragmentRightImage getFingerprint func=").append(this.mParam.getTaskType());
        if (this.mFragment.equals((Object)FragmentEnum.c)) {
            this.mWebViewAgreementH5Fragment.e();
            return;
        }
        String string = this.mParam.getTaskType();
        switch (string.hashCode()) {
            case -1414960566: {
                if (!string.equals("alipay")) break;
                break;
            }
            case -881000146: {
                if (!string.equals("taobao")) break;
                break;
            }
            case 2000326332: {
                if (!string.equals("jingdong")) break;
                break;
            }
            case 3016252: {
                if (!string.equals("bank")) break;
                break;
            }
            case 554360568: {
                if (!string.equals("carrier")) break;
                break;
            }
            case 3154629: {
                if (!string.equals("fund")) break;
                break;
            }
            case 3052923: {
                if (!string.equals("chsi")) break;
                break;
            }
            case -1318082899: {
                if (!string.equals("zhengxin")) break;
                break;
            }
            case -1081572384: {
                if (!string.equals("maimai")) break;
                break;
            }
            case 368805058: {
                if (!string.equals("shixincourt")) break;
                break;
            }
            case -445107514: {
                if (!string.equals("zhixingcourt")) break;
                break;
            }
            case 73049818: {
                if (!string.equals("insurance")) break;
                break;
            }
            case 114603: {
                if (!string.equals("tax")) break;
                break;
            }
            case 949122880: {
                if (!string.equals("security")) break;
                break;
            }
            case 96619420: {
                if (!string.equals("email")) break;
                break;
            }
            case 3616: {
                if (!string.equals("qq")) break;
                break;
            }
            case 1194692862: {
                if (!string.equals("linkedin")) break;
                break;
            }
            case 960247616: {
                string.equals("lifeinsr");
            }
        }
        if (this.mFragment.equals((Object)FragmentEnum.e)) {
            this.mWebViewOfficialFragment.e();
            return;
        }
        this.mWebViewCommonFragment.e();
    }

    private void onBackInternal() {
        boolean bl = true;
        if (!this.isSDKStart.booleanValue()) {
            this.internalFinish();
            return;
        }
        switch (this.mFragment) {
            case d: {
                this.internalFinish();
                break;
            }
            case a: {
                if (this.loginDone || this.mResult != 2) {
                    this.doCallback();
                    break;
                }
                this.mImportingDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\u6e29\u99a8\u63d0\u793a").setMessage((CharSequence)"\u79bb\u5f00\u5c06\u5bfc\u81f4\u4efb\u52a1\u5931\u8d25\uff0c\u786e\u5b9a\u5417").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        MainActivity.this.manualStopTask();
                    }
                }).setNegativeButton((CharSequence)"\u53d6\u6d88", null).setCancelable(false).show();
                break;
            }
            case c: {
                this.mFragment = this.mFragmentBefore;
                if (!TextUtils.isEmpty((CharSequence)this.mTitleContent)) {
                    this.mTitleLayout.setTitle(this.mTitleContent);
                }
                this.frameLayout.setVisibility(0);
                this.frameLayoutAgreement.setVisibility(8);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        switch (this.mParam.getTaskType()) {
            case "alipay": 
            case "taobao": 
            case "jingdong": {
                this.isBackClicked = true;
                if (this.mFragment == FragmentEnum.f) {
                    this.handleWebFragmentBack(this.mWebViewCommonFragment);
                    return;
                }
                this.handleWebFragmentBack(this.mWebViewOfficialFragment);
                return;
            }
        }
        this.isBackClicked = true;
        this.handleFragmentBackDefault();
    }

    private void handleFragmentBackDefault() {
        if (this.mFragment.equals((Object)FragmentEnum.f)) {
            this.handleWebFragmentBack(this.mWebViewCommonFragment);
            return;
        }
        if (this.mFragment.equals((Object)FragmentEnum.e) && !this.isReloginOpened) {
            this.handleWebFragmentBack(this.mWebViewOfficialFragment);
            return;
        }
        if (this.mFragment.equals((Object)FragmentEnum.e) && this.isReloginOpened && this.getFragmentManager() != null && this.getFragmentManager().getBackStackEntryCount() > 0) {
            this.getFragmentManager().popBackStackImmediate();
            if (this.getFragmentManager().getBackStackEntryCount() == 0) {
                this.mFragment = FragmentEnum.f;
                this.isReloginOpened = false;
            }
        }
    }

    private void handleWebFragmentBack(BaseWebViewFragment baseWebViewFragment) {
        if (baseWebViewFragment != null && !baseWebViewFragment.c().booleanValue()) {
            this.internalFinish();
            return;
        }
        if (this.isBackClicked) {
            this.mTitleLayout.setLeftTextVisibility(0);
        }
    }

    @Deprecated
    protected boolean onBack(JSONObject jSONObject) {
        return false;
    }

    private void internalFinish() {
        this.stopTask();
        this.doCallback();
    }

    private void doCallback() {
        JSONObject jSONObject = this.setResultToCalledActivity();
        if (!(this.onBack(jSONObject) || MoxieSDK.getInstance().getMoxieCallBack() != null && MoxieSDK.getInstance().getMoxieCallBack().callback(new MoxieContext((Context)this), this.getMoxieCallbackData()))) {
            this.finish();
        }
    }

    private MoxieCallBackData getMoxieCallbackData() {
        MoxieCallBackData moxieCallBackData = new MoxieCallBackData();
        try {
            moxieCallBackData.setCode(this.mResult);
            moxieCallBackData.setTaskType(this.mParam.getTaskType());
            moxieCallBackData.setTaskId(mTaskId);
            moxieCallBackData.setMessage(this.mResultMessage);
            moxieCallBackData.setAccount(this.mAccount);
            moxieCallBackData.setLoginDone(this.loginDone);
            if (this.mAppendResultJson != null) {
                try {
                    if (this.mAppendResultJson.has("businessUserId")) {
                        moxieCallBackData.setBusinessUserId(this.mAppendResultJson.getString("businessUserId"));
                    }
                    moxieCallBackData.setAppendResult(this.mAppendResultJson.toString());
                }
                catch (JSONException jSONException) {
                    ErrorHandle.a(TAG, jSONException);
                }
            }
        }
        catch (Exception exception) {
            ErrorHandle.b("MainActivity getMoxieCallbackData error", exception);
        }
        return moxieCallBackData;
    }

    private void sendUserCancelLogTrack() {
        LogTrackInfo logTrackInfo = new LogTrackInfo.Builder().c(this.mParam.getTaskType()).a("CR-42901-00").d("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88").a().b("DONE_WITH_FAIL").b();
        this.uploadLogTracking(logTrackInfo.b());
    }

    public void finish() {
        this.stopTask();
        this.setResultToCalledActivity();
        MxACRA.c();
        super.finish();
    }

    private JSONObject setResultToCalledActivity() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", this.mResult);
            jSONObject.put("taskType", (Object)this.mParam.getTaskType());
            jSONObject.put("taskId", (Object)mTaskId);
            jSONObject.put("message", (Object)this.mResultMessage);
            jSONObject.put("account", (Object)this.mAccount);
            jSONObject.put("loginDone", this.loginDone);
            JsonUtil.a(jSONObject, this.mAppendResultJson);
            Intent intent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putString("result", jSONObject.toString());
            intent.putExtras(bundle);
            this.setResult(-1, intent);
            return jSONObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.hideDialog(this.mLoadingFlower);
        this.hideDialog(this.mImportingDialog);
        this.hideDialog(this.mPermissionDialog);
        this.mTitleLayout = null;
        this.mLoadingFlower = null;
        this.mImportingDialog = null;
        this.mPermissionDialog = null;
        this.mImportResultCustomFragment = null;
        this.mImportResultFragment = null;
        mTaskId = "";
        ActivityDispatcher.a().b();
    }

    private void hideDialog(Dialog dialog) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    private void showLoadingFlower() {
        if (this.isBackgroundRunMode) {
            return;
        }
        if (this.mLoadingFlower == null) {
            this.mLoadingFlower = new LoadingFlower.Builder((Context)this).c().a().b().d();
            this.mLoadingFlower.setCancelable(false);
        }
        if (!this.mLoadingFlower.isShowing()) {
            this.mLoadingFlower.show();
        }
    }

    public void onBackPressed() {
        this.onBackInternal();
    }

    @Override
    public void nativeFinishCallback(String string) {
        super.nativeFinishCallback(string);
        try {
            string = new JSONObject(string);
            this.mWebViewOfficialFragment.f().a(string.getString("code"), string.has("data") ? string.getString("data") : "", string.getString("itemName"));
            return;
        }
        catch (JSONException jSONException) {
            ErrorHandle.b("MainActivity nativeFinishCallback error", jSONException);
            return;
        }
    }

    @Override
    public void saveFileWithName(String string) {
        super.saveFileWithName(string);
        try {
            string = new JSONObject(string);
            this.mWebViewOfficialFragment.f().a(string.getString("fileName"), string.has("content") ? string.getString("content") : "");
            return;
        }
        catch (JSONException jSONException) {
            ErrorHandle.b("MainActivity saveFileWithName error", jSONException);
            return;
        }
    }

    @Override
    public void manualStopTask() {
        this.sendUserCancelLogTrack();
        this.internalFinish();
    }
}

