/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.accessible;

import android.accessibilityservice.AccessibilityService;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Toast;
import com.moxie.client.accessible.AccessibleCrawlerActivity;
import com.moxie.client.accessible.e;
import com.moxie.client.accessible.f;
import com.moxie.client.accessible.g;
import com.moxie.client.accessible.j;
import com.moxie.client.c.a.a;
import com.moxie.client.c.c;
import com.moxie.client.c.d;
import com.proguard.annotation.NotProguard;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.json.JSONObject;

@NotProguard
public class AccessibleCrawlerService
extends AccessibilityService {
    private final String TAG = AccessibleCrawlerService.class.getSimpleName();
    private Handler timeoutHandler = new Handler((Handler.Callback)new f(this));
    private Toast toast;

    public void onCreate() {
        super.onCreate();
        if (!e.a().d.get()) {
            if (e.a().a != null && e.a().a.size() > 0) {
                com.moxie.client.dfp.android.a.b.a.c c2 = (com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(0);
                this.jumpActivity(c2.a());
                this.showToast("\u8f85\u52a9\u8ba4\u8bc1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
                this.restartTimeoutTimer();
                return;
            }
            this.backActivityWithResult(false);
        }
    }

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (!e.a().d.get()) {
            int n2 = accessibilityEvent.getEventType();
            switch (n2) {
                case 2048: {
                    this.handleContentChanged(accessibilityEvent.getClassName().toString(), false);
                    if (e.a().b == null || !e.a().b.contains(accessibilityEvent.getClassName().toString())) break;
                    this.restartTimeoutTimer();
                    return;
                }
                case 1: 
                case 8: 
                case 32: 
                case 0x400000: {
                    this.handleEvent(accessibilityEvent.getClassName().toString());
                    this.restartTimeoutTimer();
                }
            }
        }
    }

    @TargetApi(value=16)
    private AccessibilityNodeInfo getNodeInfoWithRetry(int n2) {
        AccessibilityNodeInfo accessibilityNodeInfo;
        while (true) {
            accessibilityNodeInfo = this.getRootInActiveWindow();
            if (n2 < 0) {
                return null;
            }
            if (accessibilityNodeInfo != null) break;
            SystemClock.sleep((long)200L);
            --n2;
        }
        return accessibilityNodeInfo;
    }

    private synchronized void handleEvent(String string) {
        AccessibilityNodeInfo accessibilityNodeInfo = this.getNodeInfoWithRetry(20);
        if (accessibilityNodeInfo != null && this.checkActivity$53c4c1ca(accessibilityNodeInfo, string, (com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.get()))) {
            this.doNext(accessibilityNodeInfo);
        }
    }

    private synchronized boolean handleContentChanged(String string, boolean bl) {
        if (e.a().b != null && e.a().b.contains(((com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.get())).b())) {
            string = this.getNodeInfoWithRetry(20);
            if (string != null && this.checkActivity$53c4c1ca((AccessibilityNodeInfo)string, ((com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.get())).b(), (com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.get()))) {
                this.doNext((AccessibilityNodeInfo)string);
                return true;
            }
            if (bl) {
                if (string != null) {
                    com.moxie.client.f.e.c("AccessibleCrawlerService handleContentChanged", new Exception(this.crawView((AccessibilityNodeInfo)string).a().toString()));
                } else {
                    com.moxie.client.f.e.c("AccessibleCrawlerService handleContentChanged", new Exception("nodeInfo is null"));
                }
            }
            return false;
        }
        return false;
    }

    private void doNext(AccessibilityNodeInfo accessibilityNodeInfo) {
        String string = ((com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.get())).c();
        this.saveFile((accessibilityNodeInfo = this.crawView(accessibilityNodeInfo).a()) != null ? accessibilityNodeInfo.toString() : "{}", string);
        if (e.a().c.get() == e.a().a.size() - 1) {
            this.backActivityWithResult(true);
            return;
        }
        this.jumpActivity(((com.moxie.client.dfp.android.a.b.a.c)e.a().a.get(e.a().c.addAndGet(1))).a());
        this.showToast("\u8f85\u52a9\u8ba4\u8bc1\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e...");
    }

    private void saveFile(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            string2 = "accessiblecrawler#" + string2 + "#" + this.getAlipayVersion() + ".json";
            jSONObject.put("fileName", (Object)string2);
            jSONObject.put("content", (Object)string);
            if (c.b() == null) {
                this.backActivityWithResult(false);
                return;
            }
            c.a(d.D, jSONObject.toString());
        }
        catch (Exception exception) {
            com.moxie.client.f.e.b("AccessibleCrawlerService doNext saveFile", exception);
        }
    }

    private String getAlipayVersion() {
        try {
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            packageManager = packageManager.getPackageInfo("com.eg.android.AlipayGphone", 16384);
            return packageManager.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            com.moxie.client.f.e.b("AccessibleCrawlerService getAlipayVersion", nameNotFoundException);
            return "unknown";
        }
    }

    private boolean checkActivity$53c4c1ca(AccessibilityNodeInfo accessibilityNodeInfo, String iterator, com.moxie.client.dfp.android.a.b.a.c c2) {
        if (((String)((Object)iterator)).equals(c2.b())) {
            iterator = c2.d();
            boolean bl = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = (List)iterator.next();
                boolean bl2 = true;
                object = object.iterator();
                while (object.hasNext()) {
                    a a2 = (a)object.next();
                    bl2 = bl2 && this.checkView$6b60a0cd(accessibilityNodeInfo, a2);
                }
                bl = bl || bl2;
            }
            return bl;
        }
        return false;
    }

    @TargetApi(value=18)
    private boolean checkView$6b60a0cd(AccessibilityNodeInfo object, a a2) {
        if ("content".equals(a2.a())) {
            return this.checkViewByContent((AccessibilityNodeInfo)object, a2.b());
        }
        if ((object = object.findAccessibilityNodeInfosByViewId(a2.a())).size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (AccessibilityNodeInfo)object.next();
                String string = null;
                if (object2.getContentDescription() != null && !"".contentEquals(object2.getContentDescription())) {
                    string = String.valueOf(object2.getContentDescription());
                } else if (object2.getText() != null && !"".contentEquals(object2.getText())) {
                    string = String.valueOf(object2.getText());
                }
                if (string == null || !(object2 = Pattern.compile(a2.b())).matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean checkViewByContent(AccessibilityNodeInfo accessibilityNodeInfo, String string) {
        if (accessibilityNodeInfo != null) {
            String string2 = String.valueOf(accessibilityNodeInfo.getText());
            String string3 = String.valueOf(accessibilityNodeInfo.getContentDescription());
            if (string2 != null && string2.contains(string) || string3 != null && string3.contains(string)) {
                return true;
            }
            int n2 = accessibilityNodeInfo.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.checkViewByContent(accessibilityNodeInfo.getChild(i2), string)) continue;
                return true;
            }
        }
        return false;
    }

    private j crawView(AccessibilityNodeInfo accessibilityNodeInfo) {
        if (accessibilityNodeInfo == null || accessibilityNodeInfo.getChildCount() <= 0) {
            return new j(accessibilityNodeInfo);
        }
        j j2 = new j(accessibilityNodeInfo);
        ArrayList<j> arrayList = new ArrayList<j>();
        int n2 = accessibilityNodeInfo.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.crawView(accessibilityNodeInfo.getChild(i2)));
        }
        j2.a(arrayList);
        return j2;
    }

    public void onInterrupt() {
        com.moxie.client.f.e.a("AccessibleCrawlerService onInterrupt");
    }

    private void jumpActivity(String string) {
        string = Uri.parse((String)string);
        string = new Intent("android.intent.action.VIEW", (Uri)string);
        string.setFlags(0x10000000);
        this.startActivity((Intent)string);
    }

    private void justBackActivity() {
        Intent intent = new Intent(this.getApplicationContext(), AccessibleCrawlerActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
    }

    private void showToast(String string) {
        if (!e.a().d.get()) {
            if (this.toast == null) {
                this.toast = Toast.makeText((Context)this, (CharSequence)"", (int)1);
            }
            this.toast.setText((CharSequence)string);
            this.toast.show();
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.disableSelf();
        }
    }

    private void restartTimeoutTimer() {
        if (e.a().f != null) {
            e.a().f.cancel();
            e.a().f = null;
        }
        e.a().f = new Timer();
        e.a().f.schedule((TimerTask)new g(this), 5000L);
    }

    private void backActivityWithResult(boolean bl) {
        Intent intent = new Intent(this.getApplicationContext(), AccessibleCrawlerActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
        e.a().c.set(0);
        e.a().d.set(true);
        e.a().e.set(bl);
        if (e.a().f != null) {
            e.a().f.cancel();
            e.a().f = null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.disableSelf();
        }
    }

    static /* synthetic */ boolean access$000(AccessibleCrawlerService accessibleCrawlerService, String string, boolean bl) {
        return accessibleCrawlerService.handleContentChanged(string, bl);
    }

    static /* synthetic */ void access$100(AccessibleCrawlerService accessibleCrawlerService, String string) {
        accessibleCrawlerService.showToast(string);
    }

    static /* synthetic */ Handler access$200(AccessibleCrawlerService accessibleCrawlerService) {
        return accessibleCrawlerService.timeoutHandler;
    }
}

