/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.mxcurllib.cache;

import android.annotation.SuppressLint;
import android.os.Build;
import com.moxie.mxcurllib.cache.Cache;
import com.moxie.mxcurllib.cache.CacheFile;
import com.moxie.mxcurllib.util.Logger;
import com.moxie.mxcurllib.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiskCache
implements Cache {
    private final SortedMap<String, CacheFile> fileMap;
    private final Map<String, Long> lastAccessTimeMap;
    private final LinkedBlockingQueue<CacheFile> accessTimeUpdateQueue;
    private final File path;
    private final int maxCacheSizeInBytes;
    private final long evictIntervalMillis;
    private final Timer accessTimeUpdateTimer;
    private final Timer evictTimer;
    private long lastWrite;
    private long lastEvict;
    private static final Logger logger = Logger.getLogger(DiskCache.class);
    private static final Pattern PATTERN_FILE = Pattern.compile("(\\w+)(?:\\.meta){0,1}$");

    private DiskCache(File file, int n, long l, long l2, float f) {
        this.path = file;
        this.maxCacheSizeInBytes = n;
        this.evictIntervalMillis = l2;
        this.lastAccessTimeMap = new ConcurrentHashMap<String, Long>();
        this.fileMap = Collections.synchronizedSortedMap(new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String object, String object2) {
                object = (Long)DiskCache.this.lastAccessTimeMap.get(object);
                object2 = (Long)DiskCache.this.lastAccessTimeMap.get(object2);
                return this.compare(object2 == null ? 0L : (Long)object2, object == null ? 0L : (Long)object);
            }

            @Override
            private int compare(long l, long l2) {
                if (l < l2) {
                    return -1;
                }
                return 1;
            }
        }));
        this.accessTimeUpdateQueue = new LinkedBlockingQueue();
        this.accessTimeUpdateTimer = new Timer();
        this.initAccessTimeSyncTimer(l);
        if (n > 0) {
            this.evictTimer = new Timer();
            this.initEvictTimer(l2, f);
            return;
        }
        this.evictTimer = null;
    }

    private void initEvictTimer(long l, final float f) {
        logger.i("init evict task timer");
        this.evictTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (DiskCache.this.lastEvict > DiskCache.this.lastWrite) {
                        logger.d("no write since last evict, skip");
                        return;
                    }
                    long l = System.currentTimeMillis();
                    final HashMap hashMap = new HashMap();
                    TreeMap treeMap = new TreeMap(new Comparator<String>(){

                        @Override
                        public int compare(String object, String object2) {
                            object = (Long)hashMap.get(object);
                            object2 = (Long)hashMap.get(object2);
                            return this.compare(object == null ? 0L : (Long)object, object2 == null ? 0L : (Long)object2);
                        }

                        @Override
                        private int compare(long l, long l2) {
                            if (l < l2) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                    AtomicLong atomicLong = new AtomicLong();
                    DiskCache.this.getTotalBytes(DiskCache.this.path, atomicLong, hashMap, treeMap);
                    long l2 = atomicLong.get();
                    logger.v("calculate total bytes, time: %d, size=%d", System.currentTimeMillis() - l, l2);
                    long l3 = (long)((float)DiskCache.this.maxCacheSizeInBytes * f);
                    if (l2 < l3) {
                        logger.d("cache size safe, just return: current=%d, limit=%d", l2, DiskCache.this.maxCacheSizeInBytes);
                        DiskCache.this.lastEvict = System.currentTimeMillis();
                        return;
                    }
                    long l4 = l2;
                    int n = 0;
                    for (Map.Entry entry : treeMap.entrySet()) {
                        if (l4 < l3) break;
                        logger.v("evict item: key=%s, size=%d, lastAccess=%d", entry.getKey(), entry.getValue(), hashMap.get(entry.getKey()));
                        try {
                            DiskCache.this.remove((String)entry.getKey());
                            l4 -= ((Long)entry.getValue()).longValue();
                            ++n;
                        }
                        catch (IOException iOException) {
                            logger.w("evict key fail: %s", entry.getKey(), iOException);
                        }
                    }
                    logger.i("evict done: expect=%d, before=%d, after=%d, time=%d, keys=%d", l3, l2, l4, System.currentTimeMillis() - l, n);
                    DiskCache.this.lastEvict = System.currentTimeMillis();
                    return;
                }
                catch (Throwable throwable) {
                    logger.w("evict running fail", throwable);
                    return;
                }
            }
        }, l, l);
    }

    private void getTotalBytes(File fileArray, AtomicLong atomicLong, Map<String, Long> map, SortedMap<String, Long> sortedMap) {
        if (fileArray.isDirectory()) {
            for (File file : fileArray.listFiles()) {
                if (file.isFile()) {
                    Object object;
                    String string = file.getName();
                    Object object2 = PATTERN_FILE.matcher(string);
                    if (!((Matcher)object2).find()) continue;
                    object2 = ((Matcher)object2).group(1);
                    if (string.endsWith(".meta")) {
                        object = this.lastAccessTimeMap.get(object2);
                        if (object == null) {
                            object = file.lastModified();
                        }
                        map.put((String)object2, (Long)object);
                    } else {
                        object = this.lastAccessTimeMap.get(object2);
                        if (object != null) {
                            map.put((String)object2, (Long)object);
                        } else if (map.get(object2) == null) {
                            try {
                                object = this.decodeMeta(new File(file.getAbsolutePath() + ".meta"));
                                if (object != null) {
                                    map.put((String)object2, ((CacheFile)object).getLastAccessMillis());
                                }
                            }
                            catch (IOException iOException) {
                                logger.w("read meta fail: " + string, iOException);
                            }
                        }
                    }
                    object = (Long)sortedMap.get(object2);
                    if (object == null) {
                        object = 0L;
                    }
                    object = (Long)object + file.length();
                    sortedMap.put((String)object2, (Long)object);
                    atomicLong.addAndGet(file.length());
                    continue;
                }
                this.getTotalBytes(file, atomicLong, map, sortedMap);
            }
        }
    }

    private void initAccessTimeSyncTimer(long l) {
        logger.i("init last access time sync task timer");
        this.accessTimeUpdateTimer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (DiskCache.this.accessTimeUpdateQueue.isEmpty()) {
                        return;
                    }
                    ArrayList<CacheFile> arrayList = new ArrayList<CacheFile>();
                    int n = 0;
                    long l = System.currentTimeMillis();
                    while (!DiskCache.this.accessTimeUpdateQueue.isEmpty()) {
                        try {
                            CacheFile cacheFile = (CacheFile)DiskCache.this.accessTimeUpdateQueue.take();
                            try {
                                String string = cacheFile.getKey().intern();
                                synchronized (string) {
                                    DiskCache.this.writeMeta(cacheFile);
                                }
                                ++n;
                            }
                            catch (IOException iOException) {
                                logger.w("flush meta file to disk fail %s", (Object)cacheFile.getKey(), iOException);
                                arrayList.add(cacheFile);
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    logger.i("flush meta task done: count=%d, time=%d", n, System.currentTimeMillis() - l);
                    if (arrayList.size() > 0) {
                        logger.i("flush meta fail, try reflush next time: %d", (Object)arrayList.size());
                        DiskCache.this.accessTimeUpdateQueue.addAll(arrayList);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    logger.w("flush meta fail", throwable);
                    return;
                }
            }
        }, l, l);
    }

    @Override
    public CacheFile get(String object) {
        if ((object = this.getCacheFile((String)object)) == null) {
            return null;
        }
        return object;
    }

    @Override
    public File getFile(CacheFile cacheFile) {
        if (cacheFile == null) {
            return null;
        }
        String string = this.getFilePath(cacheFile.getKey());
        File file = new File(string);
        if (file.exists() && file.length() == cacheFile.getFileSize()) {
            logger.d("read file as stream: %s %s", (Object)cacheFile.getKey(), file.getAbsolutePath());
            return file;
        }
        logger.w("destory corrupted file: %s, %s", (Object)cacheFile.getKey(), string);
        this.remove(cacheFile.getKey());
        return null;
    }

    @Override
    public InputStream getInputStream(CacheFile object) {
        if ((object = this.getFile((CacheFile)object)) != null) {
            return new FileInputStream((File)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String string, byte[] byArray, Map<String, String> object) {
        String string2 = string.intern();
        synchronized (string2) {
            object = new CacheFile(string, byArray.length, System.currentTimeMillis(), System.currentTimeMillis(), (Map<String, String>)object);
            logger.d("cache file: %s", (Object)string);
            Object object2 = new File(this.getFileDir(string));
            if (!((File)object2).exists()) {
                ((File)object2).mkdirs();
            }
            object2 = new File(this.getFilePath(string));
            object2 = new FileOutputStream((File)object2);
            try {
                ((FileOutputStream)object2).write(byArray);
                ((OutputStream)object2).flush();
            }
            finally {
                ((FileOutputStream)object2).close();
            }
            this.writeMeta((CacheFile)object);
            this.fileMap.put(string, (CacheFile)object);
            this.lastWrite = System.currentTimeMillis();
            return;
        }
    }

    private void writeMeta(CacheFile cacheFile) {
        Object object = cacheFile.getKey();
        File file = new File(this.getFileDir((String)object));
        if (!file.exists()) {
            file.mkdirs();
        }
        object = new File(this.getMetaFilePath((String)object));
        object = new FileOutputStream((File)object);
        try {
            ((FileOutputStream)object).write(this.encodeMeta(cacheFile).getBytes());
            ((OutputStream)object).flush();
            return;
        }
        finally {
            ((FileOutputStream)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string) {
        String string2 = string.intern();
        synchronized (string2) {
            logger.d("delete file: %s", (Object)string);
            File file = new File(this.getFilePath(string));
            File file2 = new File(this.getMetaFilePath(string));
            if (file2.exists()) {
                file2.delete();
            }
            if (file.exists()) {
                file.delete();
            }
            this.fileMap.remove(string);
            this.lastAccessTimeMap.remove(string);
            return;
        }
    }

    private CacheFile getCacheFile(String string) {
        Object object = (CacheFile)this.fileMap.get(string);
        if (object != null) {
            logger.d("memory hit: %s", (Object)string);
        } else {
            logger.d("trying load meta from disk: %s", (Object)string);
            object = this.getMetaFilePath(string);
            object = new File((String)object);
            object = this.decodeMeta((File)object);
            if (object != null) {
                logger.d("disk hit: %s", (Object)string);
                this.lastAccessTimeMap.put(string, System.currentTimeMillis());
                this.fileMap.put(string, (CacheFile)object);
            }
        }
        if (object != null) {
            this.updateLastAccess((CacheFile)object);
        }
        return object;
    }

    public void updateLastAccess(CacheFile cacheFile) {
        logger.v("enqueue lastAccess task: %s", (Object)cacheFile.getKey());
        this.accessTimeUpdateQueue.remove(cacheFile);
        long l = System.currentTimeMillis();
        cacheFile.setLastAccessMillis(l);
        this.lastAccessTimeMap.put(cacheFile.getKey(), l);
        this.accessTimeUpdateQueue.add(cacheFile);
    }

    private String getFileDir(String string) {
        return String.format("%s/%s/%s/", this.path.getAbsolutePath(), string.substring(0, 1), string.substring(1, 2));
    }

    private String getFilePath(String string) {
        return String.format("%s%s", this.getFileDir(string), string);
    }

    private String getMetaFilePath(String string) {
        return this.getFilePath(string) + ".meta";
    }

    private String encodeMeta(CacheFile iterator) {
        StringBuilder stringBuilder = new StringBuilder().append("key=" + ((CacheFile)((Object)iterator)).getKey() + "\n").append("fileSize=" + ((CacheFile)((Object)iterator)).getFileSize() + "\n").append("lastAccess=" + ((CacheFile)((Object)iterator)).getLastAccessMillis() + "\n").append("createTime=" + ((CacheFile)((Object)iterator)).getCreateTimeMillis() + "\n");
        if ((iterator = ((CacheFile)((Object)iterator)).getMeta()) != null && iterator.size() > 0) {
            for (Map.Entry entry : iterator.entrySet()) {
                stringBuilder.append("meta." + (String)entry.getKey() + "=" + (String)entry.getValue() + "\n");
            }
        }
        return stringBuilder.toString();
    }

    private CacheFile decodeMeta(File file) {
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Object object2;
            while ((object2 = bufferedReader.readLine()) != null) {
                if ((object2 = StringUtils.split((String)object2, "=", 2)) == null || ((String[])object2).length != 2) continue;
                String[] stringArray = object2[0];
                object2 = object2[1];
                if ("key".equals(stringArray)) {
                    object = object2;
                    continue;
                }
                if ("fileSize".equals(stringArray)) {
                    l3 = Long.parseLong((String)object2);
                    continue;
                }
                if ("lastAccess".equals(stringArray)) {
                    l = Long.parseLong((String)object2);
                    continue;
                }
                if ("createTime".equals(stringArray)) {
                    l2 = Long.parseLong((String)object2);
                    continue;
                }
                if (!stringArray.startsWith("meta.") || (stringArray = StringUtils.split((String)stringArray, ".", 2)) == null || stringArray.length != 2) continue;
                hashMap.put(stringArray[1], (String)object2);
            }
            if (object != null) {
                object2 = new CacheFile((String)object, l3, l, l2, (Map<String, String>)hashMap);
                return object2;
            }
            logger.w("invalid meta file: %s, delete!", (Object)file.getAbsolutePath());
            file.delete();
        }
        finally {
            bufferedReader.close();
        }
        return null;
    }

    public static class Builder {
        private File path;
        private int maxCacheSizeInBytes;
        private long evictIntervalMillis = 120000L;
        private long accessTimeSyncMillis = 120000L;
        private float evictFactor = 0.75f;

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder cachePath(File file) {
            this.path = file;
            return this;
        }

        public Builder maxCacheSizeInBytes(int n) {
            this.maxCacheSizeInBytes = n;
            return this;
        }

        public Builder evictIntervalMillis(long l) {
            this.evictIntervalMillis = l;
            return this;
        }

        public Builder evictFactor(float f) {
            this.evictFactor = f;
            return this;
        }

        public Builder accessTimeSyncMillis(long l) {
            this.accessTimeSyncMillis = l;
            return this;
        }

        @SuppressLint(value={"NewApi"})
        public DiskCache build() {
            long l;
            long l2;
            if (this.path == null) {
                throw new IllegalStateException("cachePath not set");
            }
            int n = this.maxCacheSizeInBytes;
            if (Build.VERSION.SDK_INT >= 9 && (long)this.maxCacheSizeInBytes > (l2 = (long)((double)(l = this.path.getFreeSpace()) * 0.75))) {
                logger.w("maxCacheSizeInBytes too big, adjust: %d->%d free=%d", this.maxCacheSizeInBytes, n, l);
                n = (int)l2;
            }
            return new DiskCache(this.path, n, this.accessTimeSyncMillis, this.evictIntervalMillis, this.evictFactor);
        }
    }
}

