/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.mxcurllib;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class CurlResponse {
    private static final String TAG = CurlResponse.class.getSimpleName();
    private final int status;
    private final String statusLine;
    private final Map<String, List<String>> headers;
    private final byte[] body;
    private transient String bodyString;
    private transient byte[] decodedBody;

    public CurlResponse(int n, String string, Map<String, List<String>> map, byte[] byArray) {
        this.status = n;
        this.statusLine = string;
        this.headers = map;
        this.body = byArray;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeader(String object) {
        if ((object = this.headers.get(object)) != null && object.size() > 0) {
            return object;
        }
        return new ArrayList<String>();
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] getDecodedBody() {
        if (this.getHeader("Content-Encoding").size() <= 0 || !"gzip".equalsIgnoreCase(this.getHeader("Content-Encoding").get(0))) {
            return this.body;
        }
        if (this.decodedBody == null) {
            int n;
            Log.d((String)TAG, (String)"uncompress gzipped content");
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(this.body));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.body.length * 3);
            byte[] byArray = new byte[4096];
            while ((n = gZIPInputStream.read(byArray, 0, 4096)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.decodedBody = byteArrayOutputStream.toByteArray();
            gZIPInputStream.close();
            byteArrayOutputStream.close();
        }
        return this.decodedBody;
    }

    public String getBodyAsString() {
        if (this.bodyString == null) {
            this.bodyString = new String(this.getDecodedBody());
        }
        return this.bodyString;
    }

    public String getBodyAsString(String string) {
        if (this.bodyString == null) {
            this.bodyString = new String(this.getDecodedBody(), string);
        }
        return this.bodyString;
    }
}

