/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.mxcurllib;

import com.moxie.mxcurllib.Curl;
import com.moxie.mxcurllib.CurlCode;
import com.moxie.mxcurllib.CurlConstant;
import com.moxie.mxcurllib.CurlException;
import com.moxie.mxcurllib.CurlFormCode;
import com.moxie.mxcurllib.CurlOpt;
import com.moxie.mxcurllib.CurlResponse;
import com.moxie.mxcurllib.easy.MultiPart;
import com.moxie.mxcurllib.easy.NameValuePair;
import com.moxie.mxcurllib.util.CaseInsensitiveMap;
import com.moxie.mxcurllib.util.Logger;
import com.moxie.mxcurllib.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurlHttp {
    private static final String TAG = CurlHttp.class.getSimpleName();
    private static final Logger logger = Logger.getLogger(CurlHttp.class);
    private Curl curl;
    private Map<String, String> headerMap;
    private List<MultiPart> multiPartList;
    private List<NameValuePair> simplePairList;
    private byte[] body;
    private String requestMethod;
    private boolean followLocation = true;
    private int maxRedirects = 3;
    private boolean useSystemProxy = true;
    private String proxyHost;
    private int proxyPort;
    private boolean asMultipart = false;
    private String url;
    private final Pattern STATUS_PATTERN = Pattern.compile("HTTP/\\d+\\.\\d+\\s+(\\d+)\\s+");

    private CurlHttp() {
        this.curl = new Curl();
    }

    protected void finalize() {
        if (this.curl != null) {
            this.curl.curlEasyCleanup();
        }
        super.finalize();
    }

    public static CurlHttp newInstance() {
        CurlHttp curlHttp = new CurlHttp();
        curlHttp.curl.curlEasyInit();
        curlHttp.headerMap = new HashMap<String, String>();
        curlHttp.headerMap.put("User-Agent", "curlcore/" + curlHttp.curl.curlVersion() + " MXCURL/1.0");
        return curlHttp;
    }

    public CurlHttp addHeader(String string, String string2) {
        this.headerMap.put(string, string2);
        return this;
    }

    public CurlHttp addHeaders(Map<String, String> map) {
        this.headerMap.putAll(map);
        return this;
    }

    public CurlHttp setConnectionTimeoutMillis(long l) {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_CONNECTTIMEOUT_MS, l);
        return this;
    }

    public CurlHttp setTimeoutMillis(long l) {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_TIMEOUT_MS, l);
        return this;
    }

    public CurlHttp setIpResolveV4() {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_IPRESOLVE, CurlConstant.CURL_IPRESOLVE_V4);
        return this;
    }

    public CurlHttp setIpResolveV6() {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_IPRESOLVE, CurlConstant.CURL_IPRESOLVE_V6);
        return this;
    }

    public CurlHttp setIpResolveWhatever() {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_IPRESOLVE, CurlConstant.CURL_IPRESOLVE_WHATEVER);
        return this;
    }

    public CurlHttp closeSslVerify() {
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_SSL_VERIFYHOST, 0L);
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_SSL_VERIFYPEER, 0L);
        return this;
    }

    public CurlHttp setProxy(String string) {
        this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_PROXY, string);
        this.closeSslVerify();
        return this;
    }

    public CurlHttp setFollowLocation(boolean bl) {
        this.followLocation = bl;
        return this;
    }

    public CurlHttp setCookieJar(String string) {
        this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_COOKIEFILE, string);
        this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_COOKIEJAR, string);
        return this;
    }

    public CurlHttp setMaxRedirects(int n) {
        this.maxRedirects = n;
        return this;
    }

    public CurlHttp setHttpProxy(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
        this.closeSslVerify();
        return this;
    }

    public CurlHttp useSystemProxy(boolean bl) {
        this.useSystemProxy = bl;
        return this;
    }

    public CurlHttp postAsMultipart(boolean bl) {
        this.asMultipart = bl;
        return this;
    }

    public CurlHttp getUrl(String string) {
        if (this.checkCurrentRequestMethod()) {
            throw new IllegalArgumentException("A " + this.requestMethod + " url already set!");
        }
        this.requestMethod = "GET";
        this.url = string;
        return this;
    }

    public CurlHttp postUrl(String string) {
        if (this.checkCurrentRequestMethod()) {
            throw new IllegalArgumentException("A " + this.requestMethod + " url already set!");
        }
        this.requestMethod = "POST";
        this.url = string;
        return this;
    }

    public CurlHttp url(String string) {
        this.url = string;
        return this;
    }

    public CurlHttp method(String string) {
        if (!CurlRequestMethod.METHOD_SET.contains(string)) {
            throw new IllegalArgumentException("unknown request method : " + string);
        }
        if (this.checkCurrentRequestMethod()) {
            throw new IllegalArgumentException("A " + this.requestMethod + " url already set!");
        }
        this.requestMethod = string;
        return this;
    }

    public CurlHttp addParam(String string, String string2) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("name is required");
        }
        if (this.simplePairList == null) {
            this.simplePairList = new ArrayList<NameValuePair>();
        }
        this.simplePairList.add(new NameValuePair(string, string2));
        return this;
    }

    public CurlHttp addParam(String string, List<String> object) {
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                this.addParam(string, string2);
            }
        }
        return this;
    }

    public CurlHttp addMultiPartPostParam(String string, String string2, String string3, byte[] byArray) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("name is required");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("content is required");
        }
        if (this.multiPartList == null) {
            this.multiPartList = new ArrayList<MultiPart>();
        }
        this.multiPartList.add(new MultiPart(string, string2, string3, byArray));
        return this;
    }

    public CurlHttp setBody(String string, byte[] byArray) {
        this.addHeader("Content-Type", string);
        this.body = byArray;
        return this;
    }

    private void setHeaderCallback(final Map<String, List<String>> map, final AtomicInteger atomicInteger, final StringBuffer stringBuffer) {
        this.curl.curlEasySetopt(CurlOpt.OptFunctionPoint.CURLOPT_HEADERFUNCTION, new Curl.WriteCallback(){

            @Override
            public int readData(byte[] byArray) {
                if (byArray == null) {
                    return 0;
                }
                Object object = new String(byArray);
                if (!StringUtils.isBlank((String)object)) {
                    int n;
                    Matcher matcher;
                    if (((String[])(object = StringUtils.split((String)object, ":", 2))).length == 2) {
                        String string = object[0].trim();
                        String string2 = object[1].trim();
                        if (map.get(string) != null) {
                            ((List)map.get(string)).add(string2);
                        } else {
                            object = new ArrayList<String>();
                            object.add(string2);
                            map.put(string, object);
                        }
                    } else if (((String[])object).length == 1 && (matcher = CurlHttp.this.STATUS_PATTERN.matcher(object[0])).find() && (n = Integer.valueOf(matcher.group(1)).intValue()) != 100) {
                        atomicInteger.set(n);
                        stringBuffer.append(object[0]);
                    }
                }
                return byArray.length;
            }
        });
    }

    private void setBodyCallback(final OutputStream outputStream) {
        this.curl.curlEasySetopt(CurlOpt.OptFunctionPoint.CURLOPT_WRITEFUNCTION, new Curl.WriteCallback(){

            @Override
            public int readData(byte[] byArray) {
                if (byArray != null && byArray.length == 0) {
                    return 0;
                }
                try {
                    outputStream.write(byArray);
                }
                catch (IOException iOException) {
                    return 0;
                }
                return byArray.length;
            }
        });
    }

    public CurlResponse perform() {
        Object object;
        if (this.url == null) {
            throw new IllegalStateException("url getUrl/postUrl/url not set");
        }
        this.setRequestHeaders();
        CaseInsensitiveMap<String, List<String>> caseInsensitiveMap = new CaseInsensitiveMap<String, List<String>>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AtomicInteger atomicInteger = new AtomicInteger();
        StringBuffer stringBuffer = new StringBuffer();
        this.setHeaderCallback(caseInsensitiveMap, atomicInteger, stringBuffer);
        this.setBodyCallback(byteArrayOutputStream);
        if (!"GET".equals(this.requestMethod)) {
            this.setPostParams();
        } else {
            object = this.getEncodedBodyParams();
            if (!StringUtils.isBlank(object)) {
                this.url = this.url.contains("?") ? (this.url.endsWith("&") ? this.url + object : this.url + "&" + object) : this.url + "?" + object;
            }
        }
        switch (this.requestMethod) {
            case "GET": {
                this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_HTTPGET, 1L);
                break;
            }
            case "POST": {
                this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_POST, 1L);
                break;
            }
            default: {
                this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_CUSTOMREQUEST, this.requestMethod);
            }
        }
        this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_URL, this.url);
        this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_FOLLOWLOCATION, this.followLocation ? 1L : 0L);
        if (this.followLocation) {
            this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_MAXREDIRS, this.maxRedirects);
        }
        this.setProxy();
        try {
            object = this.curl.curlEasyPerform();
            if (object != CurlCode.CURLE_OK) {
                throw new CurlException((CurlCode)((Object)object));
            }
            CurlResponse curlResponse = new CurlResponse(atomicInteger.get(), stringBuffer.toString(), caseInsensitiveMap, byteArrayOutputStream.toByteArray());
            return curlResponse;
        }
        finally {
            this.curl.curlEasyCleanup();
        }
    }

    private void setRequestHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(this.headerMap.size());
        for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
            String string = entry.getValue();
            if (string == null) {
                string = "";
            }
            arrayList.add(entry.getKey() + ": " + string);
        }
        this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_HTTPHEADER, arrayList.toArray(new String[this.headerMap.size()]));
    }

    private boolean isMultipart() {
        return this.asMultipart || this.multiPartList != null && this.multiPartList.size() > 0;
    }

    private void setPostParams() {
        Object object;
        Object object2;
        if (!this.isMultipart()) {
            String string;
            byte[] byArray = this.body;
            if (this.body == null && (string = this.getEncodedBodyParams()) != null) {
                byArray = string.getBytes();
            }
            if (byArray != null) {
                this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_POSTFIELDSIZE, byArray.length);
                this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_POSTFIELDS, byArray);
                return;
            }
            this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_POSTFIELDSIZE, 0L);
            return;
        }
        ArrayList<MultiPart> arrayList = new ArrayList<MultiPart>();
        if (this.multiPartList != null && this.multiPartList.size() > 0) {
            object2 = this.multiPartList.iterator();
            while (object2.hasNext()) {
                object = (MultiPart)object2.next();
                arrayList.add((MultiPart)object);
            }
        }
        if (this.simplePairList != null && this.simplePairList.size() > 0) {
            object2 = this.simplePairList.iterator();
            while (object2.hasNext()) {
                object = (NameValuePair)object2.next();
                arrayList.add(new MultiPart(((NameValuePair)object).getName(), null, null, ((NameValuePair)object).getValue().getBytes()));
            }
        }
        if ((object2 = this.curl.setFormdata(arrayList)) != CurlFormCode.CURL_FORMADD_OK) {
            throw new RuntimeException("set formdata fail: " + object2);
        }
    }

    private String getEncodedBodyParams() {
        if (this.simplePairList != null && this.simplePairList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (NameValuePair nameValuePair : this.simplePairList) {
                if (!bl) {
                    stringBuilder.append("&");
                }
                bl = false;
                try {
                    String string = URLEncoder.encode(nameValuePair.getName(), "UTF-8");
                    String string2 = URLEncoder.encode(nameValuePair.getValue(), "UTF-8");
                    stringBuilder.append(string);
                    stringBuilder.append("=");
                    stringBuilder.append(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private void setProxy() {
        if (this.useSystemProxy && this.proxyHost == null) {
            this.proxyHost = System.getProperty("http.proxyHost");
            String string = System.getProperty("http.proxyPort");
            if (string != null) {
                this.proxyPort = Integer.valueOf(string);
            }
        }
        if (this.proxyHost != null) {
            this.curl.curlEasySetopt(CurlOpt.OptObjectPoint.CURLOPT_PROXY, this.proxyHost);
            this.curl.curlEasySetopt(CurlOpt.OptLong.CURLOPT_PROXYPORT, this.proxyPort);
        }
    }

    private boolean checkCurrentRequestMethod() {
        return this.requestMethod != null && !"".equals(this.requestMethod);
    }

    public static class CurlRequestMethod {
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
        public static final String PATCH = "PATCH";
        public static Set<String> METHOD_SET = new HashSet<String>();

        static {
            METHOD_SET.add(GET);
            METHOD_SET.add(POST);
            METHOD_SET.add(PUT);
            METHOD_SET.add(DELETE);
            METHOD_SET.add(PATCH);
        }
    }
}

