/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.mxcurllib;

import android.util.Log;
import com.moxie.mxcurllib.CurlCode;
import com.moxie.mxcurllib.CurlConstant;
import com.moxie.mxcurllib.CurlException;
import com.moxie.mxcurllib.CurlFormCode;
import com.moxie.mxcurllib.CurlOpt;
import com.moxie.mxcurllib.easy.MultiPart;
import java.util.List;

public class Curl {
    private static final String TAG = Curl.class.getSimpleName();
    private long handle;
    private static boolean INIT = false;
    private static Object CLEANUP;

    private static native String curlGetVersion();

    private static native int curlGlobalInitNative(int var0);

    private static native void curlGlobalCleanupNative();

    private native long curlEasyInitNative();

    private native void curlEasyCleanupNative(long var1);

    private native int curlEasySetoptLongNative(long var1, int var3, long var4);

    private native int curlEasySetoptFunctionNative(long var1, int var3, Callback var4);

    private native int curlEasySetoptObjectPointNative(long var1, int var3, String var4);

    private native int curlEasySetoptObjectPointBytesNative(long var1, int var3, byte[] var4);

    private native int curlEasySetoptObjectPointArrayNative(long var1, int var3, String[] var4);

    private native int setFormdataNative(long var1, MultiPart[] var3);

    private native int curlEasyPerformNavite(long var1);

    public String curlVersion() {
        return Curl.curlGetVersion();
    }

    public Curl() {
        if (!INIT) {
            Curl.curlGlobalInit(CurlConstant.CURL_GLOBAL_DEFAULT);
        }
    }

    public static void curlGlobalInit(int n) {
        if (INIT) {
            return;
        }
        CurlCode curlCode = CurlCode.fromValue(Curl.curlGlobalInitNative(n));
        if (curlCode != CurlCode.CURLE_OK) {
            throw new IllegalStateException("curlGlobalInit fail: " + (Object)((Object)curlCode));
        }
        INIT = true;
    }

    public void curlEasyInit() {
        this.handle = this.curlEasyInitNative();
        if (this.handle == 0L) {
            throw new CurlException("curl init native fail");
        }
    }

    public void curlEasyCleanup() {
        Log.v((String)TAG, (String)("curlEastCleanup: " + this.handle));
        if (this.handle != 0L) {
            this.curlEasyCleanupNative(this.handle);
        }
        this.handle = 0L;
    }

    public CurlCode curlEasySetopt(CurlOpt.OptLong optLong, long l) {
        return CurlCode.fromValue(this.curlEasySetoptLongNative(this.handle, optLong.getValue(), l));
    }

    public CurlCode curlEasySetopt(CurlOpt.OptFunctionPoint optFunctionPoint, WriteCallback writeCallback) {
        return CurlCode.fromValue(this.curlEasySetoptFunctionNative(this.handle, optFunctionPoint.getValue(), writeCallback));
    }

    public CurlCode curlEasySetopt(CurlOpt.OptObjectPoint optObjectPoint, String string) {
        return CurlCode.fromValue(this.curlEasySetoptObjectPointNative(this.handle, optObjectPoint.getValue(), string));
    }

    public CurlCode curlEasySetopt(CurlOpt.OptObjectPoint optObjectPoint, byte[] byArray) {
        return CurlCode.fromValue(this.curlEasySetoptObjectPointBytesNative(this.handle, optObjectPoint.getValue(), byArray));
    }

    public CurlCode curlEasySetopt(CurlOpt.OptObjectPoint optObjectPoint, String[] stringArray) {
        return CurlCode.fromValue(this.curlEasySetoptObjectPointArrayNative(this.handle, optObjectPoint.getValue(), stringArray));
    }

    public CurlFormCode setFormdata(List<MultiPart> list) {
        if (list != null && list.size() > 0) {
            return CurlFormCode.fromValue(this.setFormdataNative(this.handle, list.toArray(new MultiPart[list.size()])));
        }
        return CurlFormCode.CURL_FORMADD_NULL;
    }

    public CurlCode curlEasyPerform() {
        return CurlCode.fromValue(this.curlEasyPerformNavite(this.handle));
    }

    static {
        System.loadLibrary("mxcurl");
        CLEANUP = new Object(){

            protected final void finalize() {
                if (INIT) {
                    Log.i((String)TAG, (String)"curlGlobalCleanup");
                    Curl.curlGlobalCleanupNative();
                }
            }
        };
    }

    public static interface ReadCallback
    extends Callback {
        public int writeData(byte[] var1);
    }

    public static interface WriteCallback
    extends Callback {
        public int readData(byte[] var1);
    }

    public static interface Callback {
    }
}

