/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.moxie.client.commom.GlobalParams;
import com.moxie.client.model.TitleParams;
import com.moxie.client.utils.DisplayUtil;
import com.proguard.annotation.NotProguard;

@NotProguard
public class TitleLayout
extends RelativeLayout {
    private View mTitleLayoutView;
    private RelativeLayout mRelativeLayout_Title_Left;
    private RelativeLayout mRelativeLayout_Title_Right;
    private RelativeLayout mRelativeLayout_Close_Left;
    private TextView mTextTitle;
    private ImageView mImageLeft;
    private ImageView mImageRight;
    private ImageView mImageClose;
    private TextView mLeftTextView;
    private Context mContext;
    private boolean showCloseIcon = true;

    public TitleLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public TitleLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public TitleLayout(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(this.getResources().getIdentifier("moxie_client_common_title", "layout", context.getPackageName()), (ViewGroup)this);
        this.mTextTitle = (TextView)view.findViewById(this.getResources().getIdentifier("TextView_Title", "id", context.getPackageName()));
        this.mImageLeft = (ImageView)view.findViewById(this.getResources().getIdentifier("Moxie_Client_ImageView_Left", "id", context.getPackageName()));
        this.mImageRight = (ImageView)view.findViewById(this.getResources().getIdentifier("Moxie_Client_ImageView_Right", "id", context.getPackageName()));
        this.mImageClose = (ImageView)view.findViewById(this.getResources().getIdentifier("Moxie_Client_ImageView_Close_Left", "id", context.getPackageName()));
        this.mTitleLayoutView = view.findViewById(this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Title", "id", context.getPackageName()));
        this.mRelativeLayout_Title_Left = (RelativeLayout)view.findViewById(this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Title_Left", "id", context.getPackageName()));
        this.mRelativeLayout_Title_Right = (RelativeLayout)view.findViewById(this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Title_Right", "id", context.getPackageName()));
        this.mLeftTextView = (TextView)view.findViewById(this.getResources().getIdentifier("moxie_client_actionbar_left_text", "id", context.getPackageName()));
        this.mRelativeLayout_Close_Left = (RelativeLayout)view.findViewById(this.getResources().getIdentifier("Moxie_Client_RelativeLayout_Close_Left", "id", context.getPackageName()));
    }

    public void setTitle(int n) {
        try {
            this.mTextTitle.setText(n);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setTitle(String string) {
        this.mTextTitle.setText((CharSequence)string);
    }

    public View getLeftTextView() {
        if (this.showCloseIcon) {
            return this.mRelativeLayout_Close_Left;
        }
        return this.mLeftTextView;
    }

    public ImageView getLeftImage() {
        return this.mImageLeft;
    }

    public RelativeLayout getRelativeLayout_Title_Left() {
        return this.mRelativeLayout_Title_Left;
    }

    public RelativeLayout getRelativeLayout_Title_Right() {
        return this.mRelativeLayout_Title_Right;
    }

    public ImageView getRightImage() {
        return this.mImageRight;
    }

    public void setLeftTextVisibility(int n) {
        if (this.showCloseIcon) {
            this.mRelativeLayout_Close_Left.setVisibility(n);
            return;
        }
        this.mLeftTextView.setVisibility(n);
    }

    public void setImageRightVisibility(int n) {
        if (GlobalParams.e().a().getTitleParams() != null) {
            if (n == 0) {
                this.mImageRight.setVisibility(0);
                return;
            }
            this.mImageRight.setVisibility(8);
            return;
        }
        String string = GlobalParams.e().a().getBannerTxtColor();
        if (n == 0) {
            if (string.toLowerCase().equalsIgnoreCase("#ffffff") || string.toLowerCase().equalsIgnoreCase("#ffffffff") || string.toLowerCase().equalsIgnoreCase("#000000") || string.toLowerCase().equalsIgnoreCase("#ff000000")) {
                this.mImageRight.setVisibility(0);
                return;
            }
            this.mImageRight.setVisibility(8);
            return;
        }
        this.mImageRight.setVisibility(8);
    }

    public void initTitleLayout() {
        try {
            Object object = GlobalParams.e().a().getTitleParams();
            if (object != null) {
                if (((TitleParams)object).isImmersedEnable()) {
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    if (Build.VERSION.SDK_INT >= 19) {
                        if (this.mContext instanceof Activity) {
                            ((Activity)this.mContext).getWindow().addFlags(0x4000000);
                        }
                        layoutParams.height = DisplayUtil.a(this.mContext);
                    }
                    this.setLayoutParams(layoutParams);
                }
                int n = ((TitleParams)object).getLeftImgResId();
                int n2 = ((TitleParams)object).getRightImgResId();
                int n3 = ((TitleParams)object).getTitleColor();
                int n4 = ((TitleParams)object).getLeftImgPressedResId();
                int n5 = ((TitleParams)object).getRightImgPressedResId();
                int n6 = ((TitleParams)object).getBackgroundColor();
                int n7 = ((TitleParams)object).getBackgroundDrawable();
                int n8 = ((TitleParams)object).getLeftTextColor();
                int n9 = ((TitleParams)object).getLeftCloseResId();
                int n10 = ((TitleParams)object).getLeftClosePressedResId();
                object = ((TitleParams)object).getLeftText();
                if (n4 != -1 && n != -1) {
                    this.mImageLeft.setBackgroundDrawable((Drawable)this.createStateDrawable(n, n4));
                } else if (n != -1) {
                    this.mImageLeft.setBackgroundDrawable(this.mContext.getResources().getDrawable(n));
                } else {
                    this.mImageLeft.setBackgroundDrawable(this.mContext.getResources().getDrawable(this.mContext.getResources().getIdentifier("moxie_client_banner_back", "drawable", this.mContext.getPackageName())));
                }
                if (n5 != -1 && n2 != -1) {
                    this.mImageRight.setBackgroundDrawable((Drawable)this.createStateDrawable(n2, n5));
                } else if (n2 != -1) {
                    this.mImageRight.setBackgroundDrawable(this.mContext.getResources().getDrawable(n2));
                } else {
                    this.mImageRight.setBackgroundDrawable(this.mContext.getResources().getDrawable(this.mContext.getResources().getIdentifier("moxie_client_banner_refresh", "drawable", this.mContext.getPackageName())));
                }
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    this.mLeftTextView.setText((CharSequence)object);
                    this.showCloseIcon = false;
                }
                if (n8 != -1) {
                    this.mLeftTextView.setTextColor(n8);
                    this.showCloseIcon = false;
                }
                if (n9 != -1 && n10 != -1) {
                    this.mImageClose.setBackgroundDrawable((Drawable)this.createStateDrawable(n9, n10));
                    this.showCloseIcon = true;
                } else if (n9 != -1) {
                    this.mImageClose.setBackgroundDrawable(this.mContext.getResources().getDrawable(n9));
                    this.showCloseIcon = true;
                }
                this.mTextTitle.setTextColor(n3);
                if (n7 != -1) {
                    this.setBackgroundDrawable(this.mContext.getResources().getDrawable(n7));
                    return;
                }
                this.setBackgroundColor(n6);
                return;
            }
            String string = GlobalParams.e().a().getBannerTxtColor();
            int n = Color.parseColor((String)string);
            if (string.toLowerCase().equalsIgnoreCase("#ffffff") || string.toLowerCase().equalsIgnoreCase("#ffffffff") || string.toLowerCase().equalsIgnoreCase("#000000") || string.toLowerCase().equalsIgnoreCase("#ff000000")) {
                if (string.toLowerCase().equalsIgnoreCase("#ffffff") || string.toLowerCase().equalsIgnoreCase("#ffffffff")) {
                    this.mImageLeft.setBackgroundResource(this.mContext.getResources().getIdentifier("moxie_client_banner_back", "drawable", this.mContext.getPackageName()));
                    this.mImageRight.setBackgroundResource(this.mContext.getResources().getIdentifier("moxie_client_banner_refresh", "drawable", this.mContext.getPackageName()));
                } else {
                    this.mImageLeft.setBackgroundResource(this.mContext.getResources().getIdentifier("moxie_client_banner_back_black", "drawable", this.mContext.getPackageName()));
                    this.mImageRight.setBackgroundResource(this.mContext.getResources().getIdentifier("moxie_client_banner_refresh_black", "drawable", this.mContext.getPackageName()));
                }
                this.mImageLeft.setVisibility(0);
                this.mImageRight.setVisibility(0);
            } else {
                this.mImageLeft.setVisibility(8);
                this.mImageRight.setVisibility(8);
            }
            this.mTitleLayoutView.setBackgroundColor(Color.parseColor((String)GlobalParams.e().a().getBannerBgColor()));
            this.mTextTitle.setTextColor(n);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private StateListDrawable createStateDrawable(int n, int n2) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        Drawable drawable = this.getResources().getDrawable(n);
        Drawable drawable2 = this.getResources().getDrawable(n2);
        stateListDrawable.addState(View.PRESSED_ENABLED_STATE_SET, drawable2);
        stateListDrawable.addState(View.ENABLED_STATE_SET, drawable);
        stateListDrawable.addState(View.EMPTY_STATE_SET, drawable);
        return stateListDrawable;
    }
}

