/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.proguard.annotation.NotProguard;

@SuppressLint(value={"SetJavaScriptEnabled"})
@NotProguard
public class CustomWebView
extends WebView {
    public static final String TAG = "CustomWebView";
    private Context context;

    public CustomWebView(Context context) {
        super(context);
        this.context = context.getApplicationContext();
        this.setup();
    }

    public CustomWebView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.context = context.getApplicationContext();
        this.setup();
    }

    public CustomWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context.getApplicationContext();
        this.setup();
    }

    public CustomWebView(Context context, AttributeSet attributeSet, int n, boolean bl) {
        super(context, attributeSet, n, bl);
        this.context = context.getApplicationContext();
        this.setup();
    }

    public void setup() {
        this.setInitialScale(0);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.requestFocusFromTouch();
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        webSettings.setDatabaseEnabled(true);
        String string = this.context.getDir("database", 0).getPath();
        webSettings.setDatabasePath(string);
        webSettings.setDomStorageEnabled(true);
        webSettings.setGeolocationDatabasePath(string);
        webSettings.setGeolocationEnabled(true);
        webSettings.setAppCacheMaxSize(0x800000L);
        string = this.context.getDir("cache", 0).getPath();
        webSettings.setAppCachePath(string);
        webSettings.setAllowFileAccess(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setCacheMode(-1);
        this.setScrollBarStyle(0);
    }
}

