/*
 * Decompiled with CFR 0.152.
 */
package com.moxie.client.dfp.android.client.feature;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.Proxy;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.moxie.client.dfp.android.client.cache.StorageManagerSpec;
import com.moxie.client.dfp.android.client.feature.SimulatorRecognition;
import com.moxie.client.dfp.android.client.feature.process.AndroidAppProcess;
import com.moxie.client.dfp.android.client.feature.process.ProcessManager;
import com.moxie.client.dfp.android.utilities.BSLog;
import com.moxie.client.dfp.android.utilities.Constants;
import com.moxie.client.manager.MoxieSDK;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class FeatureCollection {
    private Context a;
    private String[] b = new String[]{"/system/lib/libc_malloc_debug_qemu.so", "/sys/qemu_trace"};
    private String c = "/system/app/Superuser.apk";

    public FeatureCollection(Context context) {
        this.a = context;
    }

    public final synchronized Map<String, String> a() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.a != null) {
            hashMap.put("basestation", this.D());
            hashMap.put("nearbyBasestation", this.E());
            hashMap.put("phoneNumber", this.F());
            return hashMap;
        }
        return null;
    }

    public final synchronized Map<String, String> b() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.a != null) {
            try {
                hashMap.put("availableMemory", "" + this.k());
                hashMap.put("availableSystem", "" + FeatureCollection.m());
                hashMap.put("availableSD", "" + FeatureCollection.l());
                hashMap.put("appVersion", this.j());
                hashMap.put("baseStation", this.D());
                hashMap.put("battery", this.u());
                hashMap.put("bluetooth", this.e());
                hashMap.put("brightness", "" + this.r());
                hashMap.put("currentWifi", this.x());
                hashMap.put("cellularIP", FeatureCollection.y());
                hashMap.put("custID", MoxieSDK.getInstance().getMxParam().getApiKey());
                FeatureCollection featureCollection = this;
                StorageManagerSpec.a();
                hashMap.put("contactsHash", StorageManagerSpec.a("contact", featureCollection.a));
                hashMap.put("nearbyBaseStation", this.E());
                hashMap.put("resolution", this.v());
                hashMap.put("version", Build.VERSION.RELEASE.replace("=", "").replace("&", ""));
                hashMap.put("platform", Constants.a);
                hashMap.put("packageName", this.i());
                hashMap.put("rooted", this.w());
                hashMap.put("startupTime", "" + FeatureCollection.s());
                hashMap.put("sdkVersion", "4.2.5");
                hashMap.put("totalMemory", "" + FeatureCollection.n());
                hashMap.put("totalSystem", "" + FeatureCollection.p());
                hashMap.put("totalSD", "" + FeatureCollection.o());
                hashMap.put("timeZone", FeatureCollection.q());
                hashMap.put("wifiMacAddress", this.d());
                hashMap.put("wifiList", this.f());
                hashMap.put("IMEI", this.g());
                hashMap.put("IMSI", this.h());
                featureCollection = this;
                StorageManagerSpec.a();
                hashMap.put("UDID", StorageManagerSpec.b(featureCollection.a));
                hashMap.put("isVPN", FeatureCollection.B());
                hashMap.put("isProxy", this.C());
                hashMap.put("timestamp", FeatureCollection.G());
                hashMap.put("allList", this.H());
                hashMap.put("runningList", this.I());
                hashMap.put("account", this.J());
                hashMap.put("sensorList", this.t());
                featureCollection = this;
                StorageManagerSpec.a();
                hashMap.put("coordinates", StorageManagerSpec.a("coordinate", featureCollection.a));
                featureCollection = this;
                StorageManagerSpec.a();
                hashMap.put("musicHash", StorageManagerSpec.a("music", featureCollection.a));
                featureCollection = this;
                StorageManagerSpec.a();
                hashMap.put("photosHash", StorageManagerSpec.a("photo", featureCollection.a));
                hashMap.put("appCache", this.K());
                hashMap.put("userAgent", FeatureCollection.c());
                hashMap.put("existPipe", new File("/dev/qemu_pipe").exists() ? "1" : "0");
                hashMap.put("existQemu", this.z());
                hashMap.put("board", SimulatorRecognition.a());
                hashMap.put("bootloader", SimulatorRecognition.b());
                hashMap.put("brand", SimulatorRecognition.c());
                hashMap.put("cpuABI", SimulatorRecognition.d());
                hashMap.put("device", SimulatorRecognition.e());
                hashMap.put("displayRom", SimulatorRecognition.f());
                hashMap.put("fingerprint", SimulatorRecognition.g());
                hashMap.put("hardware", SimulatorRecognition.h());
                hashMap.put("host", SimulatorRecognition.i());
                hashMap.put("id", SimulatorRecognition.j());
                hashMap.put("manufacturer", SimulatorRecognition.k());
                hashMap.put("model", SimulatorRecognition.l());
                hashMap.put("product", SimulatorRecognition.m());
                hashMap.put("radio", SimulatorRecognition.n());
                hashMap.put("serial", SimulatorRecognition.o());
                hashMap.put("tags", SimulatorRecognition.p());
                hashMap.put("type", SimulatorRecognition.q());
                hashMap.put("user", SimulatorRecognition.r());
                hashMap.put("phoneNumber", this.F());
                hashMap.put("networkCountryIso", SimulatorRecognition.a(this.a));
                hashMap.put("networkType", SimulatorRecognition.b(this.a));
                hashMap.put("networkOperator", SimulatorRecognition.c(this.a));
                hashMap.put("phoneType", SimulatorRecognition.d(this.a));
                hashMap.put("simCountryIso", SimulatorRecognition.e(this.a));
                hashMap.put("simSerialNumber", SimulatorRecognition.f(this.a));
                hashMap.put("voiceMailNumber", SimulatorRecognition.g(this.a));
                hashMap.put("IOPorts", SimulatorRecognition.s());
                hashMap.put("misc", SimulatorRecognition.t());
                hashMap.put("uevent", SimulatorRecognition.u());
                hashMap.put("syncookies", SimulatorRecognition.v());
                hashMap.put("ppp", SimulatorRecognition.w());
                hashMap.put("switch", SimulatorRecognition.x());
                hashMap.put("stat", SimulatorRecognition.y());
                hashMap.put("adb", SimulatorRecognition.z());
                hashMap.put("parameters", SimulatorRecognition.A());
                hashMap.put("cpufreq", SimulatorRecognition.B());
            }
            catch (Throwable throwable) {
                BSLog.c("FeatureCollection Collect Error");
            }
            return hashMap;
        }
        BSLog.c("FeatureCollection Input Context is null.");
        return null;
    }

    private static String c() {
        try {
            return System.getProperty("http.agent").replace("=", "").replace("&", "");
        }
        catch (Throwable throwable) {
            BSLog.c("userAgent collect error");
            return "";
        }
    }

    private String d() {
        if (Build.VERSION.SDK_INT == 23) {
            Process process = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                process = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address");
                inputStreamReader = new InputStreamReader(process.getInputStream(), "utf-8");
                bufferedReader = new LineNumberReader(inputStreamReader);
                String string = ((LineNumberReader)bufferedReader).readLine();
                if (string != null && string.contains(":") && string.length() == 17) {
                    bufferedReader.close();
                    inputStreamReader.close();
                    process.destroy();
                    return string.replace("=", "").replace("&", "");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (process != null) {
                        process.destroy();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Throwable throwable2) {
                    BSLog.d("MAC1 Collect Error");
                }
            }
        } else if (Build.VERSION.SDK_INT < 23) {
            try {
                if (this.a != null) {
                    return ((WifiManager)this.a.getApplicationContext().getSystemService("wifi")).getConnectionInfo().getMacAddress().replace("=", "").replace("&", "");
                }
            }
            catch (Throwable throwable) {
                BSLog.d("MAC2 Collect Error");
            }
        } else if (Build.VERSION.SDK_INT > 23) {
            try {
                Object object = Collections.list(NetworkInterface.getNetworkInterfaces()).iterator();
                while (object.hasNext()) {
                    NetworkInterface networkInterface = (NetworkInterface)object.next();
                    if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                    byte[] byArray = networkInterface.getHardwareAddress();
                    if (byArray == null) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    object = byArray;
                    int n = byArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = object[i];
                        stringBuilder.append(String.format("%02X:", (byte)object2));
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                    return stringBuilder.toString();
                }
            }
            catch (Throwable throwable) {
                BSLog.c("MAC3 Collect Error");
            }
        }
        return "";
    }

    private String e() {
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                String string = Settings.Secure.getString((ContentResolver)this.a.getContentResolver(), (String)"bluetooth_address");
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            } else {
                Object object = BluetoothAdapter.getDefaultAdapter();
                if (object != null && object.isEnabled() && (object = object.getAddress()) != null && !((String)object).isEmpty()) {
                    return object;
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Blue Collect Error");
        }
        return "";
    }

    private String f() {
        try {
            if (this.a != null) {
                Object object = (WifiManager)this.a.getApplicationContext().getSystemService("wifi");
                object.startScan();
                StringBuffer stringBuffer = new StringBuffer("");
                object = object.getScanResults();
                if (object != null && object.size() > 0) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        ScanResult scanResult = (ScanResult)object.next();
                        stringBuffer.append(scanResult.SSID);
                        stringBuffer.append(",");
                        stringBuffer.append(scanResult.BSSID);
                        stringBuffer.append(",");
                        stringBuffer.append(scanResult.capabilities.replace("[", "").replace("]", ""));
                        stringBuffer.append(",");
                    }
                    return (stringBuffer.substring(0, stringBuffer.length() - 1) + "]").replace("=", "").replace("&", "");
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("WIFI-LIST collect Error");
        }
        return "";
    }

    private String g() {
        if (this.a != null) {
            try {
                Object object = (TelephonyManager)this.a.getSystemService("phone");
                if (object != null && (object = object.getDeviceId()) != null && ((String)object).length() > 0 && !((String)object).equals("") && !((String)object).matches("0+")) {
                    if (((String)object).length() == 15) {
                        return ((String)object).replace("=", "").replace("&", "");
                    }
                    if (((String)object).length() == 14 && ((String)object).matches("[0-9]+")) {
                        return FeatureCollection.a((String)object).replace("=", "").replace("&", "");
                    }
                    if (((String)object).length() == 16 && ((String)object).matches("[0-9]+")) {
                        return FeatureCollection.a(((String)object).substring(0, 14)).replace("=", "").replace("&", "");
                    }
                    return ((String)object).replace("=", "").replace("&", "");
                }
            }
            catch (Throwable throwable) {
                BSLog.c("Imei Collect Error");
            }
        }
        return "";
    }

    private String h() {
        String string = null;
        if (this.a != null) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)this.a.getSystemService("phone");
                if (telephonyManager != null) {
                    string = telephonyManager.getSubscriberId().replace("=", "").replace("&", "");
                }
            }
            catch (Throwable throwable) {
                BSLog.c("Imsi Collect Error");
            }
        }
        return string;
    }

    private String i() {
        try {
            if (this.a != null) {
                return this.a.getPackageName().replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("PackageName Collect Error");
        }
        return "";
    }

    private String j() {
        if (this.a != null) {
            try {
                PackageInfo packageInfo = this.a.getPackageManager().getPackageInfo(this.a.getPackageName(), 0);
                if (packageInfo.versionName != null) {
                    return packageInfo.versionName.replace("=", "").replace("&", "");
                }
            }
            catch (Throwable throwable) {
                BSLog.c("AppVersion Collect Error");
            }
        }
        return "";
    }

    private long k() {
        try {
            if (this.a != null) {
                ActivityManager activityManager = (ActivityManager)this.a.getSystemService("activity");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memoryInfo);
                return memoryInfo.availMem;
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Available Memory Collect Error");
        }
        return 0L;
    }

    private static long l() {
        try {
            Object object;
            if (Build.VERSION.SDK_INT <= 23 && (object = System.getenv("SECONDARY_STORAGE")) != null) {
                object = new File((String)object);
                object = new StatFs(((File)object).getPath());
                return (long)object.getBlockSize() * (long)object.getAvailableBlocks();
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Available SD Card Collect Error");
        }
        return 0L;
    }

    private static long m() {
        try {
            File file = Environment.getDataDirectory();
            file = new StatFs(file.getPath());
            long l = file.getBlockSize();
            return (long)file.getAvailableBlocks() * l;
        }
        catch (Throwable throwable) {
            BSLog.c("Available System Collect Error");
            return 0L;
        }
    }

    private static long n() {
        Object object = "/proc/meminfo";
        try {
            object = new FileReader((String)object);
            object = new BufferedReader((Reader)object, 8192);
            long l = Long.valueOf(((BufferedReader)object).readLine().split("\\s+")[1]).intValue();
            ((BufferedReader)object).close();
            return l * 1024L;
        }
        catch (Throwable throwable) {
            BSLog.c("Total Memory Collect Error");
            return 0L;
        }
    }

    private static long o() {
        try {
            Object object;
            if (Build.VERSION.SDK_INT <= 23 && (object = System.getenv("SECONDARY_STORAGE")) != null) {
                object = new File((String)object);
                object = new StatFs(((File)object).getPath());
                return (long)object.getBlockSize() * (long)object.getBlockCount();
            }
        }
        catch (Throwable throwable) {
            BSLog.c("TOTAL SD Card Collect Error");
        }
        return 0L;
    }

    private static long p() {
        try {
            File file = Environment.getDataDirectory();
            file = new StatFs(file.getPath());
            long l = file.getBlockSize();
            return (long)file.getBlockCount() * l;
        }
        catch (Throwable throwable) {
            BSLog.c("TOTAL System Collect Error");
            return 0L;
        }
    }

    private static String q() {
        try {
            TimeZone timeZone = TimeZone.getDefault();
            return ("[" + timeZone.getDisplayName(false, 0) + "," + timeZone.getID() + "]").replace("=", "").replace("&", "");
        }
        catch (Throwable throwable) {
            BSLog.c("Timezone Collect Error");
            return "";
        }
    }

    private int r() {
        try {
            if (this.a != null) {
                return Settings.System.getInt((ContentResolver)this.a.getContentResolver(), (String)"screen_brightness");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Screen Brightness Collect Error");
        }
        return 0;
    }

    private static long s() {
        try {
            return (System.currentTimeMillis() - SystemClock.elapsedRealtime()) / 1000L;
        }
        catch (Throwable throwable) {
            BSLog.c("LastStartUpTime Collect Error");
            return 0L;
        }
    }

    private String t() {
        try {
            Object object;
            if (this.a != null && (object = (SensorManager)this.a.getSystemService("sensor")) != null) {
                object = object.getSensorList(-1);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[");
                if (object != null && object.size() > 0) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Sensor sensor = (Sensor)object.next();
                        stringBuilder.append(sensor.getType() + ",");
                        stringBuilder.append(sensor.getName() + ",");
                        stringBuilder.append(sensor.getVersion() + ",");
                        stringBuilder.append(sensor.getVendor() + ",");
                        stringBuilder.append(sensor.getMaximumRange() + ",");
                        stringBuilder.append(sensor.getMinDelay() + ",");
                        stringBuilder.append(sensor.getPower() + ",");
                        stringBuilder.append("" + sensor.getResolution());
                        stringBuilder.append(",");
                    }
                    return (stringBuilder.toString().substring(0, stringBuilder.length() - 1) + "]").replace("&", "").replace("=", "");
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Need sensor permission");
        }
        return "";
    }

    private String u() {
        try {
            if (this.a != null) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                if ((intentFilter = this.a.registerReceiver(null, intentFilter)) != null) {
                    int n = intentFilter.getIntExtra("status", 0);
                    int n2 = intentFilter.getIntExtra("level", 0);
                    return ("[" + n + "," + n2 + "]").replace("=", "").replace("&", "");
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Battery Collect Error");
        }
        return "";
    }

    private String v() {
        try {
            if (this.a != null) {
                DisplayMetrics displayMetrics = this.a.getResources().getDisplayMetrics();
                return ("[" + displayMetrics.density + "," + displayMetrics.widthPixels + "," + displayMetrics.heightPixels + "," + displayMetrics.scaledDensity + "," + displayMetrics.xdpi + "," + displayMetrics.ydpi + "]").replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Resolution Collect Error");
        }
        return "";
    }

    private String w() {
        block4: {
            try {
                if (this.a == null) break block4;
                if (!(new File("/system/bin/su").exists() ? true : new File("/system/xbin/su").exists())) {
                    FeatureCollection featureCollection = this;
                    if (!new File(featureCollection.c).exists() && !this.A()) break block4;
                }
                return "1";
            }
            catch (Throwable throwable) {
                BSLog.c("isRoot Collect Error");
            }
        }
        return "0";
    }

    private String x() {
        try {
            Object object;
            if (this.a != null && (object = (WifiManager)this.a.getApplicationContext().getSystemService("wifi")) != null) {
                object = object.getConnectionInfo();
                String string = object.getBSSID().replace("\"", "");
                object = object.getSSID();
                return ("[" + (String)object + "," + string + "]").replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Wi-Fi Collect Error");
        }
        return "";
    }

    private static String y() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().replace("=", "").replace("&", "");
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Cellular Collect Error");
        }
        return "";
    }

    private static String a(String string) {
        if (string.length() == 14) {
            char[] cArray = string.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                int n2;
                int n3 = Integer.parseInt(String.valueOf(cArray[i]));
                n2 = (n2 = Integer.parseInt(String.valueOf(cArray[++i])) * 2) < 10 ? n2 : n2 - 9;
                n += n3 + n2;
            }
            n = (n %= 10) == 0 ? 0 : 10 - n;
            return string + n;
        }
        return "";
    }

    private String z() {
        for (int i = 0; i < this.b.length; ++i) {
            String string = this.b[i];
            if (!new File(string).exists()) continue;
            return "1";
        }
        return "0";
    }

    private boolean A() {
        int n;
        Object object = this.a.getPackageManager().getInstalledPackages(8192);
        ArrayList<PackageInfo> arrayList = new ArrayList<PackageInfo>();
        for (n = 0; n < object.size(); ++n) {
            PackageInfo packageInfo = (PackageInfo)object.get(n);
            if ((packageInfo.applicationInfo.flags & 1) != 0) continue;
            arrayList.add(packageInfo);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = ((PackageInfo)arrayList.get((int)n)).packageName;
            if (!((String)object).equals("com.mgyun.shua.su") && !((String)object).equals("com.shuame.rootgenius") && !((String)object).equals("com.wangzhuo.onekeyrom") && !((String)object).equals("pj.ishuaji") && !((String)object).equals("com.wmshua.phone") && !((String)object).equals("com.shuame.mobile") && !((String)object).equals("com.shuame.mobile") && !((String)object).equals("eu.chainfire.supersu")) continue;
            return true;
        }
        return false;
    }

    private static String B() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                for (NetworkInterface networkInterface : Collections.list(enumeration)) {
                    if (!networkInterface.isUp() || networkInterface.getInterfaceAddresses().size() == 0 || !"tun0".equals(networkInterface.getName()) && !"ppp0".equals(networkInterface.getName())) continue;
                    return "1";
                }
            }
        }
        catch (Throwable throwable) {
            BSLog.c("VPN collect error");
        }
        return "0";
    }

    private String C() {
        try {
            int n;
            String string;
            if (Build.VERSION.SDK_INT >= 14) {
                string = System.getProperty("http.proxyHost");
                String string2 = System.getProperty("http.proxyPort");
                n = Integer.parseInt(string2 != null ? string2 : "-1");
            } else {
                string = Proxy.getHost((Context)this.a);
                n = Proxy.getPort((Context)this.a);
            }
            if (string != null && n != -1) {
                return "1";
            }
            return "0";
        }
        catch (Throwable throwable) {
            BSLog.c("Proxy collect error");
            return "0";
        }
    }

    private String D() {
        StorageManagerSpec.a();
        String string = StorageManagerSpec.b("base", this.a);
        if (string == null) {
            string = "";
        }
        return string.replace("=", "").replace("&", "");
    }

    private String E() {
        StorageManagerSpec.a();
        String string = StorageManagerSpec.b("nearly", this.a);
        if (string == null) {
            string = "";
        }
        return string.replace("=", "").replace("&", "");
    }

    private String F() {
        try {
            if (this.a != null) {
                return ((TelephonyManager)this.a.getSystemService("phone")).getLine1Number().replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("phoneNumber Collect Error");
        }
        return "";
    }

    private static String G() {
        try {
            return "" + System.currentTimeMillis();
        }
        catch (Throwable throwable) {
            BSLog.c("currentTime Collect Error");
            return "";
        }
    }

    private String H() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            List list = this.a.getPackageManager().getInstalledPackages(0);
            for (int i = 0; i < list.size(); ++i) {
                PackageInfo packageInfo = (PackageInfo)list.get(i);
                String string = packageInfo.packageName;
                if ((packageInfo.applicationInfo.flags & 1) != 0) continue;
                stringBuilder.append(string).append(",");
            }
            if (!stringBuilder.toString().equals("[")) {
                return (stringBuilder.toString().substring(0, stringBuilder.length() - 1) + "]").replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("AllPackages Collect Error");
        }
        return "";
    }

    private String I() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        try {
            if (Build.VERSION.SDK_INT < 21) {
                HashSet<String> hashSet = new HashSet<String>();
                List list = ((ActivityManager)this.a.getSystemService("activity")).getRunningAppProcesses();
                for (int i = 0; i < list.size(); ++i) {
                    int n = ((ActivityManager.RunningAppProcessInfo)list.get((int)i)).uid;
                    if (n <= 10000) continue;
                    String string = this.a.getPackageManager().getNameForUid(n);
                    if (string != null && string.contains(":")) {
                        string = string.split(":")[0];
                        hashSet.add(string);
                        continue;
                    }
                    hashSet.add(string);
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)iterator.next()).append(",");
                }
            } else if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 24) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator<AndroidAppProcess> iterator = ProcessManager.a().iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next().b;
                    if (n <= 10000) continue;
                    String string = this.a.getPackageManager().getNameForUid(n);
                    if (string != null && string.contains(":")) {
                        string = string.split(":")[0];
                        hashSet.add(string);
                        continue;
                    }
                    hashSet.add(string);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)((Object)iterator.next())).append(",");
                }
            }
            if (!stringBuilder.toString().equals("[")) {
                return (stringBuilder.toString().substring(0, stringBuilder.length() - 1) + "]").replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("RunningApp Exception");
        }
        return "";
    }

    private static long a(File fileArray) {
        long l = 0L;
        try {
            fileArray = fileArray.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    l += FeatureCollection.a(fileArray[i]);
                    continue;
                }
                l += fileArray[i].length();
            }
        }
        catch (Throwable throwable) {
            BSLog.c(throwable.getMessage());
        }
        return l;
    }

    private String J() {
        try {
            StringBuilder stringBuilder = new StringBuilder("");
            stringBuilder.append("[");
            Account[] accountArray = AccountManager.get((Context)this.a).getAccounts();
            for (int i = 0; i < accountArray.length; ++i) {
                String string = accountArray[i].name;
                stringBuilder.append(string).append(",");
            }
            if (!stringBuilder.toString().equals("[")) {
                return (stringBuilder.toString().substring(0, stringBuilder.length() - 1) + "]").replace("=", "").replace("&", "");
            }
        }
        catch (Throwable throwable) {
            BSLog.c("Collect Account Error");
        }
        return "";
    }

    private String K() {
        try {
            long l = FeatureCollection.a(this.a.getCacheDir()) + FeatureCollection.a(this.a.getFilesDir()) + FeatureCollection.a(new File("/data/data/" + this.i() + "/shared_prefs"));
            if (Environment.getExternalStorageState().equals("mounted")) {
                l += FeatureCollection.a(this.a.getCacheDir());
            }
            return String.valueOf(l);
        }
        catch (Throwable throwable) {
            BSLog.c("apkCacheSize collect error");
            return "";
        }
    }
}

