/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.util.Log;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.LabelInfo;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadPagingLayer;
import com.mousebird.maply.ScreenLabel;
import com.mousebird.maply.VectorInfo;
import com.mousebird.maply.VectorObject;
import java.util.ArrayList;

public class TestQuadPager
implements QuadPagingLayer.PagingInterface {
    int minZoom = 0;
    int maxZoom = 16;

    public TestQuadPager(int inMinZoom, int inMaxZoom) {
        this.minZoom = inMinZoom;
        this.maxZoom = inMaxZoom;
    }

    @Override
    public int minZoom() {
        return this.minZoom;
    }

    @Override
    public int maxZoom() {
        return this.maxZoom;
    }

    @Override
    public void startFetchForTile(final QuadPagingLayer layer, final MaplyTileID tileID) {
        layer.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
                Mbr mbr = layer.geoBoundsForTile(tileID);
                VectorObject vecObj = new VectorObject();
                Point2d[] pts = new Point2d[4];
                Point2d span = mbr.span();
                pts[0] = new Point2d(mbr.ll.getX() + span.getX() / 10.0, mbr.ll.getY() + span.getY() / 10.0);
                pts[1] = new Point2d(mbr.ur.getX() - span.getX() / 10.0, mbr.ll.getY() + span.getY() / 10.0);
                pts[2] = new Point2d(mbr.ur.getX() - span.getX() / 10.0, mbr.ur.getY() - span.getY() / 10.0);
                pts[3] = new Point2d(mbr.ll.getX() + span.getX() / 10.0, mbr.ur.getY() - span.getY() / 10.0);
                vecObj.addAreal(pts);
                VectorInfo vecInfo = new VectorInfo();
                vecInfo.disposeAfterUse = true;
                vecInfo.setColor(1.0f, 0.0f, 0.0f, 1.0f);
                vecInfo.setEnable(false);
                ComponentObject compObj = layer.maplyControl.addVector(vecObj, vecInfo, MaplyBaseController.ThreadMode.ThreadAny);
                compObjs.add(compObj);
                ScreenLabel label = new ScreenLabel();
                label.loc = new Point2d((mbr.ll.getX() + mbr.ur.getX()) / 2.0, (mbr.ll.getY() + mbr.ur.getY()) / 2.0);
                label.text = tileID.level + ": (" + tileID.x + "," + tileID.y + ")";
                LabelInfo labelInfo = new LabelInfo();
                labelInfo.setEnable(false);
                compObj = layer.maplyControl.addScreenLabel(label, labelInfo, MaplyBaseController.ThreadMode.ThreadAny);
                compObjs.add(compObj);
                layer.addData(compObjs, tileID);
                Log.d((String)"Maply", (String)("Loaded tile " + tileID.level + ": (" + tileID.x + "," + tileID.y + ")"));
                layer.tileDidLoad(tileID);
            }
        }, true);
    }

    @Override
    public void tileDidUnload(MaplyTileID tileID) {
    }
}

