/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.Light;
import com.mousebird.maply.Point3d;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class Sun {
    private long nativeHandle;

    public Sun() {
        this.initialise();
        Date date = new Date();
        this.setDate(date);
    }

    public Sun(Date date) {
        this.initialise();
        this.setDate(date);
    }

    public Light makeLight() {
        Light light = new Light();
        Point3d dir = this.getDirection();
        light.setPos(new Point3d(dir.getX(), dir.getZ(), dir.getY()));
        light.setAmbient(0.1f, 0.1f, 0.1f, 1.0f);
        light.setDiffuse(0.8f, 0.8f, 0.8f, 1.0f);
        light.setViewDependent(true);
        return light;
    }

    public void setDate(Date date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeZone(new SimpleTimeZone(2, "UTC"));
        cal.setTime(date);
        double year = cal.get(1);
        double month = cal.get(2) + 1;
        double day = cal.get(5);
        double hour = cal.get(11);
        double min = cal.get(12);
        double sec = cal.get(13);
        this.setTime((double)date.getTime() / 1000.0, year, month, day, hour, min, sec);
    }

    native void setTime(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    public native Point3d getDirection();

    public native float[] asPosition();

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        Sun.nativeInit();
    }
}

