/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.QuadImageTileLayerInterface;
import com.mousebird.maply.RemoteTileInfo;
import com.mousebird.maply.SphericalMercatorCoordSystem;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;

public class RemoteTileSource
implements QuadImageTileLayer.TileSource {
    RemoteTileInfo tileInfo = null;
    public CoordSystem coordSys = new SphericalMercatorCoordSystem();
    OkHttpClient client = new OkHttpClient();
    boolean hasPremultiplyOption = false;
    public boolean debugOutput = false;
    public TileSourceDelegate delegate = null;
    File cacheDir = null;

    public RemoteTileSource(RemoteTileInfo inTileInfo) {
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            Class<?> theClass = opts.getClass();
            Field field = theClass.getField("inPremultiplied");
            if (field != null) {
                this.hasPremultiplyOption = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tileInfo = inTileInfo;
    }

    public void setCacheDir(File inCacheDir) {
        this.cacheDir = inCacheDir;
    }

    @Override
    public int minZoom() {
        return this.tileInfo.minZoom;
    }

    @Override
    public int maxZoom() {
        return this.tileInfo.maxZoom;
    }

    @Override
    public int pixelsPerSide() {
        return this.tileInfo.pixelsPerSide;
    }

    @Override
    public void startFetchForTile(QuadImageTileLayerInterface layer, MaplyTileID tileID, int frame) {
        if (this.debugOutput) {
            Log.d((String)"Maply", (String)("Starting fetch for tile " + tileID.level + ": (" + tileID.x + "," + tileID.y + ")"));
        }
        int maxY = 1 << tileID.level;
        int remoteY = maxY - tileID.y - 1;
        URL tileURL = this.tileInfo.buildURL(tileID.x, remoteY, tileID.level);
        String cacheFile = null;
        if (this.cacheDir != null) {
            cacheFile = this.cacheDir.getAbsolutePath() + this.tileInfo.buildCacheName(tileID.x, tileID.y, tileID.level);
        }
        ConnectionTask task = new ConnectionTask(layer, this, tileID, tileURL, cacheFile);
        task.fetchTile();
    }

    private class ConnectionTask
    implements Callback {
        RemoteTileSource tileSource = null;
        QuadImageTileLayerInterface layer = null;
        MaplyTileID tileID = null;
        URL url = null;
        String locFile = null;
        Call call;
        Bitmap bm = null;
        File cacheFile = null;
        boolean isCanceled = false;

        ConnectionTask(QuadImageTileLayerInterface inLayer, RemoteTileSource inTileSource, MaplyTileID inTileID, URL inURL, String inFile) {
            this.tileSource = inTileSource;
            this.layer = inLayer;
            this.tileID = inTileID;
            this.locFile = inFile;
            this.url = inURL;
        }

        protected void fetchTile() {
            block9: {
                try {
                    if (this.locFile != null) {
                        this.cacheFile = new File(this.locFile);
                        if (this.cacheFile.exists()) {
                            BitmapFactory.Options options = new BitmapFactory.Options();
                            if (RemoteTileSource.this.hasPremultiplyOption) {
                                options.inPremultiplied = false;
                            }
                            BufferedInputStream aBufferedInputStream = new BufferedInputStream(new FileInputStream(this.cacheFile));
                            this.bm = BitmapFactory.decodeStream((InputStream)aBufferedInputStream, null, (BitmapFactory.Options)options);
                            if (RemoteTileSource.this.debugOutput) {
                                if (this.bm != null) {
                                    Log.d((String)"Maply", (String)("Read cached file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " Bitmap = (" + this.bm.getWidth() + "," + this.bm.getHeight() + ")"));
                                } else {
                                    Log.d((String)"Maply", (String)("Read cached file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " Bitmap = is null"));
                                }
                            }
                        }
                    }
                    if (this.bm != null) {
                        this.reportTile();
                        return;
                    }
                    Request request = RemoteTileSource.this.tileInfo.buildRequest(this.url);
                    this.call = RemoteTileSource.this.client.newCall(request);
                    this.call.enqueue((Callback)this);
                }
                catch (Exception e) {
                    if (!RemoteTileSource.this.debugOutput) break block9;
                    Log.e((String)"Maply", (String)("Exception while trying to fetch the tile: " + e.toString()));
                }
            }
        }

        public void onFailure(Request request, IOException e) {
            Log.e((String)"Maply", (String)("Failed to fetch remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
        }

        public void onResponse(Response response) {
            if (this.isCanceled) {
                return;
            }
            byte[] rawImage = null;
            try {
                rawImage = response.body().bytes();
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inScaled = false;
                if (RemoteTileSource.this.hasPremultiplyOption) {
                    options.inPremultiplied = false;
                }
                this.bm = BitmapFactory.decodeByteArray((byte[])rawImage, (int)0, (int)rawImage.length, (BitmapFactory.Options)options);
                if (this.bm == null) {
                    this.bm = BitmapFactory.decodeByteArray((byte[])rawImage, (int)0, (int)rawImage.length, null);
                    if (this.bm != null && RemoteTileSource.this.debugOutput) {
                        Log.d((String)"Maply", (String)"Image decode succeeded second time.");
                    }
                }
                if (this.cacheFile != null && rawImage != null && this.bm != null) {
                    FileOutputStream fOut = new FileOutputStream(this.cacheFile);
                    ((OutputStream)fOut).write(rawImage);
                    ((OutputStream)fOut).close();
                }
                if (RemoteTileSource.this.debugOutput) {
                    if (this.bm != null) {
                        Log.d((String)"Maply", (String)("Fetched remote file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " Bitmap = (" + this.bm.getWidth() + "," + this.bm.getHeight() + ")"));
                    } else {
                        Log.d((String)"Maply", (String)("Fetched remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " but did not decode. length = " + rawImage.length));
                        Log.e((String)"Maply", (String)("Response for failed image decode: " + response.toString()));
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"Maply", (String)("Fetched remote file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " because: " + e.toString()));
            }
            this.reportTile();
        }

        protected void reportTile() {
            this.layer.getLayerThread().addTask(new Runnable(){

                @Override
                public void run() {
                    if (ConnectionTask.this.bm != null) {
                        MaplyImageTile imageTile = new MaplyImageTile(ConnectionTask.this.bm);
                        if (ConnectionTask.this.tileSource.delegate != null) {
                            ConnectionTask.this.tileSource.delegate.tileDidLoad(ConnectionTask.this.tileSource, ConnectionTask.this.tileID, -1);
                        }
                        ConnectionTask.this.layer.loadedTile(ConnectionTask.this.tileID, -1, imageTile);
                    } else {
                        if (ConnectionTask.this.tileSource.delegate != null) {
                            ConnectionTask.this.tileSource.delegate.tileDidNotLoad(ConnectionTask.this.tileSource, ConnectionTask.this.tileID, -1);
                        }
                        ConnectionTask.this.layer.loadedTile(ConnectionTask.this.tileID, -1, null);
                    }
                }
            }, true);
        }

        protected void cancel() {
            this.isCanceled = true;
            if (this.call != null) {
                this.call.cancel();
            }
        }
    }

    public static interface TileSourceDelegate {
        public void tileDidLoad(Object var1, MaplyTileID var2, int var3);

        public void tileDidNotLoad(Object var1, MaplyTileID var2, int var3);
    }
}

