/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.GlobeView;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadTrackerPointReturn;

public class QuadTracker {
    private long nativeHandle;

    private QuadTracker() {
    }

    public QuadTracker(GlobeController globeController, CoordSystem coordSystem, Point2d ll, Point2d ur, int minLevel) {
        this.initialise(globeController.globeView, globeController.renderWrapper.maplyRender, globeController.coordAdapter, coordSystem, ll, ur, minLevel);
    }

    public void finalize() {
        this.dispose();
    }

    public void queryTiles(QuadTrackerPointReturn ptReturn) {
        this.queryTilesNative(ptReturn.numPts, ptReturn.screenLocs, ptReturn.tileIDs, ptReturn.coordLocs, ptReturn.tileLocs);
    }

    native void queryTilesNative(int var1, double[] var2, int[] var3, double[] var4, double[] var5);

    public void addTile(MaplyTileID tileID) {
        this.addTile(tileID.x, tileID.y, tileID.level);
    }

    native void addTile(int var1, int var2, int var3);

    public void removeTile(MaplyTileID tileID) {
        this.removeTile(tileID.x, tileID.y, tileID.level);
    }

    native void removeTile(int var1, int var2, int var3);

    public native int getMinLevel();

    private static native void nativeInit();

    native void initialise(GlobeView var1, MaplyRenderer var2, CoordSystemDisplayAdapter var3, CoordSystem var4, Point2d var5, Point2d var6, int var7);

    native void dispose();

    static {
        QuadTracker.nativeInit();
    }
}

