/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.Layer;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.QuadImageTileLayerInterface;
import com.mousebird.maply.Scene;
import com.mousebird.maply.ViewState;

public class QuadImageOfflineLayer
extends Layer
implements LayerThread.ViewWatcherInterface,
QuadImageTileLayerInterface {
    boolean valid = false;
    public MaplyBaseController maplyControl = null;
    public CoordSystem coordSys = null;
    QuadImageTileLayer.TileSource tileSource = null;
    boolean flipY = true;
    RenderedImageDelegate imageDelegate = null;
    Handler evalStepHandle = null;
    Runnable evalStepRun = null;
    float renderPeriod = 0.0f;
    private long nativeHandle;

    private QuadImageOfflineLayer() {
    }

    public QuadImageOfflineLayer(MaplyBaseController inMaplyControl, CoordSystem inCoordSys, QuadImageTileLayer.TileSource inTileSource) {
        this.maplyControl = inMaplyControl;
        this.coordSys = inCoordSys;
        this.tileSource = inTileSource;
        ChangeSet changes = new ChangeSet();
        this.initialise(this.coordSys, changes);
        this.maplyControl.getLayerThread().addChanges(changes);
        this.setSimultaneousFetches(8);
    }

    public void setImageDelegate(RenderedImageDelegate inImageDelegate) {
        this.imageDelegate = inImageDelegate;
    }

    public CoordSystem getCoordSystem() {
        return this.coordSys;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public float getMinTime() {
        return 0.1f;
    }

    @Override
    public float getMaxLagTime() {
        return 4.0f;
    }

    @Override
    public void startLayer(LayerThread layerThread) {
        super.startLayer(layerThread);
        layerThread.addWatcher(this);
        Point2d ll = new Point2d(this.coordSys.ll.getX(), this.coordSys.ll.getY());
        Point2d ur = new Point2d(this.coordSys.ur.getX(), this.coordSys.ur.getY());
        this.nativeStartLayer(layerThread.scene, layerThread.renderer, ll, ur, this.tileSource.minZoom(), this.tileSource.maxZoom(), this.tileSource.pixelsPerSide());
        this.scheduleEvalStep();
        if ((double)this.renderPeriod > 0.0) {
            this.imageRenderPeriodic();
        }
        this.valid = true;
    }

    @Override
    public void shutdown() {
        this.valid = false;
        if (this.layerThread != null) {
            this.layerThread.removeWatcher(this);
        }
        this.cancelEvalStep();
        ChangeSet changes = new ChangeSet();
        this.nativeShutdown(changes);
        if (this.layerThread != null && this.layerThread.scene != null) {
            changes.process(this.layerThread.scene);
        }
        super.shutdown();
    }

    @Override
    public void viewUpdated(ViewState viewState) {
        if (!this.valid) {
            return;
        }
        this.nativeViewUpdate(viewState);
        this.scheduleEvalStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEvalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageOfflineLayer quadImageOfflineLayer = this;
        synchronized (quadImageOfflineLayer) {
            if (this.evalStepHandle != null) {
                this.evalStepHandle.removeCallbacks(this.evalStepRun);
                this.evalStepHandle = null;
                this.evalStepRun = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEvalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageOfflineLayer quadImageOfflineLayer = this;
        synchronized (quadImageOfflineLayer) {
            if (this.evalStepHandle == null) {
                this.evalStepRun = new Runnable(){

                    @Override
                    public void run() {
                        QuadImageOfflineLayer.this.evalStep();
                    }
                };
                this.evalStepHandle = this.layerThread.addTask(this.evalStepRun, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageOfflineLayer quadImageOfflineLayer = this;
        synchronized (quadImageOfflineLayer) {
            this.evalStepHandle = null;
            this.evalStepRun = null;
        }
        ChangeSet changes = new ChangeSet();
        boolean didSomething = this.nativeEvalStep(changes);
        this.layerThread.addChanges(changes);
        if (didSomething) {
            this.scheduleEvalStep();
        }
    }

    public void refresh() {
        if (!this.valid) {
            return;
        }
        if (Looper.myLooper() != this.layerThread.getLooper()) {
            Handler handle = new Handler();
            handle.post(new Runnable(){

                @Override
                public void run() {
                    QuadImageOfflineLayer.this.refresh();
                }
            });
            return;
        }
        ChangeSet changes = new ChangeSet();
        boolean doEvalStep = this.nativeRefresh(changes);
        this.layerThread.addChanges(changes);
        if (doEvalStep) {
            this.scheduleEvalStep();
        }
    }

    void startFetch(int level, int x, int y, final int frame) {
        if (!this.valid) {
            return;
        }
        if (!this.flipY) {
            y = (1 << level) - y - 1;
        }
        final MaplyTileID tileID = new MaplyTileID(x, y, level);
        if (level < this.tileSource.minZoom()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadImageOfflineLayer.this.loadedTile(tileID, frame, null);
                }
            }, true);
        } else {
            this.tileSource.startFetchForTile(this, tileID, frame);
        }
    }

    @Override
    public void loadedTile(final MaplyTileID tileID, final int frame, final MaplyImageTile imageTile) {
        if (!this.valid) {
            return;
        }
        int y = tileID.y;
        if (!this.flipY) {
            y = (1 << tileID.level) - tileID.y - 1;
        }
        if (Looper.myLooper() != this.layerThread.getLooper()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadImageOfflineLayer.this.loadedTile(tileID, frame, imageTile);
                }
            });
            return;
        }
        ChangeSet changes = new ChangeSet();
        if (imageTile != null) {
            this.nativeTileDidLoad(tileID.x, y, tileID.level, frame, imageTile.bitmap, changes);
        } else {
            this.nativeTileDidNotLoad(tileID.x, y, tileID.level, frame, changes);
        }
        this.layerThread.addChanges(changes);
    }

    @Override
    public LayerThread getLayerThread() {
        return this.layerThread;
    }

    public void setEnable(boolean enable) {
        if (this.layerThread == null) {
            return;
        }
        ChangeSet changes = new ChangeSet();
        this.setEnable(enable, changes);
        this.layerThread.addChanges(changes);
    }

    native void setEnable(boolean var1, ChangeSet var2);

    public native boolean getEnable();

    public native void setImageDepth(int var1);

    public native int getImageDepth();

    public native void setAllowFrameLoading(boolean var1);

    public void setFrameLoadingPriority(final int[] priorites) {
        if (!this.valid) {
            return;
        }
        this.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                QuadImageOfflineLayer.this.setFrameLoadingPriority(priorites, changes);
                QuadImageOfflineLayer.this.layerThread.addChanges(changes);
            }
        });
    }

    native void setFrameLoadingPriority(int[] var1, ChangeSet var2);

    public QuadImageTileLayer.FrameStatus getFrameStatus() {
        if (this.getImageDepth() <= 1) {
            return null;
        }
        QuadImageTileLayer.FrameStatus status = new QuadImageTileLayer.FrameStatus(this.getImageDepth());
        status.currentFrame = this.getFrameStatusNative(status.complete, status.tilesLoaded);
        if (status.currentFrame == -1) {
            return null;
        }
        return status;
    }

    private native int getFrameStatusNative(boolean[] var1, int[] var2);

    public native void setMaxTiles(int var1);

    public native void setImportanceScale(float var1);

    public void setFlipY(boolean inFlipY) {
        this.flipY = inFlipY;
    }

    public native void setMultiLevelLoads(int[] var1);

    public native int getTargetZoomLevel();

    public native void reload(ChangeSet var1);

    public native void setSimultaneousFetches(int var1);

    public native void setUseTargetZoomLevel(boolean var1);

    public native void setSingleLevelLoading(boolean var1);

    public void setRenderPeriod(float period) {
        this.renderPeriod = period;
        if ((double)period > 0.0) {
            this.imageRenderPeriodic();
        }
    }

    public void setMbr(Mbr mbr) {
        this.setMbrNative(mbr.ll.getX(), mbr.ll.getY(), mbr.ur.getX(), mbr.ur.getY());
    }

    native void setMbrNative(double var1, double var3, double var5, double var7);

    native boolean getSomethingChanged();

    void imageRenderPeriodic() {
        if (this.layerThread == null) {
            return;
        }
        this.layerThread.addDelayedTask(new Runnable(){

            @Override
            public void run() {
                if (QuadImageOfflineLayer.this.getEnable() && QuadImageOfflineLayer.this.getSomethingChanged()) {
                    ChangeSet changes = new ChangeSet();
                    QuadImageOfflineLayer.this.imageRenderToLevel(-1, changes);
                    if (QuadImageOfflineLayer.this.layerThread.scene != null) {
                        changes.process(QuadImageOfflineLayer.this.layerThread.scene);
                    }
                }
                if ((double)QuadImageOfflineLayer.this.renderPeriod > 0.0) {
                    QuadImageOfflineLayer.this.imageRenderPeriodic();
                }
            }
        }, (long)(this.renderPeriod * 100.0f));
    }

    native void imageRenderToLevel(int var1, ChangeSet var2);

    void imageRenderCallback(long texID, double centerSizeX, double centerSizeY, int texSizeX, int texSizeY, int frame) {
        if (this.imageDelegate != null) {
            MaplyTexture tex = new MaplyTexture();
            tex.controller = this.maplyControl;
            tex.texID = texID;
            this.imageDelegate.renderedImage(this, tex, texSizeX, texSizeY, new Point2d(centerSizeX, centerSizeY), frame);
        }
    }

    native void nativeShutdown(ChangeSet var1);

    private static native void nativeInit();

    native void initialise(CoordSystem var1, ChangeSet var2);

    native void dispose();

    native void nativeStartLayer(Scene var1, MaplyRenderer var2, Point2d var3, Point2d var4, int var5, int var6, int var7);

    native void nativeViewUpdate(ViewState var1);

    native boolean nativeEvalStep(ChangeSet var1);

    native boolean nativeRefresh(ChangeSet var1);

    native void nativeTileDidLoad(int var1, int var2, int var3, int var4, Bitmap var5, ChangeSet var6);

    native void nativeTileDidNotLoad(int var1, int var2, int var3, int var4, ChangeSet var5);

    static {
        QuadImageOfflineLayer.nativeInit();
    }

    public static interface RenderedImageDelegate {
        public void renderedImage(QuadImageOfflineLayer var1, MaplyTexture var2, int var3, int var4, Point2d var5, int var6);
    }
}

