/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import com.mousebird.maply.ParticleSystemAttribute;
import com.mousebird.maply.Shader;
import java.util.ArrayList;
import java.util.Date;

public class ParticleSystem {
    private long nativeHandle;
    private ArrayList<String> names = new ArrayList();
    private ArrayList<Integer> types = new ArrayList();
    private ArrayList<Bitmap> images = new ArrayList();

    private ParticleSystem() {
    }

    public ParticleSystem(String name) {
        this.initialise();
        this.setName(name);
        this.setParticleSystemType(STATE.ParticleSystemPoint);
        this.setLifetime(5.0);
        this.setBatchSize(2000);
        this.setTotalParticles(100000);
        this.setBasetime((double)new Date().getTime() / 1000.0);
    }

    public void addTexture(Bitmap texture) {
        this.images.add(texture);
    }

    public ArrayList<Bitmap> getTextures() {
        return this.images;
    }

    public void finalize() {
        this.dispose();
    }

    public native long getIdent();

    public native void setName(String var1);

    public native void setDrawPriority(int var1);

    public native void setPointSize(float var1);

    public void setParticleSystemType(STATE type) {
        this.setParticleSystemTypeNative(type.getValue());
    }

    native void setParticleSystemTypeNative(int var1);

    public native void setShaderID(long var1);

    public void setShader(Shader shader) {
        this.setShaderID(shader.getID());
    }

    public native void setLifetime(double var1);

    public native void setBasetime(double var1);

    public native double getBasetime();

    public native void setBatchSize(int var1);

    public native int getBatchSize();

    public native void setTotalParticles(int var1);

    public native void setContinuousRender(boolean var1);

    public void addParticleSystemAttribute(String name, ParticleSystemAttribute.MaplyShaderAttrType type) {
        int which = this.names.size();
        this.names.add(name);
        this.types.add(type.getValue());
        this.addParticleSystemAttributeNative(name, type.ordinal());
    }

    native void addParticleSystemAttributeNative(String var1, int var2);

    native void addTexID(long var1);

    public ParticleSystemAttribute[] getAttrs() {
        if (this.names.size() != this.types.size()) {
            return null;
        }
        ParticleSystemAttribute[] attrsList = new ParticleSystemAttribute[this.names.size()];
        for (int i = 0; i < attrsList.length; ++i) {
            attrsList[i] = new ParticleSystemAttribute();
            attrsList[i].setName(this.names.get(i));
            attrsList[i].setType(ParticleSystemAttribute.MaplyShaderAttrType.values()[this.types.get(i)]);
        }
        return attrsList;
    }

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        ParticleSystem.nativeInit();
    }

    public static enum STATE {
        ParticleSystemPoint(0),
        ParticleSystemRectangle(1);

        private final int value;

        private STATE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

