/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.ActiveObject;
import com.mousebird.maply.DirectionalLight;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Scene;
import com.mousebird.maply.View;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;

class MaplyRenderer {
    public Point2d frameSize = new Point2d();
    View view = null;
    ArrayList<ActiveObject> activeObjects = new ArrayList();
    public EGLDisplay display = null;
    public EGLConfig config = null;
    public EGLContext context = null;
    private long nativeHandle;

    MaplyRenderer() {
        this.initialise();
    }

    public void finalize() {
        this.dispose();
    }

    public boolean setup() {
        return true;
    }

    public boolean surfaceChanged(int width, int height) {
        this.frameSize.setValue(width, height);
        return this.resize(width, height);
    }

    public void setView(View inView) {
        this.view = inView;
        this.setViewNative(inView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveObject(ActiveObject activeObject) {
        ArrayList<ActiveObject> arrayList = this.activeObjects;
        synchronized (arrayList) {
            this.activeObjects.add(activeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActiveObject(ActiveObject activeObject) {
        ArrayList<ActiveObject> arrayList = this.activeObjects;
        synchronized (arrayList) {
            this.activeObjects.remove(activeObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activeObjectsHaveChanges() {
        ArrayList<ActiveObject> arrayList = this.activeObjects;
        synchronized (arrayList) {
            for (ActiveObject activeObject : this.activeObjects) {
                if (!activeObject.hasChanges()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender() {
        if (this.view != null) {
            this.view.animate();
        }
        ArrayList<ActiveObject> arrayList = this.activeObjects;
        synchronized (arrayList) {
            for (ActiveObject activeObject : this.activeObjects) {
                activeObject.activeUpdate();
            }
        }
        this.render();
    }

    public void setConfig(EGLConfig inConfig) {
        this.config = inConfig;
        EGL10 egl = (EGL10)EGLContext.getEGL();
        this.display = egl.eglGetCurrentDisplay();
        this.context = egl.eglGetCurrentContext();
    }

    public native void setScene(Scene var1);

    public native void setViewNative(View var1);

    public native void setClearColor(float var1, float var2, float var3, float var4);

    protected native boolean teardown();

    protected native boolean resize(int var1, int var2);

    protected native void render();

    protected native boolean hasChanges();

    public native void setPerfInterval(int var1);

    public native void addLight(DirectionalLight var1);

    public native void replaceLights(List<DirectionalLight> var1);

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        MaplyRenderer.nativeInit();
    }
}

