/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import com.mousebird.maply.ActiveObject;
import com.mousebird.maply.BasicClusterGenerator;
import com.mousebird.maply.Billboard;
import com.mousebird.maply.BillboardInfo;
import com.mousebird.maply.BillboardManager;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.ClusterGenerator;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.DirectionalLight;
import com.mousebird.maply.GLTextureView;
import com.mousebird.maply.GeometryInfo;
import com.mousebird.maply.GeometryManager;
import com.mousebird.maply.Identifiable;
import com.mousebird.maply.InternalLabel;
import com.mousebird.maply.InternalMarker;
import com.mousebird.maply.LabelInfo;
import com.mousebird.maply.LabelManager;
import com.mousebird.maply.Layer;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.LayoutLayer;
import com.mousebird.maply.LayoutManager;
import com.mousebird.maply.Light;
import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.Marker;
import com.mousebird.maply.MarkerInfo;
import com.mousebird.maply.MarkerManager;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.MetroThread;
import com.mousebird.maply.ParticleBatch;
import com.mousebird.maply.ParticleSystem;
import com.mousebird.maply.ParticleSystemManager;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Points;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.RendererWrapper;
import com.mousebird.maply.Scene;
import com.mousebird.maply.ScreenLabel;
import com.mousebird.maply.ScreenMarker;
import com.mousebird.maply.SelectedObject;
import com.mousebird.maply.SelectionManager;
import com.mousebird.maply.Shader;
import com.mousebird.maply.Shape;
import com.mousebird.maply.ShapeInfo;
import com.mousebird.maply.ShapeManager;
import com.mousebird.maply.Sticker;
import com.mousebird.maply.StickerInfo;
import com.mousebird.maply.StickerManager;
import com.mousebird.maply.Texture;
import com.mousebird.maply.TextureManager;
import com.mousebird.maply.VectorInfo;
import com.mousebird.maply.VectorManager;
import com.mousebird.maply.VectorObject;
import com.mousebird.maply.View;
import com.squareup.okhttp.OkHttpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;

public class MaplyBaseController {
    android.view.View baseView = null;
    Activity activity = null;
    private OkHttpClient httpClient;
    public static final String kToolkitDefaultTriangleNoLightingProgram = "Default Triangle;lighting=no";
    public static long EmptyIdentity = 0L;
    public static final int ImageLayerDrawPriorityDefault = 100;
    public static final int FeatureDrawPriorityBase = 20000;
    public static final int MarkerDrawPriorityDefault = 40000;
    public static final int LabelDrawPriorityDefault = 60000;
    public static final int ParticleDrawPriorityDefault = 1000;
    public int frameInterval = 2;
    public boolean disposeAfterRemoval = false;
    boolean running = false;
    protected RendererWrapper renderWrapper;
    protected CoordSystemDisplayAdapter coordAdapter;
    protected Scene scene = null;
    protected View view = null;
    VectorManager vecManager;
    MarkerManager markerManager;
    StickerManager stickerManager;
    LabelManager labelManager;
    SelectionManager selectionManager;
    LayoutManager layoutManager;
    ParticleSystemManager particleSystemManager;
    LayoutLayer layoutLayer = null;
    ShapeManager shapeManager = null;
    BillboardManager billboardManager = null;
    GeometryManager geomManager = null;
    TextureManager texManager = new TextureManager();
    ArrayList<LayerThread> layerThreads = new ArrayList();
    ArrayList<LayerThread> workerThreads = new ArrayList();
    Point2d[] viewBounds = null;
    private int lastLayerThreadReturned = 0;
    boolean useTextureView = false;
    boolean libraryLoaded = false;
    int numWorkingThreads = 8;
    int width = 0;
    int height = 0;
    ColorDrawable tempBackground = null;
    ArrayList<Runnable> surfaceTasks = new ArrayList();
    protected MetroThread metroThread;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    ArrayList<ContextInfo> glContexts = new ArrayList();
    ContextInfo glContext = null;
    boolean rendererAttached = false;
    ArrayList<Runnable> postSurfaceRunnables = new ArrayList();
    int displayRate = 2;
    boolean startupAborted = false;
    int clearColor = -16777216;
    int perfInterval = 0;
    protected ArrayList<ComponentObject> componentObjects = new ArrayList();
    Map<Long, Object> selectionMap = new HashMap<Long, Object>();
    private ArrayList<Light> lights = new ArrayList();

    public Scene getScene() {
        return this.scene;
    }

    public void takeScreenshot(ScreenshotListener listener) {
        if (this.baseView instanceof GLTextureView) {
            GLTextureView textureView = (GLTextureView)this.baseView;
            listener.onScreenshotResult(textureView.getBitmap());
        } else {
            GLSurfaceView surfaceView = null;
            if (this.baseView instanceof GLSurfaceView) {
                surfaceView = (GLSurfaceView)this.baseView;
            }
            this.renderWrapper.takeScreenshot(listener, surfaceView);
        }
    }

    OkHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new OkHttpClient();
        }
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerThread getLayerThread() {
        if (this.layerThreads == null) {
            return null;
        }
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            if (this.layerThreads.size() == 0) {
                return null;
            }
            return this.layerThreads.get(0);
        }
    }

    public LayerThread getWorkingThread() {
        int numAvailable = this.workerThreads.size();
        if (numAvailable < 0) {
            return null;
        }
        if (numAvailable == 0) {
            return this.workerThreads.get(0);
        }
        return this.workerThreads.get(this.lastLayerThreadReturned++ % numAvailable);
    }

    public boolean usesTextureView() {
        return this.useTextureView;
    }

    public MaplyBaseController(Activity mainActivity, Settings settings) {
        System.loadLibrary("gnustl_shared");
        System.loadLibrary("Maply");
        this.libraryLoaded = true;
        this.activity = mainActivity;
        if (settings != null) {
            this.useTextureView = !settings.useSurfaceView;
            this.numWorkingThreads = settings.numWorkingThreads;
            this.width = settings.width;
            this.height = settings.height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Init() {
        boolean supportsEs2;
        if (!this.libraryLoaded) {
            System.loadLibrary("gnustl_shared");
            System.loadLibrary("Maply");
            this.libraryLoaded = true;
        }
        this.vecManager = new VectorManager(this.scene);
        this.markerManager = new MarkerManager(this.scene);
        this.stickerManager = new StickerManager(this.scene);
        this.labelManager = new LabelManager(this.scene);
        this.layoutManager = new LayoutManager(this.scene);
        this.selectionManager = new SelectionManager(this.scene);
        this.particleSystemManager = new ParticleSystemManager(this.scene);
        this.shapeManager = new ShapeManager(this.scene);
        this.billboardManager = new BillboardManager(this.scene);
        this.geomManager = new GeometryManager(this.scene);
        this.renderWrapper = new RendererWrapper(this);
        this.renderWrapper.scene = this.scene;
        this.renderWrapper.view = this.view;
        LayerThread layerThread = new LayerThread("Maply Layer Thread", this.view, this.scene, true);
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            this.layerThreads.add(layerThread);
        }
        ActivityManager activityManager = (ActivityManager)this.activity.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean bl = supportsEs2 = configurationInfo.reqGlEsVersion >= 131072 || this.isProbablyEmulator();
        if (supportsEs2) {
            if (!this.useTextureView) {
                GLSurfaceView glSurfaceView = new GLSurfaceView((Context)this.activity);
                if (this.width > 0 && this.height > 0) {
                    glSurfaceView.getHolder().setFixedSize(this.width, this.height);
                }
                if (Color.alpha((int)this.clearColor) < 255) {
                    glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
                    glSurfaceView.getHolder().setFormat(-3);
                    glSurfaceView.setZOrderOnTop(true);
                } else if (this.isProbablyEmulator()) {
                    glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
                }
                this.tempBackground = new ColorDrawable();
                this.tempBackground.setColor(this.clearColor);
                if (Build.VERSION.SDK_INT > 16) {
                    glSurfaceView.setBackground((Drawable)this.tempBackground);
                }
                glSurfaceView.setEGLContextClientVersion(2);
                glSurfaceView.setRenderer((GLSurfaceView.Renderer)this.renderWrapper);
                this.baseView = glSurfaceView;
            } else {
                GLTextureView glTextureView = new GLTextureView((Context)this.activity);
                if (this.width > 0 && this.height > 0) {
                    glTextureView.getSurfaceTexture().setDefaultBufferSize(this.width, this.height);
                }
                if (Color.alpha((int)this.clearColor) < 255) {
                    glTextureView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
                } else if (this.isProbablyEmulator()) {
                    glTextureView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
                }
                glTextureView.setOpaque(false);
                this.tempBackground = new ColorDrawable();
                this.tempBackground.setColor(this.clearColor);
                if (Build.VERSION.SDK_INT > 16 && Build.VERSION.SDK_INT < 24) {
                    glTextureView.setBackground((Drawable)this.tempBackground);
                }
                glTextureView.setEGLContextClientVersion(2);
                glTextureView.setRenderer(this.renderWrapper);
                this.baseView = glTextureView;
            }
        } else {
            Toast.makeText((Context)this.activity, (CharSequence)"This device does not support OpenGL ES 2.0.", (int)1).show();
            return;
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerThread makeLayerThread(boolean handlesViewUpdates) {
        if (!this.running) {
            return null;
        }
        LayerThread newLayerThread = new LayerThread("External Maply Layer Thread", this.view, this.scene, handlesViewUpdates);
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            this.layerThreads.add(newLayerThread);
        }
        newLayerThread.setRenderer(this.renderWrapper.maplyRender);
        if (handlesViewUpdates) {
            newLayerThread.viewUpdated(this.view);
        }
        return newLayerThread;
    }

    public Point3d displayCoord(Point3d localCoord, CoordSystem fromSystem) {
        Point3d loc3d = CoordSystem.CoordSystemConvert3d(fromSystem, this.coordAdapter.getCoordSystem(), localCoord);
        Point3d pt = this.coordAdapter.localToDisplay(loc3d);
        return pt;
    }

    public android.view.View getContentView() {
        return this.baseView;
    }

    public Point2d getViewSize() {
        if (this.baseView == null) {
            return new Point2d(0.0, 0.0);
        }
        return new Point2d(this.baseView.getWidth(), this.baseView.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.startupAborted = true;
        MaplyBaseController maplyBaseController = this;
        synchronized (maplyBaseController) {
            this.running = false;
            this.setEGLContext(this.glContext);
            this.renderWrapper.stopRendering();
            ArrayList<LayerThread> layerThreadsToRemove = null;
            ArrayList<LayerThread> arrayList = this.layerThreads;
            synchronized (arrayList) {
                layerThreadsToRemove = new ArrayList<LayerThread>(this.layerThreads);
            }
            for (LayerThread layerThread : layerThreadsToRemove) {
                layerThread.shutdown();
            }
            arrayList = this.layerThreads;
            synchronized (arrayList) {
                this.layerThreads.clear();
            }
            this.metroThread.shutdown();
            this.metroThread = null;
            this.scene.teardownGL();
            this.scene.shutdown();
            this.coordAdapter.shutdown();
            this.vecManager.dispose();
            this.markerManager.dispose();
            this.stickerManager.dispose();
            this.selectionManager.dispose();
            this.labelManager.dispose();
            this.layoutManager.dispose();
            this.particleSystemManager.dispose();
            EGL10 egl = (EGL10)EGLContext.getEGL();
            for (ContextInfo context : this.glContexts) {
                egl.eglDestroySurface(this.renderWrapper.maplyRender.display, context.eglSurface);
                egl.eglDestroyContext(this.renderWrapper.maplyRender.display, context.eglContext);
            }
            this.glContexts = null;
            egl.eglDestroySurface(this.renderWrapper.maplyRender.display, this.glContext.eglSurface);
            egl.eglDestroyContext(this.renderWrapper.maplyRender.display, this.glContext.eglContext);
            this.glContext = null;
            this.setEGLContext(null);
            this.renderWrapper.shutdown();
            this.baseView = null;
            this.renderWrapper = null;
            this.coordAdapter = null;
            this.scene = null;
            this.view = null;
            this.vecManager = null;
            this.markerManager = null;
            this.stickerManager = null;
            this.labelManager = null;
            this.selectionManager = null;
            this.layoutManager = null;
            this.particleSystemManager = null;
            this.layoutLayer = null;
            this.shapeManager = null;
            this.billboardManager = null;
            this.texManager = null;
            this.workerThreads = null;
            this.activity = null;
            this.tempBackground = null;
        }
    }

    boolean isOnGLThread() {
        return Thread.currentThread() == this.renderWrapper.renderThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOnLayerThread() {
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            for (LayerThread thread : this.layerThreads) {
                if (Looper.myLooper() != thread.getLooper()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContextInfo setupTempContext(ThreadMode threadMode) {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        ContextInfo retContext = null;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.setEGLContext(null);
            return this.glContext;
        }
        if (this.isOnGLThread() || this.isOnLayerThread()) {
            return null;
        }
        ArrayList<ContextInfo> arrayList = this.glContexts;
        synchronized (arrayList) {
            if (this.glContexts.size() == 0) {
                int[] attrib_list = new int[]{12440, 2, 12344};
                retContext = new ContextInfo();
                retContext.eglContext = egl.eglCreateContext(this.renderWrapper.maplyRender.display, this.renderWrapper.maplyRender.config, this.renderWrapper.maplyRender.context, attrib_list);
                int[] surface_attrs = new int[]{12375, 32, 12374, 32, 12344};
                retContext.eglSurface = egl.eglCreatePbufferSurface(this.renderWrapper.maplyRender.display, this.renderWrapper.maplyRender.config, surface_attrs);
            } else {
                retContext = this.glContexts.get(0);
                this.glContexts.remove(0);
            }
        }
        this.setEGLContext(retContext);
        return retContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearTempContext(ContextInfo cInfo) {
        if (cInfo == null) {
            return;
        }
        ArrayList<ContextInfo> arrayList = this.glContexts;
        synchronized (arrayList) {
            if (cInfo != this.glContext) {
                EGL10 egl = (EGL10)EGLContext.getEGL();
                if (!egl.eglMakeCurrent(this.renderWrapper.maplyRender.display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
                    Log.d((String)"Maply", (String)"Failed to clear context");
                }
                this.glContexts.add(cInfo);
            }
        }
    }

    public boolean rendererIsAttached() {
        return this.rendererAttached;
    }

    public void addPostSurfaceRunnable(Runnable run) {
        if (this.rendererAttached) {
            this.activity.runOnUiThread(run);
        } else {
            this.postSurfaceRunnables.add(run);
        }
    }

    public void setDisplayRate(int inRate) {
        this.displayRate = inRate;
        if (this.metroThread != null) {
            this.metroThread.setFrameRate(inRate);
        }
    }

    public void requestRender() {
        if (this.metroThread != null) {
            this.metroThread.requestRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void surfaceCreated(RendererWrapper wrap) {
        MaplyBaseController maplyBaseController = this;
        synchronized (maplyBaseController) {
            if (this.startupAborted) {
                return;
            }
            ArrayList<LayerThread> arrayList = this.layerThreads;
            synchronized (arrayList) {
                for (LayerThread layerThread : this.layerThreads) {
                    layerThread.setRenderer(this.renderWrapper.maplyRender);
                }
            }
            this.renderWrapper.maplyRender.setPerfInterval(this.perfInterval);
            this.layoutLayer = new LayoutLayer(this, this.layoutManager);
            LayerThread baseLayerThread = null;
            Iterator<Runnable> iterator = this.layerThreads;
            synchronized (iterator) {
                baseLayerThread = this.layerThreads.get(0);
            }
            baseLayerThread.addLayer(this.layoutLayer);
            this.addClusterGenerator(new BasicClusterGenerator(new int[]{Color.argb((int)255, (int)255, (int)165, (int)0)}, 0, new Point2d(64.0, 64.0), this, this.activity));
            if (this.surfaceTasks != null) {
                for (Runnable run : this.surfaceTasks) {
                    Handler handler = new Handler(this.activity.getMainLooper());
                    handler.post(run);
                }
                this.surfaceTasks = null;
            }
            if (this.baseView instanceof GLSurfaceView) {
                GLSurfaceView glSurfaceView = (GLSurfaceView)this.baseView;
                glSurfaceView.setRenderMode(0);
            } else {
                GLTextureView glTextureView = (GLTextureView)this.baseView;
                glTextureView.setRenderMode(0);
            }
            this.metroThread = new MetroThread("Metronome Thread", this, this.displayRate);
            this.metroThread.setRenderer(this.renderWrapper.maplyRender);
            EGL10 egl = (EGL10)EGLContext.getEGL();
            int[] attrib_list = new int[]{12440, 2, 12344};
            this.glContext = new ContextInfo();
            this.glContext.eglContext = egl.eglCreateContext(this.renderWrapper.maplyRender.display, this.renderWrapper.maplyRender.config, this.renderWrapper.maplyRender.context, attrib_list);
            int[] surface_attrs = new int[]{12375, 32, 12374, 32, 12344};
            this.glContext.eglSurface = egl.eglCreatePbufferSurface(this.renderWrapper.maplyRender.display, this.renderWrapper.maplyRender.config, surface_attrs);
            ArrayList<LayerThread> arrayList2 = this.layerThreads;
            synchronized (arrayList2) {
                for (LayerThread layerThread : this.layerThreads) {
                    layerThread.viewUpdated(this.view);
                }
            }
            this.setClearColor(this.clearColor);
            for (int ii = 0; ii < this.numWorkingThreads; ++ii) {
                this.workerThreads.add(this.makeLayerThread(false));
            }
            this.rendererAttached = true;
            for (final Runnable theRunnable : this.postSurfaceRunnables) {
                this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MaplyBaseController.this.running) {
                            theRunnable.run();
                        }
                    }
                });
            }
            this.postSurfaceRunnables.clear();
        }
    }

    boolean setEGLContext(ContextInfo cInfo) {
        if (cInfo == null) {
            cInfo = this.glContext;
        }
        if (this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.display == null) {
            return false;
        }
        EGL10 egl = (EGL10)EGLContext.getEGL();
        if (cInfo != null) {
            if (!egl.eglMakeCurrent(this.renderWrapper.maplyRender.display, cInfo.eglSurface, cInfo.eglSurface, cInfo.eglContext)) {
                Log.d((String)"Maply", (String)"Failed to make current context.");
                return false;
            }
            return true;
        }
        if (this.renderWrapper != null && this.renderWrapper.maplyRender != null && this.renderWrapper.maplyRender.display != null) {
            egl.eglMakeCurrent(this.renderWrapper.maplyRender.display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        }
        return false;
    }

    private void onSurfaceCreatedTask(Runnable run) {
        if (this.surfaceTasks != null) {
            this.surfaceTasks.add(run);
        } else {
            run.run();
        }
    }

    public void setClearColor(int color) {
        this.clearColor = color;
        if (this.renderWrapper == null) {
            return;
        }
        if (this.renderWrapper.maplyRender != null) {
            this.renderWrapper.maplyRender.setClearColor((float)Color.red((int)color) / 255.0f, (float)Color.green((int)color) / 255.0f, (float)Color.blue((int)color) / 255.0f, (float)Color.alpha((int)color) / 255.0f);
        }
    }

    public void setViewExtents(Point2d ll, Point2d ur) {
        CoordSystemDisplayAdapter coordAdapter = this.view.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        this.viewBounds = new Point2d[4];
        this.viewBounds[0] = coordAdapter.localToDisplay(coordSys.geographicToLocal(new Point3d(ll.getX(), ll.getY(), 0.0))).toPoint2d();
        this.viewBounds[1] = coordAdapter.localToDisplay(coordSys.geographicToLocal(new Point3d(ur.getX(), ll.getY(), 0.0))).toPoint2d();
        this.viewBounds[2] = coordAdapter.localToDisplay(coordSys.geographicToLocal(new Point3d(ur.getX(), ur.getY(), 0.0))).toPoint2d();
        this.viewBounds[3] = coordAdapter.localToDisplay(coordSys.geographicToLocal(new Point3d(ll.getX(), ur.getY(), 0.0))).toPoint2d();
    }

    public boolean screenPointFromGeoBatch(double[] inX, double[] inY, double[] inZ, double[] outX, double[] outY) {
        if (!this.running || this.view == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return false;
        }
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        return this.coordAdapter.screenPointFromGeoBatch(this.view, (int)frameSize.getX(), (int)frameSize.getY(), inX, inY, inZ, outX, outY);
    }

    public boolean geoPointFromScreenBatch(double[] inX, double[] inY, double[] outX, double[] outY) {
        if (!this.running || this.view == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return false;
        }
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        return this.coordAdapter.geoPointFromScreenBatch(this.view, (int)frameSize.getX(), (int)frameSize.getY(), inX, inY, outX, outY);
    }

    public void setPerfInterval(int inPerfInterval) {
        this.perfInterval = inPerfInterval;
        if (this.renderWrapper != null && this.renderWrapper.maplyRender != null) {
            this.renderWrapper.maplyRender.setPerfInterval(this.perfInterval);
        }
    }

    public double heightForMapScale(double scale) {
        if (!this.running || this.view == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return 0.0;
        }
        return this.view.heightForMapScale(scale, this.renderWrapper.maplyRender.frameSize.getX(), this.renderWrapper.maplyRender.frameSize.getY());
    }

    public double currentMapZoom(Point2d geoCoord) {
        if (!this.running || this.view == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return 0.0;
        }
        return this.view.currentMapZoom(this.renderWrapper.maplyRender.frameSize.getX(), this.renderWrapper.maplyRender.frameSize.getY(), geoCoord.getY());
    }

    public double currentMapScale() {
        if (!this.running || this.view == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return 0.0;
        }
        return this.view.currentMapScale(this.renderWrapper.maplyRender.frameSize.getX(), this.renderWrapper.maplyRender.frameSize.getY());
    }

    public ComponentObject addVector(VectorObject vec, VectorInfo vecInfo, ThreadMode mode) {
        ArrayList<VectorObject> vecObjs = new ArrayList<VectorObject>();
        vecObjs.add(vec);
        return this.addVectors(vecObjs, vecInfo, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayer(final Layer layer) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.addLayer(layer);
                }
            });
            return;
        }
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            if (this.layerThreads.size() > 0) {
                LayerThread baseLayerThread = this.layerThreads.get(0);
                baseLayerThread.addLayer(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayer(final Layer layer) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.removeLayer(layer);
                }
            });
            return;
        }
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            if (this.layerThreads.size() > 0) {
                LayerThread baseLayerThread = this.layerThreads.get(0);
                baseLayerThread.removeLayer(layer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(final Runnable run, final ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.addTask(run, mode);
                }
            });
            return;
        }
        LayerThread baseLayerThread = null;
        ArrayList<LayerThread> arrayList = this.layerThreads;
        synchronized (arrayList) {
            baseLayerThread = this.layerThreads.get(0);
        }
        if (mode == ThreadMode.ThreadCurrent) {
            EGL10 egl = (EGL10)EGLContext.getEGL();
            EGLContext oldContext = egl.eglGetCurrentContext();
            EGLSurface oldDrawSurface = egl.eglGetCurrentSurface(12377);
            EGLSurface oldReadSurface = egl.eglGetCurrentSurface(12378);
            ContextInfo tempContext = this.setupTempContext(mode);
            run.run();
            this.clearTempContext(tempContext);
            if (oldContext != null && this.renderWrapper != null && !egl.eglMakeCurrent(this.renderWrapper.maplyRender.display, oldDrawSurface, oldReadSurface, oldContext)) {
                Log.d((String)"Maply", (String)"Failed to set context back to previous context.");
            }
        } else {
            baseLayerThread.addTask(run, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentObject addComponentObj() {
        ArrayList<ComponentObject> arrayList = this.componentObjects;
        synchronized (arrayList) {
            ComponentObject compObj = new ComponentObject();
            this.componentObjects.add(compObj);
            return compObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeComponentObj(ComponentObject compObj) {
        ArrayList<ComponentObject> arrayList = this.componentObjects;
        synchronized (arrayList) {
            this.componentObjects.remove(compObj);
        }
    }

    public ComponentObject addVectors(final List<VectorObject> vecs, final VectorInfo vecInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                long vecId = MaplyBaseController.this.vecManager.addVectors(vecs, vecInfo, changes);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (vecId != EmptyIdentity) {
                    compObj.addVectorID(vecId);
                }
                for (VectorObject vecObj : vecs) {
                    if (!vecObj.selectable) continue;
                    compObj.addVector(vecObj);
                }
                if (vecInfo.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (VectorObject vecObj : vecs) {
                        if (vecObj.selectable) continue;
                        vecObj.dispose();
                    }
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public void changeVectors(final ComponentObject vecObj, final VectorInfo vecInfo, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (vecObj == null) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                long[] vecIDs = vecObj.getVectorIDs();
                if (vecIDs != null) {
                    MaplyBaseController.this.vecManager.changeVectors(vecIDs, vecInfo, changes);
                    if (MaplyBaseController.this.scene != null) {
                        changes.process(MaplyBaseController.this.scene);
                    }
                }
            }
        };
        this.addTask(run, mode);
    }

    public ComponentObject addScreenMarker(ScreenMarker marker, MarkerInfo markerInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        ArrayList<ScreenMarker> markers = new ArrayList<ScreenMarker>();
        markers.add(marker);
        return this.addScreenMarkers(markers, markerInfo, mode);
    }

    public ComponentObject addScreenMarkers(final List<ScreenMarker> markers, final MarkerInfo markerInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                ArrayList<InternalMarker> intMarkers = new ArrayList<InternalMarker>();
                for (ScreenMarker marker : markers) {
                    if (marker.loc == null) {
                        Log.d((String)"Maply", (String)"Missing location for marker.  Skipping.");
                        return;
                    }
                    InternalMarker intMarker = new InternalMarker(marker, markerInfo);
                    long texID = EmptyIdentity;
                    if (marker.image != null) {
                        texID = MaplyBaseController.this.texManager.addTexture(marker.image, MaplyBaseController.this.scene, changes);
                    }
                    if (texID != EmptyIdentity) {
                        intMarker.addTexID(texID);
                    }
                    if (marker.vertexAttributes != null) {
                        intMarker.setVertexAttributes(marker.vertexAttributes.toArray());
                    }
                    intMarkers.add(intMarker);
                    if (!marker.selectable) continue;
                    MaplyBaseController.this.addSelectableObject(marker.ident, marker, compObj);
                }
                long markerId = MaplyBaseController.this.markerManager.addScreenMarkers(intMarkers, markerInfo, changes);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (markerId != EmptyIdentity) {
                    compObj.addMarkerID(markerId);
                }
                for (InternalMarker marker : intMarkers) {
                    marker.dispose();
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject addMarker(Marker marker, MarkerInfo markerInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        ArrayList<Marker> markers = new ArrayList<Marker>();
        markers.add(marker);
        return this.addMarkers(markers, markerInfo, mode);
    }

    public ComponentObject addMarkers(final List<Marker> markers, final MarkerInfo markerInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                ArrayList<InternalMarker> intMarkers = new ArrayList<InternalMarker>();
                for (Marker marker : markers) {
                    if (marker.loc == null) {
                        Log.d((String)"Maply", (String)"Missing location for marker.  Skipping.");
                        return;
                    }
                    InternalMarker intMarker = new InternalMarker(marker, markerInfo);
                    long texID = EmptyIdentity;
                    if (marker.image != null) {
                        texID = MaplyBaseController.this.texManager.addTexture(marker.image, MaplyBaseController.this.scene, changes);
                        if (texID != EmptyIdentity) {
                            intMarker.addTexID(texID);
                        }
                    } else if (marker.images != null) {
                        for (MaplyTexture tex : marker.images) {
                            intMarker.addTexID(tex.texID);
                        }
                    }
                    intMarkers.add(intMarker);
                    if (!marker.selectable) continue;
                    MaplyBaseController.this.addSelectableObject(marker.ident, marker, compObj);
                }
                long markerId = MaplyBaseController.this.markerManager.addMarkers(intMarkers, markerInfo, changes);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (markerId != EmptyIdentity) {
                    compObj.addMarkerID(markerId);
                }
                for (InternalMarker marker : intMarkers) {
                    marker.dispose();
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject addStickers(final List<Sticker> stickers, final StickerInfo stickerInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (Sticker sticker : stickers) {
                    long stickerID = MaplyBaseController.this.stickerManager.addSticker(sticker, stickerInfo, changes);
                    if (stickerID == EmptyIdentity) continue;
                    compObj.addStickerID(stickerID);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (stickerInfo.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (Sticker sticker : stickers) {
                        sticker.dispose();
                    }
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject changeSticker(final ComponentObject stickerObj, final StickerInfo stickerInfo, ThreadMode mode) {
        if (!this.running || stickerObj == null) {
            return null;
        }
        ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                long[] stickerIDs = stickerObj.getStickerIDs();
                if (stickerIDs != null && stickerIDs.length > 0) {
                    long stickerID = stickerIDs[0];
                    MaplyBaseController.this.stickerManager.changeSticker(stickerID, stickerInfo, changes);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject addPointList(final List<Points> ptList, final GeometryInfo geomInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (Points pts : ptList) {
                    Matrix4d mat;
                    Matrix4d matrix4d = mat = pts.mat != null ? pts.mat : new Matrix4d();
                    long geomID = MaplyBaseController.this.geomManager.addGeometryPoints(pts.rawPoints, pts.mat, geomInfo, changes);
                    if (geomID == EmptyIdentity) continue;
                    compObj.addGeometryID(geomID);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (geomInfo.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (Points pts : ptList) {
                        pts.rawPoints.dispose();
                    }
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject addPoints(Points pts, GeometryInfo geomInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        ArrayList<Points> ptList = new ArrayList<Points>();
        ptList.add(pts);
        return this.addPointList(ptList, geomInfo, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectableObject(long selectID, Object selObj, ComponentObject compObj) {
        Map<Long, Object> map = this.selectionMap;
        synchronized (map) {
            compObj.addSelectID(selectID);
            this.selectionMap.put(selectID, selObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectableObjects(ComponentObject compObj) {
        if (compObj.selectIDs != null) {
            Map<Long, Object> map = this.selectionMap;
            synchronized (map) {
                for (long selectID : compObj.selectIDs) {
                    Object selObj = this.selectionMap.get(selectID);
                    if (selObj == null) continue;
                    if (this.disposeAfterRemoval && selObj.getClass() == VectorObject.class) {
                        VectorObject vecObj = (VectorObject)selObj;
                        vecObj.dispose();
                    }
                    this.selectionMap.remove(selectID);
                }
            }
        }
    }

    public Point2d geoPointFromScreen(Point2d screenPt) {
        return null;
    }

    public Point2d screenPointFromGeo(Point2d geoCoord) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectedObject[] getObjectsAtScreenLoc(Point2d screenLoc) {
        Point2d geoPt;
        Point2d viewSize = this.getViewSize();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        Point2d scale = new Point2d(frameSize.getX() / viewSize.getX(), frameSize.getY() / viewSize.getY());
        Point2d frameLoc = new Point2d(scale.getX() * screenLoc.getX(), scale.getY() * screenLoc.getY());
        SelectedObject[] selManObjs = this.selectionManager.pickObjects(this.view, frameLoc);
        if (selManObjs != null) {
            Map<Long, Object> map = this.selectionMap;
            synchronized (map) {
                for (SelectedObject selObj : selManObjs) {
                    long selectID = selObj.getSelectID();
                    selObj.selObj = this.selectionMap.get(selectID);
                }
            }
        }
        if ((geoPt = this.geoPointFromScreen(screenLoc)) == null) {
            return null;
        }
        ArrayList<Object> vecSelObjs = new ArrayList<Object>();
        Object[] objectArray = this.componentObjects;
        synchronized (this.componentObjects) {
            ComponentObject[] theCompObjs = this.componentObjects.toArray(new ComponentObject[this.componentObjects.size()]);
            // ** MonitorExit[var10_12] (shouldn't be in output)
            for (ComponentObject compObj : theCompObjs) {
                if (compObj.vecObjs == null) continue;
                for (VectorObject vecObj : compObj.vecObjs) {
                    if (!vecObj.pointInside(geoPt)) continue;
                    SelectedObject selObj = new SelectedObject();
                    selObj.selObj = vecObj;
                    vecSelObjs.add(selObj);
                }
            }
            if (vecSelObjs.size() == 0) {
                return selManObjs;
            }
            if (selManObjs != null) {
                for (SelectedObject selObj : selManObjs) {
                    vecSelObjs.add(selObj);
                }
            }
            return vecSelObjs.toArray(new SelectedObject[vecSelObjs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectAtScreenLoc(Point2d screenLoc) {
        Point2d viewSize = this.getViewSize();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        Point2d scale = new Point2d(frameSize.getX() / viewSize.getX(), frameSize.getY() / viewSize.getY());
        Point2d frameLoc = new Point2d(scale.getX() * screenLoc.getX(), scale.getY() * screenLoc.getY());
        long selectID = this.selectionManager.pickObject(this.view, frameLoc);
        if (selectID != EmptyIdentity) {
            Object selObj = null;
            Map<Long, Object> map = this.selectionMap;
            synchronized (map) {
                selObj = this.selectionMap.get(selectID);
            }
            return selObj;
        }
        return null;
    }

    public ComponentObject addScreenLabel(ScreenLabel label, LabelInfo labelInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        ArrayList<ScreenLabel> labels = new ArrayList<ScreenLabel>();
        labels.add(label);
        return this.addScreenLabels(labels, labelInfo, mode);
    }

    public ComponentObject addScreenLabels(final List<ScreenLabel> labels, final LabelInfo labelInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                ArrayList<InternalLabel> intLabels = new ArrayList<InternalLabel>();
                for (ScreenLabel label : labels) {
                    if (label.text == null || label.text.length() <= 0) continue;
                    InternalLabel intLabel = new InternalLabel(label, labelInfo);
                    intLabels.add(intLabel);
                    if (!label.selectable) continue;
                    MaplyBaseController.this.addSelectableObject(label.ident, label, compObj);
                }
                long labelId = EmptyIdentity;
                LabelManager labelManager = MaplyBaseController.this.labelManager;
                synchronized (labelManager) {
                    labelId = MaplyBaseController.this.labelManager.addLabels(intLabels, labelInfo, changes);
                }
                if (labelId != EmptyIdentity) {
                    compObj.addLabelID(labelId);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                for (InternalLabel label : intLabels) {
                    label.dispose();
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public MaplyTexture addTexture(final Bitmap image, TextureSettings settings, ThreadMode mode) {
        MaplyTexture texture = new MaplyTexture();
        final Texture rawTex = new Texture();
        texture.texID = rawTex.getID();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                rawTex.setBitmap(image);
                changes.addTexture(rawTex, MaplyBaseController.this.scene);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
        return texture;
    }

    public MaplyTexture addTexture(final Texture rawTex, TextureSettings settings, ThreadMode mode) {
        final MaplyTexture texture = new MaplyTexture();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                texture.texID = rawTex.getID();
                changes.addTexture(rawTex, MaplyBaseController.this.scene);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
        return texture;
    }

    public void removeTexture(final MaplyTexture tex, ThreadMode mode) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                changes.removeTexture(tex.texID);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
    }

    public void removeTextures(final List<MaplyTexture> texs, ThreadMode mode) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (MaplyTexture tex : texs) {
                    changes.removeTexture(tex.texID);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
    }

    public void addShaderProgram(final Shader shader, final String sceneName) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.addShaderProgram(shader, sceneName);
                }
            });
            return;
        }
        this.scene.addShaderProgram(shader, sceneName);
    }

    public void addActiveObject(final ActiveObject activeObject) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.addActiveObject(activeObject);
                }
            });
            return;
        }
        this.renderWrapper.maplyRender.addActiveObject(activeObject);
    }

    public void removeActiveObject(final ActiveObject activeObject) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.removeActiveObject(activeObject);
                }
            });
            return;
        }
        this.renderWrapper.maplyRender.removeActiveObject(activeObject);
    }

    public void disableObjects(List<ComponentObject> compObjs, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (compObjs == null || compObjs.size() == 0) {
            return;
        }
        final ComponentObject[] localCompObjs = compObjs.toArray(new ComponentObject[compObjs.size()]);
        final MaplyBaseController control = this;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (ComponentObject compObj : localCompObjs) {
                    if (compObj == null) continue;
                    compObj.enable(control, false, changes);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
    }

    public void disableObject(ComponentObject compObj, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
        compObjs.add(compObj);
        this.disableObjects(compObjs, mode);
    }

    public void enableObjects(List<ComponentObject> compObjs, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (compObjs == null || compObjs.size() == 0) {
            return;
        }
        final ComponentObject[] localCompObjs = compObjs.toArray(new ComponentObject[compObjs.size()]);
        final MaplyBaseController control = this;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (ComponentObject compObj : localCompObjs) {
                    if (compObj == null) continue;
                    compObj.enable(control, true, changes);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
    }

    public void enableObject(ComponentObject compObj, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
        compObjs.add(compObj);
        this.enableObjects(compObjs, mode);
    }

    public void removeObject(ComponentObject compObj, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (compObj == null) {
            return;
        }
        ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
        compObjs.add(compObj);
        this.removeObjects(compObjs, mode);
    }

    public void removeObjects(final List<ComponentObject> compObjs, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (compObjs == null || compObjs.size() == 0) {
            return;
        }
        final MaplyBaseController control = this;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                for (ComponentObject compObj : compObjs) {
                    compObj.clear(control, changes);
                    MaplyBaseController.this.removeSelectableObjects(compObj);
                    MaplyBaseController.this.removeComponentObj(compObj);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
    }

    private boolean isProbablyEmulator() {
        return Build.VERSION.SDK_INT >= 15 && (Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86"));
    }

    public ComponentObject addParticleSystem(final ParticleSystem particleSystem, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        final ChangeSet changes = new ChangeSet();
        for (Bitmap image : particleSystem.getTextures()) {
            MaplyTexture texture = this.addTexture(image, new TextureSettings(), mode);
            if (texture.texID == EmptyIdentity) continue;
            particleSystem.addTexID(texture.texID);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                long particleSystemID = MaplyBaseController.this.particleSystemManager.addParticleSystem(particleSystem, changes);
                if (particleSystemID != EmptyIdentity) {
                    compObj.addParticleSystemID(particleSystemID);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public void addParticleBatch(final ParticleBatch particleBatch, ThreadMode mode) {
        if (!this.running) {
            return;
        }
        if (particleBatch.isValid()) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ChangeSet changes = new ChangeSet();
                    MaplyBaseController.this.particleSystemManager.addParticleBatch(particleBatch.getPartSys().getIdent(), particleBatch, changes);
                    if (MaplyBaseController.this.scene != null) {
                        changes.process(MaplyBaseController.this.scene);
                    }
                }
            };
            this.addTask(run, mode);
        }
    }

    public void addClusterGenerator(ClusterGenerator generator) {
        if (this.layoutLayer != null) {
            generator.baseController = this;
            this.layoutLayer.addClusterGenerator(generator);
        }
    }

    public ComponentObject addShapes(final List<Shape> shapes, final ShapeInfo shapeInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        final ChangeSet changes = new ChangeSet();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                long shapeId = MaplyBaseController.this.shapeManager.addShapes(shapes, shapeInfo, changes);
                if (shapeId != EmptyIdentity) {
                    compObj.addShapeID(shapeId);
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                for (Shape shape : shapes) {
                    if (!shape.isSelectable()) continue;
                    MaplyBaseController.this.addSelectableObject(shape.getSelectID(), shape, compObj);
                }
                if (shapeInfo.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (Shape shape : shapes) {
                        shape.dispose();
                    }
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public ComponentObject addPoints(List<Points> inPoints, final GeometryInfo geomInfo, ThreadMode mode) {
        if (!this.running) {
            return null;
        }
        final Points[] points = inPoints.toArray(new Points[inPoints.size()]);
        final ComponentObject compObj = this.addComponentObj();
        final ChangeSet changes = new ChangeSet();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                for (Points pts : points) {
                    long geomId = MaplyBaseController.this.geomManager.addGeometryPoints(pts.rawPoints, pts.mat, geomInfo, changes);
                    if (geomId == EmptyIdentity) continue;
                    compObj.addGeometryID(geomId);
                }
                if (geomInfo.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (Points pts : points) {
                        pts.rawPoints.dispose();
                    }
                }
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
            }
        };
        this.addTask(run, mode);
        return compObj;
    }

    public void addLight(final Light light) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.addLight(light);
                }
            });
            return;
        }
        if (this.lights == null) {
            this.lights = new ArrayList();
        }
        this.lights.add(light);
        this.updateLights();
    }

    public void removeLight(final Light light) {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.removeLight(light);
                }
            });
            return;
        }
        if (this.lights == null) {
            return;
        }
        this.lights.remove(light);
        this.updateLights();
    }

    private void updateLights() {
        ArrayList<DirectionalLight> theLights = new ArrayList<DirectionalLight>();
        for (Light light : this.lights) {
            DirectionalLight theLight = new DirectionalLight();
            theLight.setPos(light.getPos());
            theLight.setAmbient(new Point4d(light.getAmbient()[0], light.getAmbient()[1], light.getAmbient()[2], light.getAmbient()[3]));
            theLight.setDiffuse(new Point4d(light.getDiffuse()[0], light.getDiffuse()[1], light.getDiffuse()[2], light.getDiffuse()[3]));
            theLight.setViewDependent(light.isViewDependent());
            theLights.add(theLight);
        }
        if (this.renderWrapper.getMaplyRender() != null) {
            this.renderWrapper.getMaplyRender().replaceLights(theLights);
        }
        for (DirectionalLight directionalLight : theLights) {
            directionalLight.dispose();
        }
    }

    public void clearLights() {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MaplyBaseController.this.clearLights();
                }
            });
            return;
        }
        this.lights = new ArrayList();
        this.updateLights();
    }

    public void resetLights() {
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    if (MaplyBaseController.this.running) {
                        MaplyBaseController.this.resetLights();
                    }
                }
            });
            return;
        }
        this.clearLights();
        Light light = new Light();
        light.setPos(new Point3d(0.75, 0.5, -1.0));
        light.setAmbient(0.6f, 0.6f, 0.6f, 1.0f);
        light.setDiffuse(0.5f, 0.5f, 0.5f, 1.0f);
        light.setViewDependent(false);
        this.addLight(light);
    }

    public ComponentObject addBillboards(final List<Billboard> bills, final BillboardInfo info, ThreadMode threadMode) {
        if (!this.running) {
            return null;
        }
        final ComponentObject compObj = this.addComponentObj();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ChangeSet changes = new ChangeSet();
                long shaderID = 0L;
                String shaderName = info.getShaderName();
                shaderID = shaderName == "billboardorienteye" ? MaplyBaseController.this.scene.getProgramIDBySceneName("Default Billboard eye") : (shaderName == "billboardorientground" ? MaplyBaseController.this.scene.getProgramIDBySceneName("Default Billboard ground") : MaplyBaseController.this.scene.getProgramIDBySceneName(shaderName));
                for (Billboard bill : bills) {
                    Point3d center = bill.getCenter();
                    Point3d localPt = MaplyBaseController.this.coordAdapter.getCoordSystem().geographicToLocal(new Point3d(center.getX(), center.getY(), 0.0));
                    Point3d dispTmp = MaplyBaseController.this.coordAdapter.localToDisplay(localPt);
                    Point3d dispPt = dispTmp.multiplyBy(center.getZ() / 6371000.0 + 1.0);
                    bill.setCenter(dispPt);
                    if (bill.getSelectable()) {
                        bill.setSelectID(Identifiable.genID());
                        MaplyBaseController.this.addSelectableObject(bill.getSelectID(), bill, compObj);
                    }
                    bill.flatten();
                }
                long billId = MaplyBaseController.this.billboardManager.addBillboards(bills, info, shaderID, changes);
                compObj.addBillboardID(billId);
                if (MaplyBaseController.this.scene != null) {
                    changes.process(MaplyBaseController.this.scene);
                }
                if (info.disposeAfterUse || MaplyBaseController.this.disposeAfterRemoval) {
                    for (Billboard bill : bills) {
                        if (bill.getSelectable()) continue;
                        bill.dispose();
                    }
                }
            }
        };
        this.addTask(run, threadMode);
        return compObj;
    }

    public static class TextureSettings {
        QuadImageTileLayer.ImageFormat imageFormat = QuadImageTileLayer.ImageFormat.MaplyImageIntRGBA;
    }

    public class ContextInfo {
        EGLContext eglContext = null;
        EGLSurface eglSurface = null;
    }

    public static class Settings {
        public boolean useSurfaceView = true;
        public int numWorkingThreads = 8;
        public int width = 0;
        public int height = 0;
    }

    public static enum ThreadMode {
        ThreadCurrent,
        ThreadAny;

    }

    public static interface ScreenshotListener {
        public void onScreenshotResult(Bitmap var1);
    }
}

