/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.MBTiles;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.QuadImageTileLayerInterface;

public class MBTilesImageSource
implements QuadImageTileLayer.TileSource {
    MBTiles mbTileDb;
    public CoordSystem coordSys = null;
    public int pixelsPerSide = 256;

    public MBTilesImageSource(MBTiles tileDB) {
        this.mbTileDb = tileDB;
        this.coordSys = this.mbTileDb.coordSys;
    }

    @Override
    public int minZoom() {
        return this.mbTileDb.minZoom();
    }

    @Override
    public int maxZoom() {
        return this.mbTileDb.maxZoom();
    }

    @Override
    public int pixelsPerSide() {
        return this.pixelsPerSide;
    }

    @Override
    public void startFetchForTile(final QuadImageTileLayerInterface layer, final MaplyTileID tileID, final int frame) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                byte[] image = MBTilesImageSource.this.mbTileDb.getDataTile(tileID);
                if (image != null) {
                    Bitmap bm = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
                    MaplyImageTile tile = new MaplyImageTile(bm);
                    layer.loadedTile(tileID, frame, tile);
                } else {
                    layer.loadedTile(tileID, frame, null);
                }
            }
        };
        thread.run();
    }
}

