/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.SphericalMercatorCoordSystem;
import java.io.File;

public class MBTiles {
    private static String TAG = MBTiles.class.getSimpleName();
    private static String BOUNDS = "bounds";
    private static String MINZOOM = "minzoom";
    private static String MAXZOOM = "maxzoom";
    private static String TYPE = "type";
    private static String DESCRIPTION = "description";
    private static String FORMAT = "format";
    private static String NAME = "name";
    private static String VALUE = "value";
    private static String PNG = "png";
    private static String JPG = "jpg";
    private static String GET_TILE_SQL = "SELECT tile_data from tiles where zoom_level = ? AND tile_column = ? AND tile_row= ?;";
    private static String TILE_DATA = "tile_data";
    private int minZoom = -1;
    private int maxZoom = -1;
    private SQLiteDatabase mbTileDb;
    private boolean initialized;
    private boolean oldStyleDB;
    private boolean isJpg;
    private String name = "UNSET";
    private String description = "UNSET";
    private String type = "UNSET";
    public CoordSystem coordSys = new SphericalMercatorCoordSystem();

    public MBTiles(File mbTileFile) {
        if (mbTileFile == null || !mbTileFile.exists() || !mbTileFile.canRead()) {
            String message = String.format("MBTileSource must be initialized with an existing file. \"%s\" does not exists or is null...", mbTileFile == null ? "#NULL" : mbTileFile.getAbsolutePath());
            Log.e((String)TAG, (String)message);
        }
        this.init(mbTileFile);
    }

    public int minZoom() {
        return this.minZoom;
    }

    public int maxZoom() {
        return this.maxZoom;
    }

    public void setMinZoom(int inZoom) {
        this.minZoom = inZoom;
    }

    public void setMaxZoom(int inZoom) {
        this.maxZoom = inZoom;
    }

    private void init(File sqliteDb) {
        this.mbTileDb = SQLiteDatabase.openDatabase((String)sqliteDb.getAbsolutePath(), null, (int)1);
        String sql = "SELECT name, value FROM metadata;";
        Cursor c = this.mbTileDb.rawQuery(sql, null);
        if (c.getCount() > 0) {
            c.moveToFirst();
            int nameIdx = c.getColumnIndexOrThrow(NAME);
            int valueIdx = c.getColumnIndexOrThrow(VALUE);
            while (!c.isAfterLast()) {
                String format;
                String meta = c.getString(nameIdx);
                if (MAXZOOM.equals(meta)) {
                    this.maxZoom = c.getInt(valueIdx);
                }
                if (MINZOOM.equals(meta)) {
                    this.minZoom = c.getInt(valueIdx);
                }
                if (FORMAT.equals(meta) && JPG.equals(format = c.getString(valueIdx))) {
                    this.isJpg = true;
                }
                if (NAME.equals(meta)) {
                    this.name = c.getString(valueIdx);
                }
                if (DESCRIPTION.equals(meta)) {
                    this.description = c.getString(valueIdx);
                }
                c.moveToNext();
            }
        }
        c.close();
        if (this.minZoom == -1 || this.maxZoom == -1) {
            sql = "SELECT MIN(zoom_level) AS minzoom, MAX(zoom_level) as maxzoom FROM tiles;";
            c = this.mbTileDb.rawQuery(sql, null);
            if (c.getCount() > 0) {
                c.moveToFirst();
                this.minZoom = c.getInt(c.getColumnIndexOrThrow(MINZOOM));
                this.maxZoom = c.getInt(c.getColumnIndexOrThrow(MAXZOOM));
            }
            c.close();
            Log.i((String)TAG, (String)"Got MIN & MAX zoom the hard way...");
        }
        Log.v((String)TAG, (String)String.format("Initialized MBTilesSource %s (%s)", this.name, this.description));
        Log.v((String)TAG, (String)String.format("  > Zoom %d -> %d", this.minZoom, this.maxZoom));
        Log.v((String)TAG, (String)String.format("  > Type \"%s\"", this.type));
        Log.v((String)TAG, (String)String.format("  > Format \"%s\"", this.isJpg ? "jpg" : "png"));
    }

    public byte[] getDataTile(MaplyTileID tileID) {
        String[] params = new String[]{Integer.toString(tileID.level), Integer.toString(tileID.x), Integer.toString(tileID.y)};
        Cursor c = this.mbTileDb.rawQuery(GET_TILE_SQL, params);
        int tileDataIdx = c.getColumnIndex(TILE_DATA);
        if (c.getCount() > 0) {
            c.moveToFirst();
            byte[] data = c.getBlob(tileDataIdx);
            return data;
        }
        c.close();
        return null;
    }
}

