/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.os.Handler;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.ClusterGenerator;
import com.mousebird.maply.Layer;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.LayoutManager;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.ViewState;

class LayoutLayer
extends Layer
implements LayerThread.ViewWatcherInterface {
    MaplyBaseController maplyControl = null;
    LayoutManager layoutManager = null;
    ViewState viewState = null;
    ViewState lastViewState = null;
    Runnable updateRun = null;
    Handler updateHandle = null;

    LayoutLayer(MaplyBaseController inMaplyControl, LayoutManager inLayoutManager) {
        this.maplyControl = inMaplyControl;
        this.layoutManager = inLayoutManager;
    }

    @Override
    public void startLayer(LayerThread inLayerThread) {
        super.startLayer(inLayerThread);
        this.scheduleUpdate();
        this.maplyControl.getLayerThread().addWatcher(this);
    }

    @Override
    public void shutdown() {
        this.cancelUpdate();
        this.layoutManager.clearClusterGenerators();
    }

    @Override
    public void viewUpdated(ViewState newViewState) {
        if (this.viewState == null || this.viewState != newViewState) {
            this.viewState = newViewState;
            this.cancelUpdate();
            this.scheduleUpdate();
        }
    }

    Runnable makeRepeatingTask() {
        return new Runnable(){

            @Override
            public void run() {
                LayoutLayer.this.runUpdate();
                LayoutLayer.this.scheduleUpdate();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleUpdate() {
        LayoutLayer layoutLayer = this;
        synchronized (layoutLayer) {
            if (this.updateHandle == null) {
                this.updateRun = this.makeRepeatingTask();
                this.updateHandle = this.maplyControl.getLayerThread().addDelayedTask(this.updateRun, 200L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelUpdate() {
        LayoutLayer layoutLayer = this;
        synchronized (layoutLayer) {
            if (this.updateHandle != null) {
                this.updateHandle.removeCallbacks(this.updateRun);
                this.updateHandle = null;
                this.updateRun = null;
            }
        }
    }

    void runUpdate() {
        this.updateHandle = null;
        this.updateRun = null;
        if (this.layoutManager.hasChanges() || this.viewState != this.lastViewState) {
            ChangeSet changes = new ChangeSet();
            this.layoutManager.updateLayout(this.viewState, changes);
            this.maplyControl.scene.addChanges(changes);
            this.lastViewState = this.viewState;
        }
    }

    @Override
    public float getMinTime() {
        return 0.2f;
    }

    @Override
    public float getMaxLagTime() {
        return 4.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterGenerator(ClusterGenerator generator) {
        LayoutLayer layoutLayer = this;
        synchronized (layoutLayer) {
            Point2d clusterSize = generator.clusterLayoutSize();
            this.layoutManager.addClusterGenerator(generator, generator.clusterNumber(), generator.selectable(), clusterSize.getX(), clusterSize.getY());
        }
    }
}

