/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.GeometryInfo;
import com.mousebird.maply.GeometryRawPoints;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Points;
import com.mousebird.maply.Proj4CoordSystem;
import com.mousebird.maply.QuadPagingLayer;
import com.mousebird.maply.Shader;
import java.io.File;
import java.io.FileNotFoundException;

public class LAZQuadReader
implements QuadPagingLayer.PagingInterface {
    GlobeController globeController;
    SQLiteDatabase tileDB;
    public int minPoints;
    public int maxPoints;
    public CoordSystem coordSys;
    String srs;
    protected Shader shader;
    private long nativeHandle;

    private LAZQuadReader() {
    }

    public LAZQuadReader(File sqliteDB, Settings settings, GlobeController inController) throws FileNotFoundException {
        this.initialise();
        this.globeController = inController;
        this.setZOffset(0.0);
        this.setPointSize(6.0f);
        this.setColorScale(255);
        this.tileDB = SQLiteDatabase.openDatabase((String)sqliteDB.getAbsolutePath(), null, (int)17);
        if (this.tileDB == null) {
            throw new FileNotFoundException("SQLite database not found: " + sqliteDB);
        }
        Cursor c = this.tileDB.rawQuery("SELECT * FROM manifest", null);
        if (c.getCount() > 0) {
            int maxColor;
            c.moveToFirst();
            double minX = c.getDouble(c.getColumnIndexOrThrow("minx"));
            double minY = c.getDouble(c.getColumnIndexOrThrow("miny"));
            double minZ = c.getDouble(c.getColumnIndexOrThrow("minz"));
            double maxX = c.getDouble(c.getColumnIndexOrThrow("maxx"));
            double maxY = c.getDouble(c.getColumnIndexOrThrow("maxy"));
            double maxZ = c.getDouble(c.getColumnIndexOrThrow("maxz"));
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            int minLevel = c.getInt(c.getColumnIndexOrThrow("minlevel"));
            int maxLevel = c.getInt(c.getColumnIndexOrThrow("maxlevel"));
            this.setZoomLevels(minLevel, maxLevel);
            this.minPoints = c.getInt(c.getColumnIndexOrThrow("minpoints"));
            this.maxPoints = c.getInt(c.getColumnIndexOrThrow("maxpoints"));
            this.setTilePoints(this.minPoints, this.maxPoints);
            this.srs = c.getString(c.getColumnIndexOrThrow("srs"));
            int pointType = 0;
            if (c.getColumnIndex("pointtype") >= 0) {
                pointType = c.getInt(c.getColumnIndex("pointtype"));
            }
            this.setPointType(pointType);
            if (c.getColumnIndex("maxcolor") >= 0 && (maxColor = c.getInt(c.getColumnIndex("maxcolor"))) > 300) {
                this.setColorScale(32768);
            }
            if (settings != null && settings.coordSystem != null) {
                this.setCoordSystem(settings.coordSystem);
            } else {
                Proj4CoordSystem coordSys = new Proj4CoordSystem(this.srs);
                Mbr mbr = new Mbr(new Point2d(this.getLL().getX(), this.getLL().getY()), new Point2d(this.getUR().getX(), this.getUR().getY()));
                coordSys.setBounds(mbr);
                this.setCoordSystem(coordSys);
            }
            if (settings != null && (double)settings.pointSize > 0.0) {
                this.setPointSize(settings.pointSize);
            }
            if (settings != null && settings.zOffset > 0.0) {
                this.setZOffset(settings.zOffset);
            }
            if (settings != null && settings.colorScale != 0) {
                this.setColorScale(settings.colorScale);
            }
        }
    }

    public boolean hasColor() {
        return this.getPointType() > 1;
    }

    private void setCoordSystem(CoordSystem inCoordSys) {
        this.coordSys = inCoordSys;
        this.setCoordSystemNative(this.coordSys);
    }

    public Point2d getCenter() {
        Point3d ll = this.getLL();
        Point3d ur = this.getUR();
        return new Point2d((ll.getX() + ur.getX()) / 2.0, (ll.getY() + ur.getY()) / 2.0);
    }

    public int getNumTilesFromMaxPoints(int maxPoints) {
        int numTiles = maxPoints / this.getMinTilePoints();
        if (numTiles < 1) {
            numTiles = 1;
        }
        if (numTiles > 256) {
            numTiles = 256;
        }
        return numTiles;
    }

    public native void setBounds(double var1, double var3, double var5, double var7, double var9, double var11);

    public native Point3d getLL();

    public native Point3d getUR();

    public native void setZOffset(double var1);

    public native double getZOffset();

    public native void setZoomLevels(int var1, int var2);

    public native int getMinZoom();

    public native int getMaxZoom();

    public native void setTilePoints(int var1, int var2);

    public native int getMinTilePoints();

    public native int getMaxTilePoints();

    public native void setPointSize(float var1);

    public native float getPointSize();

    public native void setColorScale(int var1);

    public native int getColorScale();

    public native void setPointType(int var1);

    public native int getPointType();

    public native void setCoordSystemNative(CoordSystem var1);

    public void setShader(Shader inShader) {
        this.shader = inShader;
        this.shader.setUniform("u_zmin", this.getLL().getZ());
        this.shader.setUniform("u_zmax", this.getUR().getZ());
    }

    @Override
    public int minZoom() {
        return this.getMinZoom();
    }

    @Override
    public int maxZoom() {
        return this.getMaxZoom();
    }

    @Override
    public void startFetchForTile(final QuadPagingLayer layer, final MaplyTileID tileID) {
        LayerThread layerThread = this.globeController.getWorkingThread();
        layerThread.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int quadIdx = 0;
                for (int iq = 0; iq < tileID.level; ++iq) {
                    quadIdx += (1 << iq) * (1 << iq);
                }
                quadIdx += tileID.y * (1 << tileID.level) + tileID.x;
                SQLiteDatabase sQLiteDatabase = LAZQuadReader.this.tileDB;
                synchronized (sQLiteDatabase) {
                    Cursor c = LAZQuadReader.this.tileDB.rawQuery("SELECT data FROM lidartiles WHERE quadindex=" + quadIdx + ";", null);
                    if (c.getCount() > 0) {
                        c.moveToFirst();
                        byte[] data = c.getBlob(c.getColumnIndexOrThrow("data"));
                        if (data != null) {
                            Points points = new Points();
                            Point3d tileCenter = new Point3d(0.0, 0.0, 0.0);
                            LAZQuadReader.this.processTileNative(LAZQuadReader.this.globeController.coordAdapter, data, points.rawPoints, tileCenter);
                            Matrix4d mat = Matrix4d.translate(tileCenter.getX(), tileCenter.getY(), tileCenter.getZ());
                            points.setMatrix(mat);
                            GeometryInfo geomInfo = new GeometryInfo();
                            geomInfo.setPointSize(LAZQuadReader.this.getPointSize());
                            geomInfo.setZBufferWrite(true);
                            geomInfo.setZBufferRead(true);
                            geomInfo.setShader(LAZQuadReader.this.shader);
                            geomInfo.setDrawPriority(10000000);
                            LAZQuadReader.this.globeController.addPoints(points, geomInfo, MaplyBaseController.ThreadMode.ThreadCurrent);
                        }
                    }
                }
                layer.tileDidLoad(tileID);
            }
        });
    }

    private native void processTileNative(CoordSystemDisplayAdapter var1, byte[] var2, GeometryRawPoints var3, Point3d var4);

    @Override
    public void tileDidUnload(MaplyTileID tileID) {
    }

    public void finalize() {
        this.dispose();
    }

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        LAZQuadReader.nativeInit();
    }

    public static class Settings {
        public CoordSystem coordSystem;
        public double zOffset = 0.0;
        public int colorScale = 32768;
        public float pointSize = 0.0f;
    }
}

