/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Color;
import com.mousebird.maply.Marker;
import com.mousebird.maply.MarkerInfo;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.ScreenMarker;

class InternalMarker {
    private long nativeHandle;

    InternalMarker() {
        this.initialise();
    }

    InternalMarker(ScreenMarker marker, MarkerInfo info) {
        this.initialise();
        this.setLoc(marker.loc);
        this.setColor((float)Color.red((int)marker.color) / 255.0f, (float)Color.green((int)marker.color) / 255.0f, (float)Color.blue((int)marker.color) / 255.0f, (float)Color.alpha((int)marker.color) / 255.0f);
        if (marker.rotation != 0.0) {
            this.setRotation(marker.rotation);
        }
        this.setWidth(marker.size.getX());
        this.setHeight(marker.size.getY());
        this.setLayoutImportance(marker.layoutImportance);
        this.setSelectable(marker.selectable);
        if (marker.offset == null) {
            this.setOffset(0.0, 0.0);
        } else {
            this.setOffset(marker.offset.getX(), marker.offset.getY());
        }
        if (marker.selectable) {
            this.setSelectID(marker.ident);
        }
    }

    InternalMarker(Marker marker, MarkerInfo info) {
        this.initialise();
        this.setLoc(marker.loc);
        this.setColor((float)Color.red((int)marker.color) / 255.0f, (float)Color.green((int)marker.color) / 255.0f, (float)Color.blue((int)marker.color) / 255.0f, (float)Color.alpha((int)marker.color) / 255.0f);
        this.setWidth(marker.size.getX());
        this.setHeight(marker.size.getY());
        this.setSelectable(marker.selectable);
        this.setPeriod(marker.period);
        if (marker.selectable) {
            this.setSelectID(marker.ident);
        }
    }

    public void finalize() {
        this.dispose();
    }

    public native void setSelectable(boolean var1);

    public native void setSelectID(long var1);

    public native void setLoc(Point2d var1);

    public native void setColor(float var1, float var2, float var3, float var4);

    public native void addTexID(long var1);

    public native void setLockRotation(boolean var1);

    public native void setHeight(double var1);

    public native void setWidth(double var1);

    public native void setRotation(double var1);

    public native void setOffset(double var1, double var3);

    public native void setLayoutImportance(double var1);

    public native void setVertexAttributes(Object[] var1);

    public native void setClusterGroup(int var1);

    public native void setPeriod(double var1);

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        InternalMarker.nativeInit();
    }
}

