/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.mousebird.maply.AngleAxis;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.GlobeAnimateMomentum;
import com.mousebird.maply.GlobeAnimateRotation;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.GlobeView;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Quaternion;

public class GlobeGestureHandler {
    GlobeController globeControl = null;
    GlobeView globeView = null;
    public boolean allowRotate = false;
    public boolean allowTilt = false;
    ScaleGestureDetector sgd = null;
    ScaleListener sl = null;
    GestureDetector gd = null;
    GestureListener gl = null;
    View view = null;
    double zoomLimitMin = 0.0;
    double zoomLimitMax = 1000.0;
    double startRot = Double.MAX_VALUE;
    double lastTouchedTime = 0.0;
    Handler autoRotateHandler = null;
    Runnable autoRunRunnable = null;
    GlobeAnimateMomentum rotateAnimation = null;
    final int AutoRotateCheckPeriod = 200;
    Point3d startRotAxis = null;
    Quaternion startRotQuat = null;
    double startTilt = Double.MAX_VALUE;
    double startTiltY = Double.MAX_VALUE;
    boolean possibleZoomOut = false;

    public GlobeGestureHandler(GlobeController inControl, View inView) {
        this.globeControl = inControl;
        this.globeView = this.globeControl.globeView;
        this.view = inView;
        this.sl = new ScaleListener(this.globeControl);
        this.sgd = new ScaleGestureDetector(this.view.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this.sl);
        this.gl = new GestureListener(this.globeControl);
        this.gd = new GestureDetector(this.view.getContext(), (GestureDetector.OnGestureListener)this.gl);
        this.sl.gl = this.gl;
        this.updateTouchedTime();
    }

    public void shutdown() {
        this.sgd = null;
        if (this.sl != null) {
            this.sl.maplyControl = null;
        }
        this.sl = null;
        this.gd = null;
        if (this.gl != null) {
            this.gl.globeControl = null;
        }
        this.gl = null;
        this.view = null;
    }

    void updateTouchedTime() {
        this.lastTouchedTime = (double)System.currentTimeMillis() / 1000.0;
        if (this.rotateAnimation != null) {
            this.globeView.cancelAnimation();
            this.rotateAnimation = null;
        }
    }

    public void setAutoRotate(final float autoRotateInterval, final float autoRotateDegrees) {
        if (this.autoRotateHandler != null) {
            this.autoRotateHandler.removeCallbacks(this.autoRunRunnable);
            this.autoRunRunnable = null;
            this.autoRotateHandler = null;
        }
        if ((double)autoRotateInterval < 0.0 || (double)autoRotateDegrees == 0.0) {
            return;
        }
        this.autoRunRunnable = new Runnable(){

            @Override
            public void run() {
                if (GlobeGestureHandler.this.globeControl == null || GlobeGestureHandler.this.globeControl.renderWrapper == null || GlobeGestureHandler.this.globeControl.renderWrapper.maplyRender == null) {
                    return;
                }
                double currentTime = (double)System.currentTimeMillis() / 1000.0;
                if (currentTime - GlobeGestureHandler.this.lastTouchedTime > (double)autoRotateInterval && GlobeGestureHandler.this.rotateAnimation == null) {
                    double anglePerSec = (double)autoRotateDegrees / 180.0 * Math.PI;
                    Point3d north = new Point3d(0.0, 0.0, 1.0);
                    GlobeGestureHandler.this.rotateAnimation = new GlobeAnimateMomentum(GlobeGestureHandler.this.globeView, GlobeGestureHandler.this.globeControl.renderWrapper.maplyRender, anglePerSec, 0.0, north, false);
                    GlobeGestureHandler.this.globeView.setAnimationDelegate(GlobeGestureHandler.this.rotateAnimation);
                }
                GlobeGestureHandler.this.autoRotateHandler = new Handler();
                GlobeGestureHandler.this.autoRotateHandler.postDelayed(GlobeGestureHandler.this.autoRunRunnable, 200L);
            }
        };
        this.autoRotateHandler = new Handler();
        this.autoRotateHandler.postDelayed(this.autoRunRunnable, 200L);
    }

    public void setZoomLimits(double inMin, double inMax) {
        this.zoomLimitMin = inMin;
        this.zoomLimitMax = inMax;
    }

    public static boolean withinBounds(GlobeView globeView, Point2d frameSize, Point3d newPos) {
        return true;
    }

    void handleRotation(MotionEvent event) {
        if (this.allowRotate) {
            MotionEvent.PointerCoords p0 = new MotionEvent.PointerCoords();
            MotionEvent.PointerCoords p1 = new MotionEvent.PointerCoords();
            event.getPointerCoords(0, p0);
            event.getPointerCoords(1, p1);
            double cX = (double)(p0.x + p1.x) / 2.0;
            double cY = (double)(p0.y + p1.y) / 2.0;
            double dx = (double)p0.x - cX;
            double dy = (double)p0.y - cY;
            if (this.startRot == Double.MAX_VALUE) {
                this.startRot = Math.atan2(dy, dx);
                Point2d center = new Point2d(event.getX(), event.getY());
                Matrix4d modelTransform = this.globeView.calcModelViewMatrix();
                this.startRotAxis = this.globeView.pointOnSphereFromScreen(center, modelTransform, this.globeControl.getViewSize(), false);
                this.startRotQuat = this.globeView.getRotQuat();
            } else if (this.startRotAxis != null) {
                double curRot = Math.atan2(dy, dx);
                double diffRot = curRot - this.startRot;
                AngleAxis rotQuat = new AngleAxis(-diffRot, this.startRotAxis);
                Quaternion newRotQuat = this.startRotQuat.multiply(rotQuat);
                this.globeView.setRotQuat(newRotQuat);
                if (Math.abs(diffRot) > 0.05235987755982988) {
                    this.possibleZoomOut = false;
                }
            }
        }
    }

    void cancelRotation() {
        this.startRot = Double.MAX_VALUE;
        this.startRotAxis = null;
        this.startRotQuat = null;
        this.sl.isActive = false;
    }

    void handleTilt(MotionEvent event) {
        if (this.startTiltY == Double.MAX_VALUE) {
            this.startTilt = this.globeView.getTilt();
            this.startTiltY = event.getY();
        } else {
            double scale = ((double)event.getY() - this.startTiltY) / this.globeControl.getViewSize().getX();
            double move = scale * Math.PI / 4.0;
            double maxTilt = 1.5707963267948966;
            double newTilt = move + this.startTilt;
            this.globeView.setTilt(Math.min(Math.max(0.0, newTilt), maxTilt));
        }
    }

    void cancelTilt() {
        this.startTilt = Double.MAX_VALUE;
        this.startTiltY = Double.MAX_VALUE;
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean tiltWasActive;
        boolean slWasActive = this.sl.isActive;
        boolean glWasActive = this.gl.isActive;
        boolean rotWasActive = this.startRot != Double.MAX_VALUE;
        boolean bl = tiltWasActive = this.startTilt != Double.MAX_VALUE;
        if (event.getPointerCount() >= 2) {
            this.gl.isActive = false;
        }
        if (this.allowTilt) {
            if (event.getPointerCount() == 3) {
                this.handleTilt(event);
                this.gl.isActive = false;
                this.sl.isActive = false;
                this.possibleZoomOut = false;
            } else {
                this.cancelTilt();
            }
        }
        this.sgd.onTouchEvent(event);
        if (this.allowRotate) {
            if (event.getPointerCount() == 2 && event.getActionMasked() == 2 || event.getActionMasked() == 5) {
                this.handleRotation(event);
            } else {
                this.cancelRotation();
            }
        }
        if (!this.sl.isActive && event.getPointerCount() == 1) {
            this.gd.onTouchEvent(event);
            if (event.getAction() == 1) {
                this.gl.isActive = false;
            }
        }
        if (!(this.sl.isActive || this.gl.isActive || slWasActive || tiltWasActive || event.getPointerCount() != 2 || event.getActionMasked() != 5)) {
            this.possibleZoomOut = true;
        }
        if (event.getActionMasked() == 6 && this.possibleZoomOut) {
            double newHeight = this.globeView.getHeight() * 2.0;
            newHeight = Math.min(newHeight, this.zoomLimitMax);
            newHeight = Math.max(newHeight, this.zoomLimitMin);
            this.globeView.setAnimationDelegate(new GlobeAnimateRotation(this.globeView, this.globeControl.renderWrapper.maplyRender, this.globeView.getRotQuat(), newHeight, 0.5));
            this.sl.isActive = false;
            this.gl.isActive = false;
            this.possibleZoomOut = false;
        }
        if (!glWasActive && this.gl.isActive) {
            this.globeControl.panDidStart(true);
        }
        if (glWasActive && !this.gl.isActive) {
            this.globeControl.panDidEnd(true);
        }
        if (!slWasActive && this.sl.isActive) {
            this.globeControl.zoomDidStart(true);
        }
        if (slWasActive && !this.sl.isActive) {
            this.globeControl.zoomDidEnd(true);
        }
        if (!rotWasActive && this.startRot != Double.MAX_VALUE) {
            this.globeControl.rotateDidStart(true);
        }
        if (rotWasActive && this.startRot == Double.MAX_VALUE) {
            this.globeControl.rotateDidEnd(true);
        }
        if (!tiltWasActive && this.startTilt != Double.MAX_VALUE) {
            this.globeControl.tiltDidStart(true);
        }
        if (tiltWasActive && this.startTilt == Double.MAX_VALUE) {
            this.globeControl.tiltDidEnd(true);
        }
        this.updateTouchedTime();
        return true;
    }

    private class GestureListener
    implements GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener {
        public GlobeController globeControl;
        public boolean isActive = false;
        Point2d startScreenPos = null;
        Point3d startPos = null;
        Point3d startOnSphere = null;
        Quaternion startQuat = null;
        Matrix4d startTransform = null;
        static final double AnimMomentumTime = 1.0;

        GestureListener(GlobeController inMaplyControl) {
            this.globeControl = inMaplyControl;
        }

        public boolean onDown(MotionEvent e) {
            if (this.globeControl.renderWrapper == null || this.globeControl.renderWrapper.maplyRender == null) {
                return false;
            }
            this.startScreenPos = new Point2d(e.getX(), e.getY());
            this.startTransform = this.globeControl.globeView.calcModelViewMatrix();
            this.startPos = this.globeControl.globeView.getLoc();
            this.startOnSphere = this.globeControl.globeView.pointOnSphereFromScreen(this.startScreenPos, this.startTransform, this.globeControl.getViewSize(), false);
            this.startQuat = this.globeControl.globeView.getRotQuat();
            this.isActive = this.startOnSphere != null;
            GlobeGestureHandler.this.updateTouchedTime();
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!this.isActive) {
                return false;
            }
            Point2d newScreenPos = new Point2d(e2.getX(), e2.getY());
            Point3d hit = this.globeControl.globeView.pointOnSphereFromScreen(newScreenPos, this.startTransform, this.globeControl.getViewSize(), false);
            if (hit != null) {
                Point3d northPole;
                GlobeGestureHandler.this.globeView.cancelAnimation();
                Quaternion endRot = new Quaternion(this.startOnSphere, hit);
                Quaternion newRotQuat = this.startQuat.multiply(endRot);
                if (GlobeGestureHandler.this.globeView.northUp && (northPole = newRotQuat.multiply(new Point3d(0.0, 0.0, 1.0)).normalized()).getY() != 0.0) {
                    Point3d newUp = GlobeGestureHandler.this.globeView.prospectiveUp(newRotQuat);
                    double ang = Math.atan(northPole.getX() / northPole.getY());
                    if (northPole.getY() < 0.0) {
                        ang += Math.PI;
                    }
                    AngleAxis upRot = new AngleAxis(ang, newUp);
                    newRotQuat = newRotQuat.multiply(upRot);
                }
                this.globeControl.globeView.setRotQuat(newRotQuat);
            }
            GlobeGestureHandler.this.updateTouchedTime();
            return true;
        }

        Point3d pointOnPlaneFromScreen(Point2d touch, Matrix4d transform, Point2d frameSize) {
            Point3d screenPt = GlobeGestureHandler.this.globeView.pointUnproject(touch, frameSize, false);
            screenPt.normalize();
            if (screenPt.getZ() == 0.0) {
                return null;
            }
            double t = -GlobeGestureHandler.this.globeView.getHeight() / screenPt.getZ();
            return screenPt.multiplyBy(t);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            Point2d frameSize = this.globeControl.getViewSize();
            Point2d touch0 = new Point2d(e1.getX(), e1.getY());
            Point2d touch1 = touch0.addTo(new Point2d(1.0 * (double)velocityX, 1.0 * (double)velocityY));
            Point3d p0 = GlobeGestureHandler.this.globeView.pointUnproject(touch0, frameSize, false);
            Point3d p1 = GlobeGestureHandler.this.globeView.pointUnproject(touch1, frameSize, false);
            Matrix4d modelMat = GlobeGestureHandler.this.globeView.calcModelViewMatrix();
            Matrix4d invModelMat = modelMat.inverse();
            Point4d model_p0_4d = invModelMat.multiply(new Point4d(p0, 1.0));
            Point4d model_p1_4d = invModelMat.multiply(new Point4d(p1, 1.0));
            Point3d model_p0 = new Point3d(model_p0_4d.getX() / model_p0_4d.getW(), model_p0_4d.getY() / model_p0_4d.getW(), model_p0_4d.getZ());
            Point3d model_p1 = new Point3d(model_p1_4d.getX() / model_p1_4d.getW(), model_p1_4d.getY() / model_p1_4d.getW(), model_p1_4d.getZ());
            Point3d pt0 = this.pointOnPlaneFromScreen(touch0, this.startTransform, frameSize);
            Point3d pt1 = this.pointOnPlaneFromScreen(touch1, this.startTransform, frameSize);
            if (pt0 != null && pt1 != null) {
                double modelVel;
                Point3d dir = pt0.subtract(pt1);
                dir.multiplyBy(-1.0);
                double len = dir.length();
                dir = dir.multiplyBy(1.0 / len);
                double angVel = modelVel = len / 1.0;
                model_p0.normalize();
                model_p1.normalize();
                Point3d rotAxis = model_p0.cross(model_p1).normalized();
                double accel = -angVel / 1.0;
                if (angVel > 0.0) {
                    GlobeGestureHandler.this.globeView.setAnimationDelegate(new GlobeAnimateMomentum(GlobeGestureHandler.this.globeView, this.globeControl.renderWrapper.maplyRender, angVel, accel, rotAxis, GlobeGestureHandler.this.globeView.northUp));
                }
            }
            GlobeGestureHandler.this.updateTouchedTime();
            this.isActive = false;
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (e.getPointerCount() == 1) {
                this.globeControl.processLongPress(new Point2d(e.getX(), e.getY()));
            }
            GlobeGestureHandler.this.updateTouchedTime();
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            GlobeGestureHandler.this.updateTouchedTime();
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            GlobeGestureHandler.this.updateTouchedTime();
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            this.globeControl.processTap(new Point2d(e.getX(), e.getY()));
            GlobeGestureHandler.this.updateTouchedTime();
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            Matrix4d mapTransform;
            CoordSystemDisplayAdapter coordAdapter = GlobeGestureHandler.this.globeView.getCoordAdapter();
            Point2d frameSize = this.globeControl.getViewSize();
            Point2d touch = new Point2d(e.getX(), e.getY());
            Point3d pt = GlobeGestureHandler.this.globeView.pointOnSphereFromScreen(touch, mapTransform = GlobeGestureHandler.this.globeView.calcModelViewMatrix(), frameSize, false);
            if (pt == null) {
                return false;
            }
            Point3d localPt = coordAdapter.displayToLocal(pt);
            if (localPt == null) {
                return false;
            }
            Point3d geoCoord = coordAdapter.getCoordSystem().localToGeographic(localPt);
            if (pt != null || geoCoord != null) {
                double height = GlobeGestureHandler.this.globeView.getHeight();
                double newHeight = height / 2.0;
                newHeight = Math.min(newHeight, GlobeGestureHandler.this.zoomLimitMax);
                newHeight = Math.max(newHeight, GlobeGestureHandler.this.zoomLimitMin);
                Quaternion newQuat = GlobeGestureHandler.this.globeView.makeRotationToGeoCoord(geoCoord.getX(), geoCoord.getY(), GlobeGestureHandler.this.globeView.northUp);
                GlobeGestureHandler.this.globeView.setAnimationDelegate(new GlobeAnimateRotation(GlobeGestureHandler.this.globeView, this.globeControl.renderWrapper.maplyRender, newQuat, newHeight, 0.5));
            }
            GlobeGestureHandler.this.updateTouchedTime();
            this.isActive = false;
            return true;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public GlobeController maplyControl;
        double startZ;
        float startDist;
        GestureListener gl = null;
        public boolean isActive = false;
        Point3d centerGeoCoord = null;

        ScaleListener(GlobeController inMaplyControl) {
            this.maplyControl = inMaplyControl;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            Matrix4d modelTransform;
            this.startZ = this.maplyControl.globeView.getLoc().getZ();
            this.startDist = detector.getCurrentSpan();
            Point2d center = new Point2d(detector.getFocusX(), detector.getFocusY());
            Point3d hit = this.maplyControl.globeView.pointOnSphereFromScreen(center, modelTransform = this.maplyControl.globeView.calcModelViewMatrix(), this.maplyControl.getViewSize(), false);
            Point3d localPt = GlobeGestureHandler.this.globeView.coordAdapter.displayToLocal(hit);
            if (localPt == null) {
                return false;
            }
            this.centerGeoCoord = GlobeGestureHandler.this.globeView.coordAdapter.getCoordSystem().localToGeographic(localPt);
            if (this.gl != null) {
                this.gl.isActive = false;
            }
            this.isActive = true;
            GlobeGestureHandler.this.updateTouchedTime();
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float curDist = detector.getCurrentSpan();
            if ((double)curDist > 0.0 && (double)this.startDist > 0.0) {
                float scale = this.startDist / curDist;
                Point3d pos = this.maplyControl.globeView.getLoc();
                GlobeGestureHandler.this.globeView.cancelAnimation();
                Point3d newPos = new Point3d(pos.getX(), pos.getY(), this.startZ * (double)scale);
                if (GlobeGestureHandler.withinBounds(GlobeGestureHandler.this.globeView, this.maplyControl.getViewSize(), newPos)) {
                    double newZ = newPos.getZ();
                    newZ = Math.min(newZ, GlobeGestureHandler.this.zoomLimitMax);
                    newZ = Math.max(newZ, GlobeGestureHandler.this.zoomLimitMin);
                    this.maplyControl.globeView.setLoc(new Point3d(newPos.getX(), newPos.getY(), newZ));
                }
                if (Math.abs(this.startDist - curDist) > 10.0f) {
                    GlobeGestureHandler.this.possibleZoomOut = false;
                }
                return true;
            }
            GlobeGestureHandler.this.updateTouchedTime();
            this.isActive = false;
            return false;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.isActive = false;
            GlobeGestureHandler.this.updateTouchedTime();
        }
    }
}

