/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.app.Activity;
import android.view.Choreographer;
import android.view.MotionEvent;
import android.view.View;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.FakeGeocentricDisplayAdapter;
import com.mousebird.maply.GlobeAnimateRotation;
import com.mousebird.maply.GlobeGestureHandler;
import com.mousebird.maply.GlobeScene;
import com.mousebird.maply.GlobeView;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Quaternion;
import com.mousebird.maply.SelectedObject;
import java.util.List;

public class GlobeController
extends MaplyBaseController
implements View.OnTouchListener,
Choreographer.FrameCallback {
    Settings defaultSettings = new Settings();
    GlobeView globeView = null;
    GlobeScene globeScene = null;
    GlobeGestureHandler gestureHandler = null;
    public GestureDelegate gestureDelegate = null;
    boolean isTilting = false;
    boolean isPanning = false;
    boolean isZooming = false;
    boolean isRotating = false;
    boolean isAnimating = false;
    double lastViewUpdate = 0.0;

    public GlobeController(Activity mainActivity, Settings settings) {
        super(mainActivity, settings);
        this.Init(mainActivity, settings.clearColor);
    }

    public GlobeController(Activity mainActivity) {
        super(mainActivity, null);
        this.Init(mainActivity, this.clearColor);
    }

    protected void Init(Activity mainActivity, int clearColor) {
        this.coordAdapter = new FakeGeocentricDisplayAdapter();
        this.globeScene = new GlobeScene(this.coordAdapter, 1);
        this.scene = this.globeScene;
        this.globeView = new GlobeView(this, this.coordAdapter);
        this.view = this.globeView;
        this.globeView.northUp = true;
        this.globeView.setContinuousZoom(true);
        super.setClearColor(clearColor);
        super.Init();
        if (this.baseView != null) {
            this.baseView.setOnTouchListener((View.OnTouchListener)this);
            this.gestureHandler = new GlobeGestureHandler(this, this.baseView);
        }
        this.addPostSurfaceRunnable(new Runnable(){

            @Override
            public void run() {
                GlobeController.this.resetLights();
            }
        });
    }

    @Override
    public void shutdown() {
        Choreographer c = Choreographer.getInstance();
        if (c != null) {
            c.removeFrameCallback((Choreographer.FrameCallback)this);
        }
        this.globeView.cancelAnimation();
        super.shutdown();
        this.globeView = null;
        this.globeScene = null;
        if (this.gestureHandler != null) {
            this.gestureHandler.shutdown();
        }
        this.gestureDelegate = null;
        this.gestureHandler = null;
    }

    public GlobeView getGlobeView() {
        return this.globeView;
    }

    public boolean getKeepNorthUp() {
        return this.globeView.northUp;
    }

    public void setKeepNorthUp(boolean newVal) {
        if (this.globeView != null) {
            this.globeView.northUp = newVal;
        }
        if (this.gestureHandler != null) {
            this.gestureHandler.allowRotate = !newVal;
        }
    }

    public void setAllowTilt(boolean allowTilt) {
        if (this.gestureHandler != null) {
            this.gestureHandler.allowTilt = allowTilt;
        }
    }

    @Override
    public Point2d screenPointFromGeo(Point2d geoCoord) {
        return this.screenPointFromGeo(this.globeView, geoCoord);
    }

    public void setZoomLimits(double inMin, double inMax) {
        if (this.gestureHandler != null) {
            this.gestureHandler.setZoomLimits(inMin, inMax);
        }
    }

    @Override
    public Point2d geoPointFromScreen(Point2d screenPt) {
        CoordSystemDisplayAdapter coordAdapter = this.globeView.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        Matrix4d modelMat = this.globeView.calcModelViewMatrix();
        Point3d dispPt = this.globeView.pointOnSphereFromScreen(screenPt, modelMat, this.renderWrapper.maplyRender.frameSize, false);
        if (dispPt == null) {
            return null;
        }
        Point3d localPt = coordAdapter.displayToLocal(dispPt);
        if (localPt == null) {
            return null;
        }
        Point3d geoCoord = coordSys.localToGeographic(localPt);
        if (geoCoord == null) {
            return null;
        }
        return new Point2d(geoCoord.getX(), geoCoord.getY());
    }

    public Mbr getCurrentViewGeo() {
        Mbr geoMbr = new Mbr();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        Point2d pt = this.geoPointFromScreen(new Point2d(0.0, 0.0));
        if (pt == null) {
            return null;
        }
        geoMbr.addPoint(pt);
        pt = this.geoPointFromScreen(new Point2d(frameSize.getX(), 0.0));
        if (pt == null) {
            return null;
        }
        geoMbr.addPoint(pt);
        pt = this.geoPointFromScreen(new Point2d(frameSize.getX(), frameSize.getY()));
        if (pt == null) {
            return null;
        }
        geoMbr.addPoint(pt);
        pt = this.geoPointFromScreen(new Point2d(0.0, frameSize.getY()));
        if (pt == null) {
            return null;
        }
        geoMbr.addPoint(pt);
        return geoMbr;
    }

    double checkPointAndNormFacing(Point3d dispLoc, Point3d norm, Matrix4d mat, Matrix4d normMat) {
        Point4d pt = mat.multiply(new Point4d(dispLoc.getX(), dispLoc.getY(), dispLoc.getZ(), 1.0));
        double x = pt.getX() / pt.getW();
        double y = pt.getY() / pt.getW();
        double z = pt.getZ() / pt.getW();
        Point4d testDir = normMat.multiply(new Point4d(norm.getX(), norm.getY(), norm.getZ(), 0.0));
        Point3d pt3d = new Point3d(-x, -y, -z);
        return pt3d.dot(new Point3d(testDir.getX(), testDir.getY(), testDir.getZ()));
    }

    private Point2d screenPointFromGeo(GlobeView theGlobeView, Point2d geoCoord) {
        CoordSystemDisplayAdapter coordAdapter = theGlobeView.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        Point3d localPt = coordSys.geographicToLocal(new Point3d(geoCoord.getX(), geoCoord.getY(), 0.0));
        if (localPt == null) {
            return null;
        }
        Point3d dispPt = coordAdapter.localToDisplay(localPt);
        if (dispPt == null) {
            return null;
        }
        Matrix4d modelMat = theGlobeView.calcModelViewMatrix();
        Matrix4d modelNormalMat = modelMat.inverse().transpose();
        if (this.checkPointAndNormFacing(dispPt, dispPt.normalized(), modelMat, modelNormalMat) < 0.0) {
            return null;
        }
        return theGlobeView.pointOnScreenFromSphere(dispPt, modelMat, this.renderWrapper.maplyRender.frameSize);
    }

    public Point3d displayPointFromGeo(Point3d geoPt) {
        CoordSystemDisplayAdapter coordAdapter = this.globeView.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        Point3d localPt = coordSys.geographicToLocal(geoPt);
        if (localPt == null) {
            return null;
        }
        Point3d dispPt = coordAdapter.localToDisplay(localPt);
        return dispPt;
    }

    boolean checkCoverage(Mbr mbr, GlobeView theGlobeView, double height) {
        Point2d centerLoc = mbr.middle();
        Point3d localCoord = theGlobeView.coordAdapter.coordSys.geographicToLocal(new Point3d(centerLoc.getX(), centerLoc.getY(), 0.0));
        theGlobeView.setLoc(new Point3d(localCoord.getX(), localCoord.getY(), height));
        List<Point2d> pts = mbr.asPoints();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        for (Point2d pt : pts) {
            Point2d screenPt = this.screenPointFromGeo(theGlobeView, pt);
            if (!(screenPt.getX() < 0.0 || screenPt.getY() < 0.0 || screenPt.getX() > frameSize.getX()) && !(screenPt.getY() > frameSize.getY())) continue;
            return false;
        }
        return true;
    }

    public double findHeightToViewBounds(Mbr mbr, Point2d pos) {
        GlobeView newGlobeView = this.globeView.clone();
        newGlobeView.setLoc(new Point3d(pos.getX(), pos.getY(), 2.0));
        double minHeight = newGlobeView.minHeightAboveSurface();
        double maxHeight = newGlobeView.maxHeightAboveSurface();
        boolean minOnScreen = this.checkCoverage(mbr, newGlobeView, minHeight);
        boolean maxOnScreen = this.checkCoverage(mbr, newGlobeView, maxHeight);
        if (!minOnScreen && !maxOnScreen) {
            return this.globeView.getHeight();
        }
        if (minOnScreen) {
            return minHeight;
        }
        double minRange = 1.0E-5;
        do {
            double midHeight = (minHeight + maxHeight) / 2.0;
            boolean midOnScreen = this.checkCoverage(mbr, newGlobeView, midHeight);
            if (!minOnScreen && midOnScreen) {
                maxHeight = midHeight;
                maxOnScreen = midOnScreen;
                continue;
            }
            if (midOnScreen || !maxOnScreen) break;
            this.checkCoverage(mbr, newGlobeView, midHeight);
            minHeight = midHeight;
            minOnScreen = midOnScreen;
        } while (!(maxHeight - minHeight < minRange));
        return maxHeight;
    }

    public void setViewState(ViewState viewState) {
        if (!this.isCompletelySetup()) {
            return;
        }
        this.globeView.cancelAnimation();
        Point3d newPos = this.globeView.getLoc();
        if (viewState.pos != null) {
            Point3d localCoord;
            newPos = localCoord = this.globeView.coordAdapter.coordSys.geographicToLocal(new Point3d(viewState.pos.getX(), viewState.pos.getY(), 0.0));
        }
        double newHeight = this.globeView.getHeight();
        if (viewState.height != Double.MAX_VALUE) {
            newHeight = viewState.height;
        }
        if (viewState.pos != null) {
            this.globeView.setLoc(new Point3d(newPos.getX(), newPos.getY(), newHeight));
        }
        if (viewState.tilt != Double.MAX_VALUE) {
            this.globeView.setTilt(viewState.tilt);
        }
        if (viewState.height != Double.MAX_VALUE && !this.getKeepNorthUp()) {
            this.globeView.setHeading(viewState.heading);
        }
    }

    public ViewState getViewState() {
        Point3d loc = this.globeView.getLoc();
        if (loc == null) {
            return null;
        }
        Point3d geoLoc = this.globeView.coordAdapter.coordSys.localToGeographic(loc);
        ViewState viewState = new ViewState();
        viewState.pos = new Point2d(geoLoc.getX(), geoLoc.getY());
        viewState.height = geoLoc.getZ();
        viewState.heading = this.globeView.getHeading();
        viewState.tilt = this.globeView.getTilt();
        return viewState;
    }

    public void setPositionGeo(final double x, final double y, final double z) {
        if (!this.isCompletelySetup()) {
            return;
        }
        if (!this.isCompletelySetup()) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    GlobeController.this.setPositionGeo(x, y, z);
                }
            });
            return;
        }
        this.globeView.cancelAnimation();
        Point3d geoCoord = this.globeView.coordAdapter.coordSys.geographicToLocal(new Point3d(x, y, 0.0));
        this.globeView.setLoc(new Point3d(geoCoord.getX(), geoCoord.getY(), z));
    }

    public Point3d getPositionGeo() {
        if (!this.isCompletelySetup()) {
            return null;
        }
        Point3d loc = this.globeView.getLoc();
        if (loc == null) {
            return null;
        }
        Point3d geoLoc = this.globeView.coordAdapter.coordSys.localToGeographic(loc);
        return new Point3d(geoLoc.getX(), geoLoc.getY(), loc.getZ());
    }

    protected boolean isCompletelySetup() {
        return this.running && this.globeView != null && this.renderWrapper != null && this.renderWrapper.maplyRender != null && this.renderWrapper.maplyRender.frameSize != null;
    }

    public void animatePositionGeo(final double x, final double y, final double z, final double howLong) {
        Quaternion newQuat;
        if (!this.isCompletelySetup()) {
            if (!this.rendererAttached) {
                this.addPostSurfaceRunnable(new Runnable(){

                    @Override
                    public void run() {
                        GlobeController.this.animatePositionGeo(x, y, z, howLong);
                    }
                });
            }
            return;
        }
        this.globeView.cancelAnimation();
        Point3d geoCoord = this.globeView.coordAdapter.coordSys.geographicToLocal(new Point3d(x, y, 0.0));
        if (geoCoord != null && (newQuat = this.globeView.makeRotationToGeoCoord(x, y, this.globeView.northUp)) != null) {
            this.globeView.setAnimationDelegate(new GlobeAnimateRotation(this.globeView, this.renderWrapper.maplyRender, newQuat, z, howLong));
        }
    }

    public void setHeading(double heading) {
        if (!this.isCompletelySetup()) {
            return;
        }
        this.globeView.cancelAnimation();
    }

    public void setAutoRotate(float autoRotateInterval, float autoRotateDegrees) {
        if (!this.isCompletelySetup()) {
            return;
        }
        if (this.gestureHandler != null) {
            this.gestureHandler.setAutoRotate(autoRotateInterval, autoRotateDegrees);
        }
    }

    public void processTap(Point2d screenLoc) {
        if (!this.isCompletelySetup()) {
            return;
        }
        if (this.gestureDelegate != null) {
            SelectedObject[] selObjs;
            Matrix4d globeTransform = this.globeView.calcModelViewMatrix();
            Point3d loc = this.globeView.pointOnSphereFromScreen(screenLoc, globeTransform, this.getViewSize(), false);
            if (loc == null) {
                this.gestureDelegate.userDidTapOutside(this, screenLoc);
                return;
            }
            Point3d localPt = this.globeView.getCoordAdapter().displayToLocal(loc);
            Point3d geoPt = null;
            if (localPt != null) {
                geoPt = this.globeView.getCoordAdapter().getCoordSystem().localToGeographic(localPt);
            }
            if ((selObjs = this.getObjectsAtScreenLoc(screenLoc)) != null) {
                if (geoPt != null) {
                    this.gestureDelegate.userDidSelect(this, selObjs, geoPt.toPoint2d(), screenLoc);
                }
            } else if (geoPt != null) {
                this.gestureDelegate.userDidTap(this, geoPt.toPoint2d(), screenLoc);
            }
        }
    }

    public void processLongPress(Point2d screenLoc) {
        if (!this.isCompletelySetup()) {
            return;
        }
        Matrix4d globeTransform = this.globeView.calcModelViewMatrix();
        Point3d loc = this.globeView.pointOnSphereFromScreen(screenLoc, globeTransform, this.renderWrapper.maplyRender.frameSize, false);
        if (loc == null) {
            return;
        }
        Point3d localPt = this.globeView.getCoordAdapter().displayToLocal(loc);
        Point3d geoPt = null;
        if (localPt != null) {
            geoPt = this.globeView.getCoordAdapter().getCoordSystem().localToGeographic(localPt);
        }
        if (this.gestureDelegate != null) {
            SelectedObject[] selObjs = this.getObjectsAtScreenLoc(screenLoc);
            this.gestureDelegate.userDidLongPress(this, selObjs, geoPt.toPoint2d(), screenLoc);
        }
    }

    public boolean onTouch(View view, MotionEvent e) {
        if (this.gestureHandler != null) {
            return this.gestureHandler.onTouch(view, e);
        }
        return false;
    }

    public void tiltDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isTilting = true;
    }

    public void tiltDidEnd(boolean userMotion) {
        this.isTilting = false;
        this.handleStopMoving(userMotion);
    }

    public void panDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isPanning = true;
    }

    public void panDidEnd(boolean userMotion) {
        this.isPanning = false;
        this.handleStopMoving(userMotion);
    }

    public void zoomDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isZooming = true;
    }

    public void zoomDidEnd(boolean userMotion) {
        this.isZooming = false;
        this.handleStopMoving(userMotion);
    }

    public void rotateDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isRotating = true;
    }

    public void rotateDidEnd(boolean userMotion) {
        this.isRotating = false;
        this.handleStopMoving(userMotion);
    }

    public void handleStartMoving(boolean userMotion) {
        if (!userMotion) {
            this.isAnimating = true;
        }
        if (!this.isCompletelySetup()) {
            return;
        }
        if (!(this.isPanning || this.isRotating || this.isZooming || this.isAnimating || this.isTilting || this.gestureDelegate == null)) {
            this.gestureDelegate.globeDidStartMoving(this, userMotion);
            Choreographer c = Choreographer.getInstance();
            if (c != null) {
                c.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }
    }

    public void handleStopMoving(boolean userMotion) {
        if (!userMotion) {
            this.isAnimating = false;
        }
        if (!this.isCompletelySetup()) {
            return;
        }
        if (this.isPanning || this.isRotating || this.isZooming || this.isAnimating || this.isTilting) {
            return;
        }
        if (this.gestureDelegate != null) {
            Point3d[] corners = this.getVisibleCorners();
            this.gestureDelegate.globeDidStopMoving(this, corners, userMotion);
        }
    }

    public void doFrame(long frameTimeNanos) {
        Choreographer c;
        if (this.globeView != null) {
            double newUpdateTime = this.globeView.getLastUpdatedTime();
            if (this.gestureDelegate != null && this.lastViewUpdate < newUpdateTime) {
                Point3d[] corners = this.getVisibleCorners();
                this.gestureDelegate.globeDidMove(this, corners, false);
                this.lastViewUpdate = newUpdateTime;
            }
        }
        if ((c = Choreographer.getInstance()) != null) {
            c.removeFrameCallback((Choreographer.FrameCallback)this);
            c.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    public Point3d[] getVisibleCorners() {
        if (!this.isCompletelySetup()) {
            return null;
        }
        Point2d[] screenCorners = new Point2d[4];
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        screenCorners[0] = new Point2d(0.0, 0.0);
        screenCorners[1] = new Point2d(frameSize.getX(), 0.0);
        screenCorners[2] = new Point2d(frameSize.getX(), frameSize.getY());
        screenCorners[3] = new Point2d(0.0, frameSize.getY());
        Matrix4d modelMat = this.globeView.calcModelViewMatrix();
        Point3d[] retCorners = new Point3d[4];
        CoordSystemDisplayAdapter coordAdapter = this.globeView.getCoordAdapter();
        if (coordAdapter == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return retCorners;
        }
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        if (coordSys == null) {
            return retCorners;
        }
        for (int ii = 0; ii < 4; ++ii) {
            Point3d globePt = this.globeView.pointOnSphereFromScreen(screenCorners[ii], modelMat, frameSize, false);
            if (globePt == null) continue;
            retCorners[ii] = coordSys.localToGeographic(coordAdapter.displayToLocal(globePt));
        }
        return retCorners;
    }

    public static interface GestureDelegate {
        public void userDidSelect(GlobeController var1, SelectedObject[] var2, Point2d var3, Point2d var4);

        public void userDidTap(GlobeController var1, Point2d var2, Point2d var3);

        public void userDidTapOutside(GlobeController var1, Point2d var2);

        public void userDidLongPress(GlobeController var1, SelectedObject[] var2, Point2d var3, Point2d var4);

        public void globeDidStartMoving(GlobeController var1, boolean var2);

        public void globeDidStopMoving(GlobeController var1, Point3d[] var2, boolean var3);

        public void globeDidMove(GlobeController var1, Point3d[] var2, boolean var3);
    }

    public class ViewState {
        public double heading = Double.MAX_VALUE;
        public double height = Double.MAX_VALUE;
        public double tilt = Double.MAX_VALUE;
        public Point2d pos = null;
    }

    public static class Settings
    extends MaplyBaseController.Settings {
        public int clearColor = -16777216;
    }
}

